/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.events;

import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.context.ApplicationEvent;

public class MetricEvent
extends ApplicationEvent {
    private final MetricType metricType;
    private final double metricValue;
    private final String methodSignature;
    private final String[] tags;

    public MetricEvent(Object source, MetricType metricType, String methodSignature, String ... tags) {
        this(source, metricType, -1L, methodSignature, tags);
    }

    public MetricEvent(Object source, MetricType metricType, String ... tags) {
        this(source, metricType, -1L, null, new String[0]);
    }

    @Deprecated
    public MetricEvent(Object source, MetricType metricType, AtomicInteger gaugeValue) {
        this(source, metricType, gaugeValue == null ? -1L : gaugeValue.longValue(), null, new String[0]);
    }

    public MetricEvent(Object source, MetricType metricType, long metricValue, String methodSignature, String ... tags) {
        super(source);
        this.metricType = metricType;
        this.tags = tags;
        this.methodSignature = methodSignature;
        this.metricValue = metricValue;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public String[] getTags() {
        return this.tags;
    }

    public double getMetricValue() {
        return this.metricValue;
    }

    public AtomicInteger getGaugeValue() {
        return new AtomicInteger((int)this.metricValue);
    }
}

