/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.endpoints;

import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@RestControllerEndpoint(enableByDefault=false, id="chaosmonkey")
public class ChaosMonkeyRestEndpoint {
    private ChaosMonkeySettings chaosMonkeySettings;

    public ChaosMonkeyRestEndpoint(ChaosMonkeySettings chaosMonkeySettings) {
        this.chaosMonkeySettings = chaosMonkeySettings;
    }

    @PostMapping(value={"/assaults"})
    public ResponseEntity<String> updateAssaultProperties(@RequestBody @Validated AssaultProperties assaultProperties) {
        this.chaosMonkeySettings.setAssaultProperties(assaultProperties);
        return ResponseEntity.ok().body((Object)"Assault config has changed");
    }

    @GetMapping(value={"/assaults"})
    public AssaultProperties getAssaultSettings() {
        return this.chaosMonkeySettings.getAssaultProperties();
    }

    @PostMapping(value={"/enable"})
    public ResponseEntity<String> enableChaosMonkey() {
        this.chaosMonkeySettings.getChaosMonkeyProperties().setEnabled(true);
        return ResponseEntity.ok().body((Object)"Chaos Monkey is enabled");
    }

    @PostMapping(value={"/disable"})
    public ResponseEntity<String> disableChaosMonkey() {
        this.chaosMonkeySettings.getChaosMonkeyProperties().setEnabled(false);
        return ResponseEntity.ok().body((Object)"Chaos Monkey is disabled");
    }

    @GetMapping
    public ChaosMonkeySettings status() {
        return this.chaosMonkeySettings;
    }

    @GetMapping(value={"/status"})
    public ResponseEntity<String> getStatus() {
        if (this.chaosMonkeySettings.getChaosMonkeyProperties().isEnabled()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)"Ready to be evil!");
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE).body((Object)"You switched me off!");
    }

    @GetMapping(value={"/watcher"})
    public WatcherProperties getWatcherSettings() {
        return this.chaosMonkeySettings.getWatcherProperties();
    }
}

