/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.watcher;

import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkey;
import de.codecentric.spring.boot.chaos.monkey.watcher.ChaosMonkeyBaseAspect;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class SpringComponentAspect
extends ChaosMonkeyBaseAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringComponentAspect.class);
    private final ChaosMonkey chaosMonkey;

    public SpringComponentAspect(ChaosMonkey chaosMonkey) {
        this.chaosMonkey = chaosMonkey;
    }

    @Pointcut(value="within(@org.springframework.stereotype.Component *)")
    public void classAnnotatedWithComponentPointcut() {
    }

    @Pointcut(value="execution(* *.*(..))")
    public void allPublicMethodPointcut() {
    }

    @Around(value="classAnnotatedWithComponentPointcut() && allPublicMethodPointcut() && !classInChaosMonkeyPackage()")
    public Object intercept(ProceedingJoinPoint pjp) throws Throwable {
        LOGGER.debug(LOGGER.isDebugEnabled() ? "Component class and public method detected: " + pjp.getSignature() : null);
        this.chaosMonkey.callChaosMonkey();
        return pjp.proceed();
    }
}

