/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.component;

import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ChaosMonkey {
    private ChaosMonkeySettings chaosMonkeySettings;
    @Autowired
    private ApplicationContext context;
    private static final Logger LOGGER = LoggerFactory.getLogger(ChaosMonkey.class);

    public ChaosMonkey(ChaosMonkeySettings chaosMonkeySettings) {
        this.chaosMonkeySettings = chaosMonkeySettings;
    }

    public void callChaosMonkey() {
        if (this.isTrouble() && this.isEnabled()) {
            int exceptionRand = this.chaosMonkeySettings.getAssaultProperties().chooseAssault(3);
            if (this.allAssaultsActive()) {
                switch (exceptionRand) {
                    case 1: {
                        this.generateLatency();
                        break;
                    }
                    case 2: {
                        this.generateChaosException();
                        break;
                    }
                    case 3: {
                        this.killTheBossApp();
                    }
                }
            } else if (this.isLatencyAndExceptionActive()) {
                exceptionRand = this.chaosMonkeySettings.getAssaultProperties().chooseAssault(2);
                switch (exceptionRand) {
                    case 1: {
                        this.generateLatency();
                        break;
                    }
                    case 2: {
                        this.generateChaosException();
                    }
                }
            } else if (this.isLatencyAndKillAppActive()) {
                exceptionRand = this.chaosMonkeySettings.getAssaultProperties().chooseAssault(2);
                switch (exceptionRand) {
                    case 1: {
                        this.generateLatency();
                        break;
                    }
                    case 2: {
                        this.killTheBossApp();
                    }
                }
            } else if (this.isExceptionAndKillAppActive()) {
                exceptionRand = this.chaosMonkeySettings.getAssaultProperties().chooseAssault(2);
                switch (exceptionRand) {
                    case 1: {
                        this.generateChaosException();
                        break;
                    }
                    case 2: {
                        this.killTheBossApp();
                    }
                }
            } else if (this.chaosMonkeySettings.getAssaultProperties().isLatencyActive()) {
                this.generateLatency();
            } else if (this.chaosMonkeySettings.getAssaultProperties().isExceptionsActive()) {
                this.generateChaosException();
            } else if (this.chaosMonkeySettings.getAssaultProperties().isKillApplicationActive()) {
                this.killTheBossApp();
            }
        }
    }

    private boolean isLatencyAndKillAppActive() {
        return this.chaosMonkeySettings.getAssaultProperties().isLatencyActive() && !this.chaosMonkeySettings.getAssaultProperties().isExceptionsActive() && this.chaosMonkeySettings.getAssaultProperties().isKillApplicationActive();
    }

    private boolean isExceptionAndKillAppActive() {
        return this.chaosMonkeySettings.getAssaultProperties().isLatencyActive() && !this.chaosMonkeySettings.getAssaultProperties().isExceptionsActive() && this.chaosMonkeySettings.getAssaultProperties().isKillApplicationActive();
    }

    private boolean isLatencyAndExceptionActive() {
        return this.chaosMonkeySettings.getAssaultProperties().isLatencyActive() && this.chaosMonkeySettings.getAssaultProperties().isExceptionsActive() && !this.chaosMonkeySettings.getAssaultProperties().isKillApplicationActive();
    }

    private boolean allAssaultsActive() {
        return this.chaosMonkeySettings.getAssaultProperties().isLatencyActive() && this.chaosMonkeySettings.getAssaultProperties().isExceptionsActive() && this.chaosMonkeySettings.getAssaultProperties().isKillApplicationActive();
    }

    private boolean isTrouble() {
        return this.chaosMonkeySettings.getAssaultProperties().getTroubleRandom() >= this.chaosMonkeySettings.getAssaultProperties().getLevel();
    }

    private boolean isEnabled() {
        return this.chaosMonkeySettings.getChaosMonkeyProperties().isEnabled();
    }

    private void killTheBossApp() {
        try {
            LOGGER.info("Chaos Monkey - I am killing your Application!");
            int exit = SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{new ExitCodeGenerator(){

                public int getExitCode() {
                    return 0;
                }
            }});
            System.exit(exit);
        }
        catch (Exception e) {
            LOGGER.info("Chaos Monkey - Unable to kill the App, I am not the BOSS!");
        }
    }

    private void generateChaosException() {
        LOGGER.info("Chaos Monkey - exception");
        throw new RuntimeException("Chaos Monkey - RuntimeException");
    }

    private void generateLatency() {
        LOGGER.info("Chaos Monkey - timeout");
        int timeout = RandomUtils.nextInt((int)this.chaosMonkeySettings.getAssaultProperties().getLatencyRangeStart(), (int)this.chaosMonkeySettings.getAssaultProperties().getLatencyRangeEnd());
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

