/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.oauth.interceptor;

import de.cidaas.oauth.util.ConfigurationLoader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class Constants {
    private static final Logger LOG = LoggerFactory.getLogger(Constants.class);
    private static final String PROPS = "cidaas_config.properties";
    static final String HEADER_SCOPES = "scopes";
    static final String ESCAPE_KEY = ConfigurationLoader.getPropertyByKey("swagger_bypass_key", "cidaas_config.properties");
    static final String SWAGGER_UI_CLASS_NAME = "io.swagger.jaxrs.listing.ApiListingResource";
    static final String SWAGGER_UI_METHOD_NAME = "getListing";
    private static String tokenKey = null;
    private static String cidaas_interceptor_base_url = null;

    private Constants() {
    }

    public static String get_tokenKey() {
        String prop_variable = "tokenKey";
        tokenKey = ConfigurationLoader.getPropertyByKey(prop_variable, PROPS);
        if (StringUtils.isEmpty((Object)tokenKey)) {
            tokenKey = "access_token";
        }
        return tokenKey;
    }

    private static String get_cidaas_interceptor_base_url() {
        String prop_variable = "cidaas_interceptor_base_url";
        cidaas_interceptor_base_url = ConfigurationLoader.getPropertyByKey(prop_variable, PROPS);
        if (cidaas_interceptor_base_url == null) {
            cidaas_interceptor_base_url = "";
        }
        if (StringUtils.isEmpty((Object)cidaas_interceptor_base_url)) {
            String loginBaseURL;
            cidaas_interceptor_base_url = loginBaseURL = ConfigurationLoader.getPropertyByKey("oauth2-login.baseurl", PROPS);
        }
        return cidaas_interceptor_base_url;
    }

    public static int get_max_token_usage_update_count() {
        String prop_variable = "max_token_usage_update_count";
        int count = 50;
        String val = ConfigurationLoader.getPropertyByKey(prop_variable, PROPS);
        if (StringUtils.isEmpty((Object)val)) {
            return count;
        }
        try {
            count = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public static int get_token_usage_update_interval() {
        String prop_variable = "token_usage_update_interval";
        int count = 5;
        String val = ConfigurationLoader.getPropertyByKey(prop_variable, PROPS);
        if (StringUtils.isEmpty((Object)val)) {
            return count;
        }
        try {
            count = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public static String get_user_info_by_token() {
        String prop_variable = "user_info_by_token";
        String val = ConfigurationLoader.getPropertyByKey(prop_variable, PROPS);
        if (StringUtils.isEmpty((Object)val)) {
            val = "/tokens/userinfobytoken";
        }
        if (val.startsWith("http://") || val.startsWith("https://")) {
            return val;
        }
        val = Constants.combilePath(Constants.get_cidaas_interceptor_base_url(), val);
        return val;
    }

    public static String get_update_token_check_urll() {
        String prop_variable = "update_token_check_url";
        String val = ConfigurationLoader.getPropertyByKey(prop_variable, PROPS);
        if (StringUtils.isEmpty((Object)val)) {
            val = "/oauth2/updatetokencheck";
        }
        if (val.startsWith("http://") || val.startsWith("https://")) {
            return val;
        }
        val = Constants.combilePath(Constants.get_cidaas_interceptor_base_url(), val);
        return val;
    }

    public static String get_private_key_path() {
        String prop_variable = "JWE_Private_Key_Path";
        return ConfigurationLoader.getPropertyByKey(prop_variable, PROPS);
    }

    private static String combilePath(String ... paths) {
        String urlToReturn = paths[0];
        for (int i = 1; i < paths.length; ++i) {
            if (urlToReturn.endsWith("/") && paths[i].startsWith("/")) {
                urlToReturn = urlToReturn.substring(0, urlToReturn.length() - 1);
                urlToReturn = urlToReturn + paths[i];
                continue;
            }
            if (urlToReturn.endsWith("/") && !paths[i].startsWith("/")) {
                urlToReturn = urlToReturn + paths[i];
                continue;
            }
            if (!urlToReturn.endsWith("/") && paths[i].startsWith("/")) {
                urlToReturn = urlToReturn + paths[i];
                continue;
            }
            if (urlToReturn.endsWith("/") || paths[i].startsWith("/")) continue;
            urlToReturn = urlToReturn + "/" + paths[i];
        }
        if (urlToReturn.endsWith("/")) {
            urlToReturn = urlToReturn.substring(0, urlToReturn.length() - 1);
        }
        return urlToReturn;
    }

    public static String loadStringValueFromProperty(String prop_cache_variable, String prop_variable) {
        if (StringUtils.isEmpty((Object)prop_cache_variable) && StringUtils.isEmpty((Object)(prop_cache_variable = ConfigurationLoader.getPropertyByKey(prop_variable, PROPS)))) {
            Properties p = ConfigurationLoader.getPropertiesOfFile(PROPS);
            if (p == null) {
                LOG.info("cidaas_config.properties Not found.");
            } else {
                LOG.info(prop_variable + "not accessible. property file not found: " + PROPS);
            }
        }
        return prop_cache_variable;
    }
}

