package de.cidaas.oauth.interceptor;

import org.apache.oltu.oauth2.common.message.types.ParameterStyle;
import org.apache.oltu.oauth2.rs.ResourceServer;
import org.apache.oltu.oauth2.rs.validator.BearerBodyOAuthValidator;
import org.apache.oltu.oauth2.rs.validator.BearerQueryOAuthValidator;

public class BearerResourceServer extends ResourceServer{
	public BearerResourceServer() {
		extractors.put(ParameterStyle.HEADER, BearerHeaderTokenExtractor.class);
		extractors.put(ParameterStyle.BODY, CBBearerBodyTokenExtractor.class);
		extractors.put(ParameterStyle.QUERY, CBBearerQueryTokenExtractor.class);

		validators.put(ParameterStyle.HEADER, BearerHeaderOAuthValidator.class);
		validators.put(ParameterStyle.BODY, BearerBodyOAuthValidator.class);
		validators.put(ParameterStyle.QUERY, BearerQueryOAuthValidator.class);
	}
}
