/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.oauth.windowupdate;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.cidaas.oauth.interceptor.Constants;
import de.cidaas.oauth.model.TokenCheckEntity;
import de.cidaas.oauth.windowupdate.TokenWindowUpdate;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;

class UpdateTask
implements Runnable {
    UpdateTask() {
    }

    @Override
    public void run() {
        ArrayList<TokenCheckEntity> tokenList = new ArrayList<TokenCheckEntity>();
        TokenWindowUpdate instance = TokenWindowUpdate.getInstance();
        try {
            if (instance.tokenList != null && instance.tokenList.size() > 0) {
                while (tokenList.size() < Constants.get_max_token_usage_update_count() && instance.tokenList.size() > 0) {
                    if (instance.tokenList.size() <= 0) continue;
                    tokenList.add(instance.tokenList.remove(0));
                }
            }
            if (tokenList != null && tokenList.size() > 0) {
                System.out.println("Sending " + tokenList.size() + "/" + instance.tokenList.size() + " request to cidaas");
                String jsonData = new ObjectMapper().writeValueAsString(tokenList);
                postWebhookThread pw = new postWebhookThread(Constants.get_update_token_check_urll(), jsonData);
                pw.start();
            }
        }
        catch (Exception e) {
            if (tokenList != null && tokenList.size() > 0) {
                instance.tokenList.addAll(tokenList);
            }
            System.out.println("Error while submiting access token usage data to Cidaas, Dont worry we will retry same in a bit.");
            e.printStackTrace();
        }
    }

    public class postWebhookThread
    extends Thread {
        private String urlToSubmit;
        private String jsonData;

        public postWebhookThread(String urlToSubmit, String jsonData) {
            this.urlToSubmit = urlToSubmit;
            this.jsonData = jsonData;
        }

        @Override
        public void run() {
            try {
                HttpPost resetPost = new HttpPost(new URI(this.urlToSubmit));
                if (this.jsonData != null) {
                    StringEntity se = new StringEntity(this.jsonData, ContentType.APPLICATION_JSON);
                    resetPost.setEntity((HttpEntity)se);
                    resetPost.addHeader("Content-Type", "application/json; charset=UTF-8");
                }
                CloseableHttpResponse result = HttpClientBuilder.create().build().execute((HttpUriRequest)resetPost);
                BufferedReader rd = new BufferedReader(new InputStreamReader(result.getEntity().getContent()));
                StringBuffer resultData = new StringBuffer();
                String line = "";
                while ((line = rd.readLine()) != null) {
                    resultData.append(line);
                }
                System.out.println(result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

