/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.oauth.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationLoader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationLoader.class);
    private static final String path = System.getProperty("warc.homepath");

    public static Properties getPropertiesOfFile(String pFilename) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new RuntimeException("warc.homepath not set while reading Propertyfile:" + pFilename);
        }
        if (StringUtils.isEmpty((CharSequence)pFilename)) {
            throw new RuntimeException("No properties filename to read from specified, warc.homepath=" + path);
        }
        try {
            Properties props = new Properties();
            InputStream in = ConfigurationLoader.getFullqualifiedFilename(pFilename);
            props.load(in);
            for (Object key : props.keySet()) {
                String propValue = System.getenv(key.toString());
                if (propValue == null) continue;
                props.setProperty(key.toString(), propValue);
            }
            in.close();
            return props;
        }
        catch (FileNotFoundException e) {
            logger.error(pFilename + " not found.", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            logger.error("IOException while loading " + pFilename, (Throwable)e);
            return null;
        }
    }

    public static Object loadJAXB(Class<?> configClass, String fileName) throws JAXBException, FileNotFoundException {
        JAXBContext lCtx = JAXBContext.newInstance((Class[])new Class[]{configClass});
        Unmarshaller lUnMarshaller = lCtx.createUnmarshaller();
        InputStream in = ConfigurationLoader.getFullqualifiedFilename(fileName);
        Object lConfiguration = lUnMarshaller.unmarshal(in);
        return lConfiguration;
    }

    private static InputStream getFullqualifiedFilename(String pFilename) throws FileNotFoundException {
        StringBuilder lSB = new StringBuilder(path);
        if (path != null && !path.endsWith("/")) {
            lSB.append("/");
        }
        lSB.append("conf/");
        lSB.append(pFilename);
        String lFilePath = lSB.toString();
        logger.debug("load properties from file:" + lFilePath);
        InputStream inputStream = ConfigurationLoader.class.getClassLoader().getResourceAsStream(lFilePath);
        if (inputStream == null) {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(lFilePath);
        }
        if (inputStream == null) {
            inputStream = new FileInputStream(lFilePath);
        }
        return inputStream;
    }

    public static String getPropertyByKey(String key, String defaultValue, String pFilename) {
        Properties properties = ConfigurationLoader.getPropertiesOfFile(pFilename);
        if (properties != null) {
            return properties.getProperty(key);
        }
        return defaultValue;
    }

    public static String getPropertyByKey(String key, String pFilename) {
        return ConfigurationLoader.getPropertyByKey(key, null, pFilename);
    }
}

