/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.oauth.interceptor;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cidaas.jwt.JWS;
import de.cidaas.jwt.TokenTypes;
import de.cidaas.oauth.cache.LRUCache;
import de.cidaas.oauth.interceptor.TokenHelper;
import de.cidaas.oauth.model.TokenIntrospectionRequest;
import de.cidaas.oauth.model.TokenIntrospectionResponse;
import de.cidaas.oauth.util.CidaasConfigResolver;
import de.cidaas.oauth.util.OpenIdConfiguration;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateToken {
    private static final Logger LOG = LoggerFactory.getLogger(TokenHelper.class);
    LRUCache tokenCache = LRUCache.getInstance();
    private JWS jws;
    private ObjectMapper om = this.om.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
    private static ValidateToken _validateToken;

    public static synchronized ValidateToken getInstance() {
        if (_validateToken == null) {
            _validateToken = new ValidateToken();
        }
        return _validateToken;
    }

    public ValidateToken() {
        this.jws = new JWS();
    }

    public TokenIntrospectionResponse validateAccessToken(TokenIntrospectionRequest tokenInfo) {
        TokenIntrospectionResponse tokenIntrospectionResponse = new TokenIntrospectionResponse();
        if (StringUtils.isEmpty((CharSequence)tokenInfo.getToken())) {
            tokenIntrospectionResponse.setActive(false);
            return tokenIntrospectionResponse;
        }
        if (this.jws.getTokenType(tokenInfo.getToken()) == TokenTypes.JWS) {
            return this.validateTokenInRemote(tokenInfo);
        }
        if (this.jws.getTokenType(tokenInfo.getToken()) == TokenTypes.JWE) {
            return this.validateTokenInRemote(tokenInfo);
        }
        return this.validateTokenInRemote(tokenInfo);
    }

    private TokenIntrospectionResponse validateTokenInRemote(TokenIntrospectionRequest tokenInfo) {
        TokenIntrospectionResponse tokenIntrospectionResponse = new TokenIntrospectionResponse();
        try {
            CloseableHttpResponse response;
            int responseStatusCode;
            OpenIdConfiguration openIdConfiguration = CidaasConfigResolver.getInstance().openIdConfiguration;
            HttpPost resetPost = new HttpPost(new URI(openIdConfiguration.getIntrospection_endpoint()));
            resetPost.addHeader("Authorization ", "Bearer " + tokenInfo.getToken());
            if (tokenInfo != null) {
                StringEntity se = new StringEntity(this.om.writeValueAsString((Object)tokenInfo), ContentType.APPLICATION_JSON);
                resetPost.setEntity((HttpEntity)se);
                resetPost.addHeader("Content-Type", "application/json; charset=UTF-8");
            }
            if ((responseStatusCode = (response = HttpClientBuilder.create().build().execute((HttpUriRequest)resetPost)).getStatusLine().getStatusCode()) == 200) {
                return (TokenIntrospectionResponse)this.om.readValue(response.getEntity().getContent(), TokenIntrospectionResponse.class);
            }
            LOG.error("Non Success status code from Introspection Endpoint.");
        }
        catch (Exception ex) {
            LOG.error("Exception at getUserInfoByToken {}", (Throwable)ex);
        }
        return tokenIntrospectionResponse;
    }
}

