/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.oauth.cache;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache
extends LinkedHashMap<Integer, Long> {
    private static final long serialVersionUID = 1L;
    private int capacity;
    private long expire_in;
    private static LRUCache _lruCache = null;

    public static LRUCache getInstance() {
        if (_lruCache == null) {
            System.out.println("Initialize the cache");
            _lruCache = new LRUCache(10000, 0.75f, 3600000L);
        }
        return _lruCache;
    }

    public LRUCache(int capacity, float loadFactor, long expire_in) {
        super(capacity, loadFactor, true);
        this.capacity = capacity;
        this.expire_in = expire_in;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<Integer, Long> eldest) {
        return this.size() > this.capacity;
    }

    public boolean isPresent(String key) {
        Long lastServerMilliSeconds = (Long)this.get(key.hashCode());
        if (lastServerMilliSeconds != null) {
            Long currentTime = new Date().getTime();
            Long elapsed = currentTime - lastServerMilliSeconds;
            return elapsed < this.expire_in;
        }
        return false;
    }
}

