package de.cidaas.oauth.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TokenIntrospectionRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    String token;
    String token_type_hint;
    String[] roles;
    String[] scopes;
    GroupValidationEntity[] groups;
    boolean strictGroupValidation = false;
    boolean strictScopeValidation = false;
    boolean strictRoleValidation = false;
    boolean strictValidation = false;

    String client_id;
    String client_secret;

    String request_url;
    Long request_time;
    Map<String, String> request_headers;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken_type_hint() {
        return token_type_hint;
    }

    public void setToken_type_hint(String token_type_hint) {
        this.token_type_hint = token_type_hint;
    }

    public String[] getRoles() {
        return roles;
    }

    public void setRoles(String[] roles) {
        this.roles = roles;
    }

    public String[] getScopes() {
        return scopes;
    }

    public void setScopes(String[] scopes) {
        this.scopes = scopes;
    }

    public GroupValidationEntity[] getGroups() {
        return groups;
    }

    public void setGroups(GroupValidationEntity[] groups) {
        this.groups = groups;
    }

    public boolean isStrictGroupValidation() {
        return strictGroupValidation;
    }

    public void setStrictGroupValidation(boolean strictGroupValidation) {
        this.strictGroupValidation = strictGroupValidation;
    }

    public boolean isStrictScopeValidation() {
        return strictScopeValidation;
    }

    public void setStrictScopeValidation(boolean strictScopeValidation) {
        this.strictScopeValidation = strictScopeValidation;
    }

    public boolean isStrictRoleValidation() {
        return strictRoleValidation;
    }

    public void setStrictRoleValidation(boolean strictRoleValidation) {
        this.strictRoleValidation = strictRoleValidation;
    }

    public boolean isStrictValidation() {
        return strictValidation;
    }

    public void setStrictValidation(boolean strictValidation) {
        this.strictValidation = strictValidation;
    }

    public String getClient_id() {
        return client_id;
    }

    public void setClient_id(String client_id) {
        this.client_id = client_id;
    }

    public String getClient_secret() {
        return client_secret;
    }

    public void setClient_secret(String client_secret) {
        this.client_secret = client_secret;
    }

    public String getRequest_url() {
        return request_url;
    }

    public void setRequest_url(String request_url) {
        this.request_url = request_url;
    }

    public Long getRequest_time() {
        return request_time;
    }

    public void setRequest_time(Long request_time) {
        this.request_time = request_time;
    }

    public Map<String, String> getRequest_headers() {
        return request_headers;
    }

    public void setRequest_headers(Map<String, String> request_headers) {
        this.request_headers = request_headers;
    }

    public TokenIntrospectionRequest() {
        this.request_time = new Date().getTime();
        this.request_headers = new HashMap<>();
    }

}
