/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.util.validation;

import de.carne.jfx.util.validation.MessageFormatter;
import de.carne.jfx.util.validation.ValidationException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public final class InputValidator {
    private InputValidator() {
    }

    public static void isTrue(boolean condition, MessageFormatter message) throws ValidationException {
        if (!condition) {
            throw new ValidationException(message.format(new Object[0]));
        }
    }

    public static <T> T notNull(@Nullable T input, MessageFormatter message) throws ValidationException {
        if (input == null) {
            throw new ValidationException(message.format(new Object[0]));
        }
        return input;
    }

    public static String notEmpty(@Nullable String input, MessageFormatter message) throws ValidationException {
        if (input == null || input.length() == 0) {
            throw new ValidationException(message.format(new Object[0]));
        }
        return input;
    }

    public static String[] matches(String input, Pattern pattern, MessageFormatter message) throws ValidationException {
        Matcher matcher = pattern.matcher(input);
        if (!matcher.matches()) {
            throw new ValidationException(message.format(input));
        }
        int groupCount = matcher.groupCount();
        String[] groups = new String[groupCount];
        for (int groupIndex = 0; groupIndex < groupCount; ++groupIndex) {
            groups[groupIndex] = matcher.group(groupIndex + 1);
        }
        return groups;
    }
}

