/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.scene.control;

import de.carne.boot.Exceptions;
import de.carne.jfx.stage.logview.LogViewFormats;
import de.carne.jfx.stage.logview.LogViewImages;
import java.util.Collection;
import java.util.logging.LogRecord;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.DialogPane;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import org.eclipse.jdt.annotation.Nullable;

public final class DialogPaneHelper {
    private static final double IMAGE_SIZE16 = 16.0;

    private DialogPaneHelper() {
    }

    public static void setExceptionContent(DialogPane dialogPane, @Nullable Throwable exception) {
        if (exception != null) {
            TextArea traceView = new TextArea(Exceptions.getStackTrace((Throwable)exception));
            traceView.setEditable(false);
            traceView.setBackground(dialogPane.getBackground());
            AnchorPane traceViewPane = new AnchorPane(new Node[]{traceView});
            AnchorPane.setLeftAnchor((Node)traceView, (Double)0.0);
            AnchorPane.setTopAnchor((Node)traceView, (Double)0.0);
            AnchorPane.setRightAnchor((Node)traceView, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)traceView, (Double)0.0);
            dialogPane.setExpandableContent((Node)traceViewPane);
        }
    }

    public static void setLogRecordsContent(DialogPane dialogPane, @Nullable Collection<LogRecord> logRecords) {
        if (logRecords != null && !logRecords.isEmpty()) {
            ListView logView = new ListView(FXCollections.observableArrayList(logRecords));
            logView.setCellFactory(param -> new ListCell<LogRecord>(){

                protected void updateItem(@Nullable LogRecord item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (item != null) {
                        this.setText(LogViewFormats.MESSAGE_FORMAT.format(item));
                        Image itemImage = LogViewImages.LEVEL_IMAGES.getImage(item.getLevel(), 16.0);
                        if (itemImage != null) {
                            this.setGraphic((Node)new ImageView(itemImage));
                        }
                    }
                }
            });
            logView.setBackground(dialogPane.getBackground());
            AnchorPane logViewPane = new AnchorPane(new Node[]{logView});
            AnchorPane.setLeftAnchor((Node)logView, (Double)0.0);
            AnchorPane.setTopAnchor((Node)logView, (Double)0.0);
            AnchorPane.setRightAnchor((Node)logView, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)logView, (Double)0.0);
            dialogPane.setExpandableContent((Node)logViewPane);
        }
    }
}

