/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.scene.control;

import de.carne.jfx.fxml.FXMLController;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.stage.Modality;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.eclipse.jdt.annotation.Nullable;

public abstract class DialogController<R>
extends FXMLController<Dialog<R>> {
    public static <R, C extends DialogController<R>> C loadDialog(Window owner, Function<C, Dialog<R>> dialogFactory, Class<C> controllerClass) throws IOException {
        return (C)((DialogController)DialogController.loadUI(owner, dialogFactory, controllerClass));
    }

    @Override
    public final Window getWindow() {
        return ((Dialog)this.getUI()).getDialogPane().getScene().getWindow();
    }

    @Override
    protected void setupUI(@Nullable Window owner, Dialog<R> dialog, Parent fxmlRoot) {
        if (!(fxmlRoot instanceof DialogPane)) {
            throw new IllegalArgumentException("FXML root must be of type DialogPane; but is: " + fxmlRoot.getClass().getName());
        }
        dialog.setDialogPane((DialogPane)fxmlRoot);
        dialog.initStyle(this.getStyle());
        if (owner != null) {
            dialog.initOwner(owner);
            dialog.initModality(this.getModality());
        }
        this.setupDialog(dialog);
    }

    protected StageStyle getStyle() {
        return StageStyle.DECORATED;
    }

    protected Modality getModality() {
        return Modality.APPLICATION_MODAL;
    }

    protected void setupDialog(Dialog<R> dialog) {
    }

    protected final Node lookupButton(ButtonType buttonType) {
        return ((Dialog)this.getUI()).getDialogPane().lookupButton(buttonType);
    }

    protected final void addButtonEventFilter(ButtonType buttonType, EventHandler<? super ActionEvent> filter) {
        ((Dialog)this.getUI()).getDialogPane().lookupButton(buttonType).addEventFilter(ActionEvent.ACTION, filter);
    }

    public void show() {
        ((Dialog)this.getUI()).show();
    }

    public Optional<R> showAndWait() {
        return ((Dialog)this.getUI()).showAndWait();
    }
}

