/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.stage.logview;

import de.carne.jfx.stage.logview.LogRecordDate;
import de.carne.jfx.stage.logview.LogViewFormats;
import de.carne.jfx.stage.logview.LogViewImages;
import java.util.logging.LogRecord;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.image.Image;

public class LogRecordModel {
    private final ObjectProperty<Image> levelProperty;
    private final ObjectProperty<LogRecordDate> timeProperty;
    private final StringProperty threadProperty;
    private final StringProperty messageProperty;

    public LogRecordModel(LogRecord record) {
        this.levelProperty = new SimpleObjectProperty((Object)LogViewImages.LEVEL_IMAGES.getImage(record.getLevel(), 16.0));
        this.timeProperty = new SimpleObjectProperty((Object)new LogRecordDate(record.getMillis()));
        this.threadProperty = new SimpleStringProperty(Integer.toString(record.getThreadID()));
        this.messageProperty = new SimpleStringProperty(LogViewFormats.MESSAGE_FORMAT.format(record));
    }

    public Image getLevel() {
        return (Image)this.levelProperty.get();
    }

    public void setLevel(Image level) {
        this.levelProperty.set((Object)level);
    }

    public ObjectProperty<Image> levelProperty() {
        return this.levelProperty;
    }

    public LogRecordDate getTime() {
        return (LogRecordDate)this.timeProperty.get();
    }

    public void setTime(LogRecordDate time) {
        this.timeProperty.set((Object)time);
    }

    public ObjectProperty<LogRecordDate> timeProperty() {
        return this.timeProperty;
    }

    public String getThread() {
        return (String)this.threadProperty.get();
    }

    public void setThread(String thread) {
        this.threadProperty.set((Object)thread);
    }

    public StringProperty threadProperty() {
        return this.threadProperty;
    }

    public String getMessage() {
        return (String)this.messageProperty.get();
    }

    public void setMessage(String message) {
        this.messageProperty.set((Object)message);
    }

    public StringProperty messageProperty() {
        return this.messageProperty;
    }
}

