/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.check.Nullable;
import de.carne.nio.FileAttributes;
import de.carne.util.logging.Log;
import de.carne.util.prefs.PropertiesPreferences;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

final class PropertiesCache {
    private final Log LOG = new Log();
    private final Path propertiesPath;
    private final Properties cache = new Properties();
    @Nullable
    private FileTime propertiesPathLastModifiedTime = null;

    PropertiesCache(Path propertiesPath) {
        this.propertiesPath = propertiesPath;
    }

    public synchronized Map<String, String> getValues(PropertiesPreferences preferences) {
        this.initCache();
        HashMap<String, String> values = new HashMap<String, String>();
        String absolutePreferencesPath = this.getAbsolutePreferencesPath(preferences);
        for (Map.Entry<Object, Object> cacheEntry : this.cache.entrySet()) {
            Object value;
            String cacheKey = cacheEntry.getKey().toString();
            String key = this.determinePreferencesKey(absolutePreferencesPath, cacheKey);
            if (key == null || (value = cacheEntry.getValue()) == null) continue;
            values.put(key, value.toString());
        }
        return values;
    }

    public synchronized Map<String, PropertiesPreferences> getChildren(PropertiesPreferences parent) {
        this.initCache();
        HashMap<String, PropertiesPreferences> children = new HashMap<String, PropertiesPreferences>();
        String absolutePreferencesPath = this.getAbsolutePreferencesPath(parent);
        for (Map.Entry<Object, Object> cacheEntry : this.cache.entrySet()) {
            String cacheKey = cacheEntry.getKey().toString();
            String childName = this.determinePreferencesChildName(absolutePreferencesPath, cacheKey);
            if (childName == null || children.containsKey(childName)) continue;
            children.put(childName, new PropertiesPreferences(parent, childName));
        }
        return children;
    }

    public synchronized void sync(PropertiesPreferences preferences, @Nullable Map<String, String> modifiedValues, @Nullable Set<String> modifiedChildrenNames) {
        try {
            this.initCache();
            String absolutePreferencesPath = this.getAbsolutePreferencesPath(preferences);
            Iterator<Object> cacheKeys = this.cache.keySet().iterator();
            while (cacheKeys.hasNext()) {
                String string;
                String string2;
                String cacheKey = cacheKeys.next().toString();
                if (modifiedValues != null && (string2 = this.determinePreferencesKey(absolutePreferencesPath, cacheKey)) != null) {
                    cacheKeys.remove();
                }
                if (modifiedChildrenNames == null || (string = this.determinePreferencesChildName(absolutePreferencesPath, cacheKey)) == null || modifiedChildrenNames.contains(string)) continue;
                cacheKeys.remove();
            }
            if (modifiedValues != null) {
                for (Map.Entry entry : modifiedValues.entrySet()) {
                    String absoluteKey = absolutePreferencesPath + (String)entry.getKey();
                    this.cache.put(absoluteKey, entry.getValue());
                }
            }
            this.LOG.info("Writing preferences file ''{0}''...", this.propertiesPath);
            Throwable throwable = null;
            try (OutputStream propertiesStream = Files.newOutputStream(this.propertiesPath, new OpenOption[0]);){
                this.cache.store(propertiesStream, null);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            this.propertiesPathLastModifiedTime = Files.getLastModifiedTime(this.propertiesPath, new LinkOption[0]);
        }
        catch (IOException e) {
            this.LOG.warning(e, "An error occurred while syncing preferences file ''{0}''", this.propertiesPath);
        }
    }

    private void initCache() {
        block15: {
            try {
                FileTime lastModifiedTime;
                if (!Files.exists(this.propertiesPath, new LinkOption[0])) {
                    this.LOG.info("Creating preferences file ''{0}''...", this.propertiesPath);
                    Path propertiesDirectoryPath = this.propertiesPath.getParent();
                    Files.createDirectories(propertiesDirectoryPath, FileAttributes.defaultUserDirectoryAttributes(propertiesDirectoryPath));
                    Files.createFile(this.propertiesPath, FileAttributes.defaultUserFileAttributes(this.propertiesPath));
                    this.propertiesPathLastModifiedTime = null;
                }
                if (Objects.equals(lastModifiedTime = Files.getLastModifiedTime(this.propertiesPath, new LinkOption[0]), this.propertiesPathLastModifiedTime)) break block15;
                this.LOG.debug("Re-loading preferences from file ''{0}''...", this.propertiesPath);
                try (InputStream propertiesStream = Files.newInputStream(this.propertiesPath, new OpenOption[0]);){
                    this.cache.clear();
                    this.cache.load(propertiesStream);
                    this.propertiesPathLastModifiedTime = lastModifiedTime;
                }
            }
            catch (IOException e) {
                this.LOG.warning(e, "An error occurred while initializing/reading preferences file ''{0}''", this.propertiesPath);
            }
        }
    }

    private String getAbsolutePreferencesPath(PropertiesPreferences preferences) {
        String absolutePreferencesPath = preferences.absolutePath();
        if (preferences.parent() != null) {
            absolutePreferencesPath = absolutePreferencesPath + "/";
        }
        return absolutePreferencesPath;
    }

    @Nullable
    private String determinePreferencesKey(String absolutePreferencesPath, String cacheKey) {
        String key = null;
        if (cacheKey.startsWith(absolutePreferencesPath) && cacheKey.indexOf(47, absolutePreferencesPath.length()) < 0) {
            key = cacheKey.substring(absolutePreferencesPath.length());
        }
        return key;
    }

    @Nullable
    private String determinePreferencesChildName(String absolutePreferencesPath, String cacheKey) {
        int childKeyIndex;
        String key = null;
        if (cacheKey.startsWith(absolutePreferencesPath) && (childKeyIndex = cacheKey.indexOf(47, absolutePreferencesPath.length())) > 0) {
            key = cacheKey.substring(absolutePreferencesPath.length(), childKeyIndex);
        }
        return key;
    }
}

