/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.check.Nullable;
import java.util.prefs.Preferences;

public abstract class Preference<T> {
    private final Preferences preferences;
    private final String key;

    protected Preference(Preferences preferences, String key) {
        this.preferences = preferences;
        this.key = key;
    }

    public Preferences preferences() {
        return this.preferences;
    }

    public String key() {
        return this.key;
    }

    @Nullable
    public T get() {
        String valueString = this.preferences.get(this.key, null);
        return valueString != null ? (T)this.toValue(valueString) : null;
    }

    public T get(T defaultValue) {
        String valueString = this.preferences.get(this.key, null);
        T value = null;
        if (valueString != null) {
            value = this.toValue(valueString);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public void put(@Nullable T value) {
        if (value != null) {
            this.preferences.put(this.key, this.fromValue(value));
        } else {
            this.remove();
        }
    }

    public void remove() {
        this.preferences.remove(this.key);
    }

    @Nullable
    protected abstract T toValue(String var1);

    protected abstract String fromValue(T var1);

    public String toString() {
        return this.key + " = " + this.get();
    }
}

