/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.check.Nullable;
import de.carne.util.Exceptions;
import de.carne.util.prefs.Preference;
import java.util.prefs.Preferences;

public class IntPreference
extends Preference<Integer> {
    public IntPreference(Preferences preferences, String key) {
        super(preferences, key);
    }

    public int getInt(int defaultValue) {
        return this.preferences().getInt(this.key(), defaultValue);
    }

    public void putInt(int value) {
        this.preferences().putInt(this.key(), value);
    }

    @Override
    @Nullable
    protected Integer toValue(String valueString) {
        Integer value = null;
        try {
            value = Integer.valueOf(valueString);
        }
        catch (NumberFormatException e) {
            Exceptions.ignore(e);
        }
        return value;
    }

    @Override
    protected String fromValue(Integer value) {
        return value.toString();
    }
}

