/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.check.Nullable;
import de.carne.util.logging.Log;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class Exceptions {
    private static final Log LOG = new Log();

    private Exceptions() {
    }

    public static RuntimeException toRuntime(Throwable exception) {
        return new RuntimeException(exception.getMessage(), exception);
    }

    public static void ignore(@Nullable Throwable exception) {
        if (exception != null) {
            LOG.trace(exception, "Ignoring exception {0}", exception.getClass());
        }
    }

    public static void warn(@Nullable Throwable exception) {
        if (exception != null) {
            LOG.trace(exception, "Ignoring exception {0}", exception.getClass());
        }
    }

    public static String getStackTrace(Throwable exception) {
        String stackTrace = null;
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            exception.printStackTrace(pw);
            pw.flush();
            stackTrace = sw.toString();
        }
        catch (IOException e) {
            Exceptions.warn(e);
        }
        return stackTrace != null ? stackTrace : "<no stack trace>";
    }
}

