/*
 * Decompiled with CFR 0.152.
 */
package de.carne.text;

import de.carne.check.Check;
import de.carne.check.Nullable;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class MemUnitFormat
extends NumberFormat {
    private static final long serialVersionUID = -2340676521583361828L;
    private static final String[] MEM_UNITS = new String[]{" Byte", " KB", " MB", " GB", " TB", " PB", " EB", " ZB", " YB"};
    private NumberFormat numberFormat;

    public MemUnitFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    @Override
    public StringBuffer format(double number, @Nullable StringBuffer toAppendTo, @Nullable FieldPosition pos) {
        int memUnitIndex;
        double normalizedNumber = number;
        if (Double.isFinite(number)) {
            for (memUnitIndex = 0; Math.abs(normalizedNumber) >= 1024.0 && memUnitIndex < MEM_UNITS.length; ++memUnitIndex) {
                normalizedNumber /= 1024.0;
            }
        }
        return this.numberFormat.format(normalizedNumber, toAppendTo, pos).append(MEM_UNITS[memUnitIndex]);
    }

    @Override
    public StringBuffer format(long number, @Nullable StringBuffer toAppendTo, @Nullable FieldPosition pos) {
        return this.format((double)number * 1.0, toAppendTo, pos);
    }

    @Override
    @Nullable
    public Number parse(@Nullable String _source, @Nullable ParsePosition _parsePosition) {
        String source = Check.nonNull(_source);
        ParsePosition parsePosition = Check.nonNull(_parsePosition);
        int startIndex = parsePosition.getIndex();
        Number number = this.numberFormat.parse(source, parsePosition);
        if (parsePosition.getIndex() > startIndex && parsePosition.getErrorIndex() < 0) {
            double doubleNumber = number.doubleValue();
            int memUnitIndex = 0;
            if (Double.isFinite(doubleNumber)) {
                while (memUnitIndex < MEM_UNITS.length && !source.startsWith(MEM_UNITS[memUnitIndex], parsePosition.getIndex())) {
                    ++memUnitIndex;
                    doubleNumber *= 1024.0;
                }
            } else if (source.startsWith(MEM_UNITS[memUnitIndex], parsePosition.getIndex())) {
                memUnitIndex = MEM_UNITS.length;
            }
            if (memUnitIndex < MEM_UNITS.length) {
                String memUnit = MEM_UNITS[memUnitIndex];
                parsePosition.setIndex(parsePosition.getIndex() + memUnit.length());
                number = Math.floor(doubleNumber) == doubleNumber && -9.223372036854776E18 <= doubleNumber && doubleNumber <= 9.223372036854776E18 ? (Number)((long)doubleNumber) : (Number)doubleNumber;
            } else {
                parsePosition.setErrorIndex(parsePosition.getIndex());
                parsePosition.setIndex(startIndex);
            }
        }
        return number;
    }
}

