/*
 * Decompiled with CFR 0.152.
 */
package de.carne.io;

import de.carne.check.Check;
import de.carne.check.Nullable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class LimitOutputStream<T extends OutputStream>
extends OutputStream {
    private final T out;
    private final long limit;
    private long totalWritten = 0L;

    public LimitOutputStream(T out, long limit) {
        this.out = out;
        this.limit = limit;
    }

    public T outputStream() {
        return this.out;
    }

    @Override
    public void write(int b) throws IOException {
        ((OutputStream)this.out).write(b);
        this.recordWrite(1);
    }

    @Override
    public void write(@Nullable byte[] _b) throws IOException {
        byte[] b = Check.nonNull(_b);
        ((OutputStream)this.out).write(b);
        this.recordWrite(b.length);
    }

    @Override
    public void write(@Nullable byte[] _b, int off, int len) throws IOException {
        byte[] b = Check.nonNull(_b);
        ((OutputStream)this.out).write(b, off, len);
        this.recordWrite(len);
    }

    @Override
    public void flush() throws IOException {
        ((OutputStream)this.out).flush();
    }

    @Override
    public void close() throws IOException {
        ((OutputStream)this.out).close();
    }

    private synchronized void recordWrite(int written) throws IOException {
        this.totalWritten += (long)written;
        if (this.totalWritten >= this.limit) {
            InterruptedIOException exception = new InterruptedIOException("Output limit (" + this.limit + ") reached (" + this.totalWritten + ")");
            exception.bytesTransferred = this.totalWritten <= Integer.MAX_VALUE ? (int)this.totalWritten : -1;
            throw exception;
        }
    }
}

