/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradleplugins.java;

import de.carne.gradleplugins.generate.JavaI18NGenerator;
import de.carne.gradleplugins.java.JavaToolsExtension;
import de.carne.gradleplugins.java.JavaToolsPlugin;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

public class GenI18NTask
extends DefaultTask {
    public static final String GEN_I18N_TASK_NAME = "genI18N";
    public static final String GEN_I18N_TASK_DESCRIPTION = "Generate I18N resource string classes";

    public void prepareAfterEvaluate() {
        TaskContext ctx = new TaskContext();
        Map<File, File> genMap = this.determineGenMap(ctx);
        TaskInputs inputs = this.getInputs();
        TaskOutputsInternal outputs = this.getOutputs();
        inputs.property(JavaToolsExtension.getGenDirProperty(), (Object)ctx.extension().getGenDir());
        inputs.property(JavaToolsExtension.getGenI18NSourceSetProperty(), (Object)ctx.extension().getGenI18NSourceSet());
        inputs.property(JavaToolsExtension.getGenI18NIncludeProperty(), (Object)ctx.extension().getGenI18NInclude());
        inputs.property(JavaToolsExtension.getGenI18NKeyFilterProperty(), (Object)ctx.extension().getGenI18NKeyFilter());
        outputs.dir((Object)ctx.genDir());
        for (Map.Entry<File, File> genMapEntry : genMap.entrySet()) {
            File dstFile = genMapEntry.getKey();
            File srcFile = genMapEntry.getValue();
            inputs.file((Object)srcFile);
            outputs.file((Object)dstFile);
        }
    }

    @TaskAction
    public void runGenI18NTask() throws TaskExecutionException {
        TaskContext ctx = new TaskContext();
        Map<File, File> genMap = this.determineGenMap(ctx);
        JavaI18NGenerator generator = new JavaI18NGenerator(null, null);
        for (Map.Entry<File, File> genMapEntry : genMap.entrySet()) {
            HashMap<String, String> generatorCtx = new HashMap<String, String>();
            File dstFile = genMapEntry.getKey();
            File srcFile = genMapEntry.getValue();
            if (!dstFile.exists() || dstFile.lastModified() <= srcFile.lastModified()) {
                this.getProject().getLogger().debug("Processing source file {}", (Object)srcFile);
                generatorCtx.put("I18N_PACKAGE", this.getPackageFromFile(dstFile, ctx.genDir()));
                generatorCtx.put("I18N_CLASS", this.getClassFromFile(dstFile));
                generatorCtx.put("I18N_KEY_FILTER", ctx.extension().getGenI18NKeyFilter());
                try {
                    Files.createDirectories(Paths.get(dstFile.getParent(), new String[0]), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new TaskExecutionException((Task)this, (Throwable)e);
                }
                try {
                    FileReader in = new FileReader(srcFile);
                    Throwable throwable = null;
                    try {
                        FileWriter out = new FileWriter(dstFile);
                        Throwable throwable2 = null;
                        try {
                            generator.generate(generatorCtx, in, out);
                            continue;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (out == null) continue;
                            if (throwable2 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            out.close();
                            continue;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        in.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new TaskExecutionException((Task)this, (Throwable)e);
                }
            }
            this.getProject().getLogger().debug("Skipping unchanged source file {}", (Object)srcFile);
        }
    }

    private Map<File, File> determineGenMap(TaskContext ctx) {
        HashMap<File, File> genMap = new HashMap<File, File>();
        Path genDirPath = ctx.genDir().toPath();
        for (DirectoryTree srcDirTree : ctx.sourceSet().getResources().getSrcDirTrees()) {
            File srcDir = this.getProject().file((Object)srcDirTree.getDir());
            Path srcDirPath = srcDir.toPath();
            Set srcFiles = this.getProject().fileTree((Object)srcDir).matching((PatternFilterable)srcDirTree.getPatterns()).matching((PatternFilterable)ctx.pattern()).getFiles();
            for (File srcFile : srcFiles) {
                Path relSrcFilePath = srcDirPath.relativize(srcFile.toPath());
                File dstFile = genDirPath.resolve(relSrcFilePath.toString().replaceFirst("\\.properties$", ".java")).toFile();
                if (!genMap.containsKey(dstFile)) {
                    genMap.put(dstFile, srcFile);
                    continue;
                }
                this.getProject().getLogger().warn("Ignoring additional source file {} for {}:{}", new Object[]{srcFile, dstFile, genMap.get(dstFile)});
            }
        }
        return genMap;
    }

    private String getPackageFromFile(File file, File genDir) {
        Path relPackagePath = genDir.toPath().relativize(file.toPath().getParent());
        return relPackagePath.toString().replaceAll("/|\\\\", ".");
    }

    private String getClassFromFile(File file) {
        return file.getName().replaceFirst("\\..*$", "");
    }

    private class TaskContext {
        private JavaToolsExtension extension;
        private File genDir;
        private SourceSet sourceSet;
        private PatternSet pattern;

        TaskContext() {
            Project project = GenI18NTask.this.getProject();
            this.extension = JavaToolsExtension.get(project);
            this.genDir = project.file((Object)this.extension.getGenDir());
            this.sourceSet = JavaToolsPlugin.getSourceSet(project, this.extension.getGenI18NSourceSet());
            this.pattern = new PatternSet();
            this.pattern.include(new String[]{this.extension.getGenI18NInclude()});
        }

        public JavaToolsExtension extension() {
            return this.extension;
        }

        public File genDir() {
            return this.genDir;
        }

        public SourceSet sourceSet() {
            return this.sourceSet;
        }

        public PatternSet pattern() {
            return this.pattern;
        }
    }
}

