/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradleplugins.generate;

import de.carne.gradleplugins.generate.Generator;
import de.carne.util.Strings;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;

public abstract class JavaGenerator
extends Generator {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(JavaGenerator.class.getName());
    private static final MessageFormat TEMPLATE_FILE_COMMENT = new MessageFormat(BUNDLE.getString("TEMPLATE_FILE_COMMENT"));

    protected JavaGenerator(Date generationTimestamp, DateFormat generationTimestampFormat) {
        super(generationTimestamp, generationTimestampFormat);
    }

    protected String encodeComment(String data) {
        String[] dataLines = Strings.splitLines(data);
        StringBuilder buffer = new StringBuilder();
        for (String dataLine : dataLines) {
            if (buffer.length() > 0) {
                buffer.append("<br>");
            }
            block7: for (int dataLineIndex = 0; dataLineIndex < dataLine.length(); ++dataLineIndex) {
                char c = dataLine.charAt(dataLineIndex);
                switch (c) {
                    case '<': {
                        buffer.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        buffer.append("&gt;");
                        continue block7;
                    }
                    case '/': {
                        buffer.append("&frasl;");
                        continue block7;
                    }
                    case '@': {
                        buffer.append("&#" + Integer.toString(c) + ";");
                        continue block7;
                    }
                    default: {
                        buffer.append(c);
                    }
                }
            }
        }
        return buffer.toString();
    }

    protected void generateFileComment(Writer out, String timestamp, String title) throws IOException {
        this.write(out, TEMPLATE_FILE_COMMENT, timestamp, title);
    }
}

