/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.objectmapper;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.BinarySerializedObject;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumReference;
import de.caluga.morphium.NameProvider;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.mapping.MorphiumTypeMapper;
import de.caluga.morphium.objectmapper.MorphiumSerializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.reflect.ReflectionFactory;

public class MorphiumDeserializer {
    private final AnnotationAndReflectionHelper anhelper;
    private final Map<Class<?>, NameProvider> nameProviderByClass;
    private final Morphium morphium;
    private final ReflectionFactory reflection = ReflectionFactory.getReflectionFactory();
    private final Logger log = LoggerFactory.getLogger(MorphiumSerializer.class);
    private final SimpleModule module;
    private final ObjectMapper jackson;
    private final Map<Class, MorphiumTypeMapper> typeMapper;

    public MorphiumDeserializer(final AnnotationAndReflectionHelper anhelper, Map<Class<?>, NameProvider> nameProviderByClass, Morphium morphium, final Map<Class, MorphiumTypeMapper> typeMapper) {
        this.anhelper = anhelper;
        this.nameProviderByClass = nameProviderByClass;
        this.morphium = morphium;
        this.typeMapper = typeMapper;
        this.module = new SimpleModule();
        this.jackson = new ObjectMapper();
        this.jackson.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.jackson.setVisibility(this.jackson.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.ANY));
        this.module.setDeserializerModifier(new BeanDeserializerModifier(){

            public List<BeanPropertyDefinition> updateProperties(DeserializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> propDefs) {
                if (anhelper.isAnnotationPresentInHierarchy(beanDesc.getBeanClass(), Entity.class) || anhelper.isAnnotationPresentInHierarchy(beanDesc.getBeanClass(), Embedded.class)) {
                    ArrayList<BeanPropertyDefinition> lst = new ArrayList<BeanPropertyDefinition>();
                    for (BeanPropertyDefinition d : propDefs) {
                        Field fld = anhelper.getField(beanDesc.getBeanClass(), d.getName());
                        if (fld == null) {
                            return lst;
                        }
                        PropertyName pn = new PropertyName(anhelper.getFieldName(beanDesc.getBeanClass(), fld.getName()));
                        POJOPropertyBuilder def = new POJOPropertyBuilder((MapperConfig)config, null, false, pn);
                        def.addField(d.getField(), pn, false, true, false);
                        lst.add((BeanPropertyDefinition)def);
                    }
                    return lst;
                }
                return propDefs;
            }

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, final BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                JsonDeserializer def = super.modifyDeserializer(config, beanDesc, deserializer);
                if (anhelper.isAnnotationPresentInHierarchy(beanDesc.getBeanClass(), Entity.class) || anhelper.isAnnotationPresentInHierarchy(beanDesc.getBeanClass(), Embedded.class)) {
                    return new EntityDeserializer(beanDesc.getBeanClass(), anhelper);
                }
                if (typeMapper.containsKey(beanDesc.getBeanClass())) {
                    return new JsonDeserializer<Object>(){

                        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                            return ((MorphiumTypeMapper)typeMapper.get(beanDesc.getBeanClass())).unmarshall(jsonParser.readValueAs(Object.class));
                        }
                    };
                }
                if (Collection.class.isAssignableFrom(beanDesc.getBeanClass())) {
                    return new JsonDeserializer<Collection>(){

                        public Collection deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                            Collection toAdd = null;
                            try {
                                toAdd = (Collection)beanDesc.getBeanClass().newInstance();
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            List in = (List)jsonParser.readValueAs(List.class);
                            for (Object e : in) {
                                if (e instanceof Map) {
                                    if (((Map)e).get("class_name") != null) {
                                        try {
                                            Class clsName = anhelper.getClassForTypeId((String)((Map)e).get("class_name"));
                                            toAdd.add(MorphiumDeserializer.this.jackson.convertValue(e, clsName));
                                            continue;
                                        }
                                        catch (ClassNotFoundException e1) {
                                            throw new RuntimeException(e1);
                                        }
                                    }
                                    if (((Map)e).get("original_class_name") != null) {
                                        try {
                                            Object toPut = MorphiumDeserializer.this.jackson.convertValue(e, BinarySerializedObject.class);
                                            BASE64Decoder dec = new BASE64Decoder();
                                            try {
                                                ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(dec.decodeBuffer(((BinarySerializedObject)toPut).getB64Data())));
                                                toPut = oin.readObject();
                                                toAdd.add(toPut);
                                            }
                                            catch (IOException e1) {
                                                MorphiumDeserializer.this.log.error("Could not deserialize", e);
                                            }
                                        }
                                        catch (ClassNotFoundException e1) {
                                            e1.printStackTrace();
                                        }
                                        continue;
                                    }
                                }
                                toAdd.add(e);
                            }
                            return toAdd;
                        }
                    };
                }
                if (beanDesc.getBeanClass().isEnum()) {
                    return new JsonDeserializer<Enum>(){

                        public Enum deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                            Map m = (Map)jsonParser.readValueAs(Map.class);
                            Class target = null;
                            try {
                                target = anhelper.getClassForTypeId((String)m.get("class_name"));
                            }
                            catch (ClassNotFoundException e) {
                                throw new RuntimeException(e);
                            }
                            return Enum.valueOf(target, (String)m.get("name"));
                        }
                    };
                }
                return def;
            }
        });
        this.jackson.registerModule((Module)this.module);
    }

    public <T> T deserialize(Class<? extends T> theClass, Map<String, Object> o) {
        if (o.containsKey("in_answer_to")) {
            this.log.info("got answer");
        }
        Object ret = this.replaceMorphiumIds(o);
        return (T)this.jackson.convertValue(ret, theClass);
    }

    private Object replaceMorphiumIds(Object o) {
        if (o instanceof Map) {
            return this.replaceMorphiumIds((Map)o);
        }
        if (o instanceof ObjectId) {
            return new MorphiumId(((ObjectId)o).toHexString());
        }
        return o;
    }

    private Object replaceMorphiumIds(Map<String, Object> m) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : m.entrySet()) {
            if (e.getValue() instanceof Map) {
                ret.put(e.getKey(), this.replaceMorphiumIds((Map)e.getValue()));
                continue;
            }
            if (e.getValue() instanceof MorphiumId) {
                HashMap<String, String> mid = new HashMap<String, String>();
                mid.put("morphium id", e.getValue().toString());
                ret.put(e.getKey(), mid);
                continue;
            }
            if (e.getValue() instanceof ObjectId) {
                ret.put(e.getKey(), new MorphiumId(((ObjectId)e.getValue()).toByteArray()));
                continue;
            }
            if (e.getValue() instanceof List) {
                ret.put(e.getKey(), this.replaceMorphiumIds((List)e.getValue()));
                continue;
            }
            ret.put(e.getKey(), e.getValue());
        }
        return ret;
    }

    private Object replaceMorphiumIds(List value) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object o : value) {
            if (o instanceof MorphiumId) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("morphium id", o.toString());
                ret.add(m);
                continue;
            }
            if (o instanceof Map) {
                ret.add(this.replaceMorphiumIds((Map)o));
                continue;
            }
            if (o instanceof List) {
                ret.add(this.replaceMorphiumIds((List)o));
                continue;
            }
            ret.add(o);
        }
        return ret;
    }

    private Map handleMap(Type type, Map m) throws ClassNotFoundException {
        LinkedHashMap v = new LinkedHashMap();
        Class valueType = null;
        if (type != null && type instanceof ParameterizedType) {
            if (((ParameterizedType)type).getActualTypeArguments()[1] instanceof ParameterizedType) {
                valueType = null;
                type = ((ParameterizedType)type).getActualTypeArguments()[1];
            } else {
                valueType = (Class)((ParameterizedType)type).getActualTypeArguments()[1];
            }
        }
        for (Map.Entry e : m.entrySet()) {
            if (e.getValue() instanceof Map) {
                Object toPut = null;
                Map ev = (Map)e.getValue();
                Class cls = Map.class;
                if (ev.get("class_name") != null) {
                    cls = this.anhelper.getClassForTypeId((String)ev.get("class_name"));
                    toPut = cls.isEnum() ? Enum.valueOf(cls, (String)ev.get("name")) : this.jackson.convertValue((Object)ev, cls);
                } else if (ev.get("original_class_name") != null) {
                    toPut = this.jackson.convertValue((Object)ev, BinarySerializedObject.class);
                    BASE64Decoder dec = new BASE64Decoder();
                    try {
                        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(dec.decodeBuffer(((BinarySerializedObject)toPut).getB64Data())));
                        toPut = in.readObject();
                    }
                    catch (IOException e1) {
                        this.log.error("Could not deserialize", e);
                    }
                } else {
                    toPut = ev.get("morphium id") != null ? new MorphiumId((String)ev.get("morphium id")) : this.handleMap(type, ev);
                }
                v.put(e.getKey(), toPut);
                continue;
            }
            if (e.getValue() instanceof Collection) {
                Object retLst = null;
                retLst = this.handleList(type, (Collection)e.getValue());
                v.put(e.getKey(), retLst);
                continue;
            }
            v.put(e.getKey(), e.getValue());
        }
        return v;
    }

    private Object handleList(Type type, Collection listIn) throws ClassNotFoundException {
        Collection listOut;
        Class listElementType = null;
        try {
            Class cls;
            listOut = type instanceof Class ? (((Class)type).isInterface() ? (List.class.isAssignableFrom((Class)type) ? new ArrayList() : (Set.class.isAssignableFrom((Class)type) ? new LinkedHashSet() : new ArrayList())) : (((Class)type).isArray() ? new ArrayList() : (Collection)((Class)type).newInstance())) : (type instanceof ParameterizedType ? ((cls = (Class)((ParameterizedType)type).getRawType()).isInterface() ? (cls.equals(Set.class) ? new LinkedHashSet() : (cls.equals(List.class) ? new ArrayList() : new ArrayList())) : (Collection)cls.newInstance()) : new ArrayList());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (type != null && type instanceof ParameterizedType) {
            if (((ParameterizedType)type).getActualTypeArguments()[0] instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getActualTypeArguments()[0];
                listElementType = null;
            } else if (((ParameterizedType)type).getActualTypeArguments()[0] instanceof WildcardType) {
                type = ((WildcardType)((ParameterizedType)type).getActualTypeArguments()[0]).getUpperBounds()[0];
                listElementType = null;
            } else {
                listElementType = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            }
        }
        for (Object el : listIn) {
            if (el instanceof Map) {
                if (((Map)el).get("morphium id") != null) {
                    listOut.add(new MorphiumId((String)((Map)el).get("morphium id")));
                    continue;
                }
                if (((Map)el).get("referenced_class_name") != null && ((Map)el).get("refid") != null) {
                    MorphiumReference ref = (MorphiumReference)this.jackson.convertValue(el, MorphiumReference.class);
                    Object t = ref.isLazy() ? this.morphium.createLazyLoadedEntity(this.anhelper.getClassForTypeId(ref.getClassName()), ref.getId(), ref.getCollectionName()) : this.morphium.findById(this.anhelper.getClassForTypeId(ref.getClassName()), ref.getId(), ref.getCollectionName());
                    listOut.add(t);
                    continue;
                }
                if (((Map)el).get("class_name") != null) {
                    Class cls = this.anhelper.getClassForTypeId((String)((Map)el).get("class_name"));
                    if (cls.isEnum()) {
                        listOut.add(Enum.valueOf(cls, (String)((Map)el).get("name")));
                        continue;
                    }
                    listOut.add(this.jackson.convertValue(el, cls));
                    continue;
                }
                if (((Map)el).get("original_class_name") != null) {
                    Object toPut = this.jackson.convertValue(el, BinarySerializedObject.class);
                    BASE64Decoder dec = new BASE64Decoder();
                    try {
                        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(dec.decodeBuffer(((BinarySerializedObject)toPut).getB64Data())));
                        toPut = in.readObject();
                    }
                    catch (IOException e1) {
                        this.log.error("Could not deserialize", (Throwable)e1);
                    }
                    listOut.add(toPut);
                    continue;
                }
                if (listElementType != null) {
                    listOut.add(this.jackson.convertValue(el, listElementType));
                    continue;
                }
                listOut.add(this.handleMap(null, (Map)el));
                continue;
            }
            if (el instanceof List) {
                listOut.add(this.handleList(type, (List)el));
                continue;
            }
            if (listElementType != null) {
                listOut.add(this.jackson.convertValue(el, listElementType));
                continue;
            }
            listOut.add(el);
        }
        if (type != null && type instanceof Class && ((Class)type).isArray()) {
            Object arr = Array.newInstance(((Class)type).getComponentType(), listOut.size());
            int i = 0;
            for (Object listOutObj : listOut) {
                if (((Class)type).getComponentType().isPrimitive()) {
                    if (((Class)type).getComponentType().equals(Integer.TYPE)) {
                        if (listOutObj instanceof Double) {
                            Array.set(arr, i, ((Double)listOutObj).intValue());
                        } else if (listOutObj instanceof Integer) {
                            Array.set(arr, i, listOutObj);
                        } else if (listOutObj instanceof Long) {
                            Array.set(arr, i, ((Long)listOutObj).intValue());
                        } else {
                            Array.set(arr, i, listOutObj);
                        }
                    } else if (((Class)type).getComponentType().equals(Long.TYPE)) {
                        if (listOutObj instanceof Double) {
                            Array.set(arr, i, ((Double)listOutObj).longValue());
                        } else if (listOutObj instanceof Integer) {
                            Array.set(arr, i, ((Integer)listOutObj).longValue());
                        } else if (listOutObj instanceof Long) {
                            Array.set(arr, i, listOutObj);
                        } else {
                            Array.set(arr, i, listOutObj);
                        }
                    } else if (((Class)type).getComponentType().equals(Float.TYPE)) {
                        if (listOutObj instanceof Double) {
                            Array.set(arr, i, Float.valueOf(((Double)listOutObj).floatValue()));
                        } else if (listOutObj instanceof Integer) {
                            Array.set(arr, i, Float.valueOf(((Integer)listOutObj).floatValue()));
                        } else if (listOutObj instanceof Long) {
                            Array.set(arr, i, Float.valueOf(((Long)listOutObj).floatValue()));
                        } else {
                            Array.set(arr, i, listOutObj);
                        }
                    } else if (((Class)type).getComponentType().equals(Double.TYPE)) {
                        if (listOutObj instanceof Float) {
                            Array.set(arr, i, ((Float)listOutObj).doubleValue());
                        } else if (listOutObj instanceof Integer) {
                            Array.set(arr, i, ((Integer)listOutObj).doubleValue());
                        } else if (listOutObj instanceof Long) {
                            Array.set(arr, i, ((Long)listOutObj).doubleValue());
                        } else {
                            Array.set(arr, i, listOutObj);
                        }
                    } else if (((Class)type).getComponentType().equals(Byte.TYPE)) {
                        if (listOutObj instanceof Integer) {
                            Array.set(arr, i, ((Integer)listOutObj).byteValue());
                        } else if (listOutObj instanceof Long) {
                            Array.set(arr, i, ((Long)listOutObj).byteValue());
                        } else {
                            Array.set(arr, i, listOutObj);
                        }
                    } else if (((Class)type).getComponentType().equals(Boolean.TYPE)) {
                        if (listOutObj instanceof String) {
                            Array.set(arr, i, listOutObj.toString().equalsIgnoreCase("true"));
                        } else if (listOutObj instanceof Integer) {
                            Array.set(arr, i, (Integer)listOutObj == 1);
                        } else {
                            Array.set(arr, i, listOutObj);
                        }
                    }
                } else {
                    Array.set(arr, i, listOutObj);
                }
                ++i;
            }
            return arr;
        }
        return listOut;
    }

    private class EntityDeserializer
    extends JsonDeserializer<Object> {
        private final AnnotationAndReflectionHelper anhelper;
        private Logger log = LoggerFactory.getLogger(EntityDeserializer.class);
        private Class type;

        public EntityDeserializer(Class cls, AnnotationAndReflectionHelper an) {
            this.type = cls;
            this.anhelper = an;
        }

        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            try {
                Object ret = null;
                if (this.type.isInterface() || Modifier.isAbstract(this.type.getModifiers())) {
                    Map m = (Map)jsonParser.readValueAs(Map.class);
                    if (m.get("class_name") != null) {
                        ret = MorphiumDeserializer.this.jackson.convertValue((Object)m, this.anhelper.getClassForTypeId(m.get("class_name").toString()));
                    }
                    return ret;
                }
                try {
                    ret = this.type.newInstance();
                }
                catch (Exception m) {
                    // empty catch block
                }
                if (ret == null) {
                    try {
                        Constructor<?> constructor = MorphiumDeserializer.this.reflection.newConstructorForSerialization(this.type, Object.class.getDeclaredConstructor(new Class[0]));
                        ret = constructor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        this.log.error("Exception during instanciation of type " + this.type.getName(), (Throwable)e);
                    }
                }
                String adField = this.anhelper.getAdditionalDataField(this.type);
                JsonToken tok = null;
                String currentName = "";
                while (true) {
                    if ((tok = jsonParser.nextToken()) == null) {
                        return ret;
                    }
                    if (tok.equals((Object)JsonToken.FIELD_NAME)) {
                        currentName = jsonParser.getCurrentName();
                        continue;
                    }
                    Field f = this.anhelper.getField(this.type, currentName);
                    if (tok.equals((Object)JsonToken.START_ARRAY)) {
                        List o = (List)MorphiumDeserializer.this.jackson.readValue(jsonParser, List.class);
                        if (f == null && adField != null) {
                            this.anhelper.getField(this.type, adField).set(ret, o);
                            continue;
                        }
                        if (f == null) continue;
                        f.set(ret, MorphiumDeserializer.this.handleList(f.getGenericType(), o));
                        continue;
                    }
                    if (tok.equals((Object)JsonToken.START_OBJECT)) {
                        if (f != null && f.getType().isEnum()) {
                            Map v = (Map)jsonParser.readValueAs(Map.class);
                            f.set(ret, Enum.valueOf(f.getType(), (String)v.get("name")));
                            continue;
                        }
                        if (f != null) {
                            Object v;
                            Reference r = f.getAnnotation(Reference.class);
                            if (r != null) {
                                if (Map.class.isAssignableFrom(f.getType())) {
                                    LinkedHashMap toSet = new LinkedHashMap();
                                    Map in = (Map)MorphiumDeserializer.this.jackson.readValue(jsonParser, Map.class);
                                    for (Map.Entry entry : in.entrySet()) {
                                        MorphiumReference ref = (MorphiumReference)MorphiumDeserializer.this.jackson.convertValue(entry.getValue(), MorphiumReference.class);
                                        Object id = MorphiumDeserializer.this.replaceMorphiumIds(ref.getId());
                                        Class<?> cls = Class.forName(ref.getClassName());
                                        if (ref.isLazy()) {
                                            toSet.put(entry.getKey(), MorphiumDeserializer.this.morphium.createLazyLoadedEntity(cls, id, ref.getCollectionName()));
                                            continue;
                                        }
                                        Object refObj = MorphiumDeserializer.this.morphium.findById(cls, id);
                                        toSet.put(entry.getKey(), refObj);
                                    }
                                    f.set(ret, toSet);
                                    continue;
                                }
                                MorphiumReference ref = (MorphiumReference)MorphiumDeserializer.this.jackson.readValue(jsonParser, MorphiumReference.class);
                                if (r.lazyLoading()) {
                                    f.set(ret, MorphiumDeserializer.this.morphium.createLazyLoadedEntity(f.getType(), ref.getId(), ref.getCollectionName()));
                                    continue;
                                }
                                Object id = MorphiumDeserializer.this.replaceMorphiumIds(ref.getId());
                                Object refObj = MorphiumDeserializer.this.morphium.findById(f.getType(), id);
                                f.set(ret, refObj);
                                continue;
                            }
                            if (Map.class.isAssignableFrom(f.getType())) {
                                Map m = (Map)MorphiumDeserializer.this.jackson.readValue(jsonParser, f.getType());
                                Map v2 = MorphiumDeserializer.this.handleMap(f.getGenericType(), m);
                                f.set(ret, v2);
                                continue;
                            }
                            if (f.getType().equals(String.class)) {
                                f.set(ret, MorphiumDeserializer.this.jackson.readValue(jsonParser, Object.class).toString());
                                continue;
                            }
                            if (f.getType().equals(MorphiumId.class)) {
                                v = (ObjectId)MorphiumDeserializer.this.jackson.readValue(jsonParser, ObjectId.class);
                                f.set(ret, new MorphiumId(v.toHexString()));
                                continue;
                            }
                            v = (Map)MorphiumDeserializer.this.jackson.readValue(jsonParser, Map.class);
                            if (v.containsKey("morphium id")) {
                                f.set(ret, new MorphiumId(v.get("morphium id").toString()));
                                continue;
                            }
                            f.set(ret, MorphiumDeserializer.this.jackson.convertValue(v, f.getType()));
                            continue;
                        }
                        this.readAdditionalValue(jsonParser, ret, adField, currentName);
                        continue;
                    }
                    if (tok.equals((Object)JsonToken.END_OBJECT)) {
                        return ret;
                    }
                    if (f == null) {
                        this.readAdditionalValue(jsonParser, ret, adField, currentName);
                        continue;
                    }
                    f.set(ret, MorphiumDeserializer.this.jackson.readValue(jsonParser, f.getType()));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void readAdditionalValue(JsonParser jsonParser, Object ret, String adField, String currentName) throws IllegalAccessException, IOException {
            if (adField != null) {
                Field field = this.anhelper.getField(this.type, adField);
                if (field.get(ret) == null) {
                    field.set(ret, new LinkedHashMap());
                }
                ((Map)field.get(ret)).put(currentName, MorphiumDeserializer.this.jackson.readValue(jsonParser, Object.class));
            } else {
                MorphiumDeserializer.this.jackson.readValue(jsonParser, Object.class);
            }
        }
    }
}

