/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.cache.jcache;

import de.caluga.morphium.cache.jcache.CacheManagerImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;

public class CachingProviderImpl
implements CachingProvider {
    private Map<URI, CacheManagerImpl> managers = new ConcurrentHashMap<URI, CacheManagerImpl>();

    public Collection<CacheManagerImpl> getCacheManagers() {
        return this.managers.values();
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        if (!this.managers.containsKey(uri)) {
            CacheManagerImpl cacheManager = new CacheManagerImpl(properties);
            cacheManager.setCachingProvider(this);
            cacheManager.setUri(uri);
            this.managers.put(uri, cacheManager);
        }
        return this.managers.get(uri);
    }

    public ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    public URI getDefaultURI() {
        try {
            return new URI("default");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Properties getDefaultProperties() {
        return new Properties();
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, this.getDefaultProperties());
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader(), this.getDefaultProperties());
    }

    public void close() {
        for (Map.Entry<URI, CacheManagerImpl> e : this.managers.entrySet()) {
            e.getValue().close();
        }
    }

    public void close(ClassLoader classLoader) {
        this.close();
    }

    public void close(URI uri, ClassLoader classLoader) {
        this.getCacheManager(uri, classLoader).close();
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        return false;
    }
}

