/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.cache;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.cache.CacheSyncListener;
import de.caluga.morphium.cache.CacheSyncVetoException;
import de.caluga.morphium.cache.MessagingCacheSynchronizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheSynchronizer<T extends CacheSyncListener> {
    protected static final Logger log = LoggerFactory.getLogger(MessagingCacheSynchronizer.class);
    protected Morphium morphium;
    protected List<T> listeners = Collections.synchronizedList(new ArrayList());
    protected Hashtable<Class<?>, Vector<T>> listenerForType = new Hashtable();

    public AbstractCacheSynchronizer(Morphium morphium) {
        this.morphium = morphium;
    }

    public void addSyncListener(T cl) {
        this.listeners.add(cl);
    }

    public void removeSyncListener(T cl) {
        this.listeners.remove(cl);
    }

    public void addSyncListener(Class type, T cl) {
        this.listenerForType.putIfAbsent(type, new Vector());
        this.listenerForType.get(type).add(cl);
    }

    public void removeSyncListener(Class type, T cl) {
        if (this.listenerForType.get(type) == null) {
            return;
        }
        this.listenerForType.get(type).remove(cl);
    }

    protected void firePreClearEvent(Class type) throws CacheSyncVetoException {
        for (CacheSyncListener cl : this.listeners) {
            cl.preClear(type);
        }
        if (type == null) {
            return;
        }
        if (this.listenerForType.get(type) != null) {
            for (CacheSyncListener cl : this.listenerForType.get(type)) {
                cl.preClear(type);
            }
        }
    }

    public void firePostClearEvent(Class type) {
        for (CacheSyncListener cl : this.listeners) {
            cl.postClear(type);
        }
        if (type == null) {
            return;
        }
        if (this.listenerForType.get(type) != null) {
            for (CacheSyncListener cl : this.listenerForType.get(type)) {
                cl.postClear(type);
            }
        }
    }
}

