/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.query;

import de.caluga.morphium.query.MorphiumIterator;
import de.caluga.morphium.query.Query;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefetchingMorphiumIterator<T>
implements MorphiumIterator<T> {
    private final Logger log = LoggerFactory.getLogger(MorphiumIterator.class);
    private int windowSize = 1;
    private Query<T> theQuery;
    private Container<T>[] prefetchBuffers;
    private int cursor = 0;
    private long count = 0L;
    private long limit;
    private int prefetchWindows = 2;
    private boolean multithreaddedAccess = false;

    public PrefetchingMorphiumIterator() {
        this.log.warn("Prefetching Iterator is relaying on skip-functionality of mongo which can cause problems in some cases - use DefaultMorphiumIterator instead");
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return (long)this.cursor < this.count && (long)this.cursor < this.limit;
    }

    private List getBuffer(int windowNumber) {
        try {
            List<T> list;
            int skp = windowNumber * this.windowSize;
            Query<T> q = this.theQuery.clone();
            q.skip(skp);
            q.limit(this.windowSize);
            if (q.getSort() == null || q.getSort().isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("No sort parameter given - sorting by _id");
                }
                q.sort("_id");
            }
            if ((list = q.asList()).isEmpty()) {
                this.log.error("No results?");
            }
            return list;
        }
        catch (CloneNotSupportedException e) {
            this.log.error("CLONE FAILED!?!?!?!?");
            return new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T next() {
        if (this.multithreaddedAccess) {
            PrefetchingMorphiumIterator prefetchingMorphiumIterator = this;
            synchronized (prefetchingMorphiumIterator) {
                return this.doNext();
            }
        }
        return this.doNext();
    }

    private T doNext() {
        if ((long)this.cursor > this.count || (long)this.cursor > this.limit) {
            return null;
        }
        if (this.prefetchBuffers == null) {
            this.prefetchBuffers = new Container[this.prefetchWindows];
            this.prefetchBuffers[0] = new Container();
            this.prefetchBuffers[0].setData(this.getBuffer(this.cursor / this.windowSize));
            for (int i = this.cursor / this.windowSize + 1; i < this.prefetchWindows; ++i) {
                Container c = new Container();
                this.prefetchBuffers[i] = c;
                int idx = i;
                Runnable cmd = () -> {
                    if ((long)(idx * this.windowSize) <= this.limit && (long)(idx * this.windowSize) <= this.count) {
                        c.setData(this.getBuffer(idx));
                    }
                };
                boolean queued = false;
                while (!queued) {
                    try {
                        this.theQuery.getMorphium().queueTask(cmd);
                        queued = true;
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        while (this.prefetchBuffers[0].getData() == null) {
            Thread.yield();
        }
        T ret = this.prefetchBuffers[0].getData().isEmpty() ? null : (T)this.prefetchBuffers[0].getData().get(this.cursor % this.windowSize);
        if (this.cursor % this.windowSize + 1 >= this.windowSize) {
            System.arraycopy(this.prefetchBuffers, 1, this.prefetchBuffers, 0, this.prefetchWindows - 1);
            this.prefetchBuffers[this.prefetchWindows - 1] = new Container();
            int win = this.cursor / this.windowSize + this.prefetchWindows;
            ++this.cursor;
            if ((long)(win * this.windowSize) < this.count) {
                Container<T> container = this.prefetchBuffers[this.prefetchWindows - 1];
                this.theQuery.getMorphium().queueTask(() -> container.setData(this.getBuffer(win)));
            }
        } else {
            ++this.cursor;
        }
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not possible on MorphiumIterators");
    }

    @Override
    public int getWindowSize() {
        return this.windowSize;
    }

    @Override
    public void setWindowSize(int sz) {
        this.windowSize = sz;
    }

    @Override
    public Query<T> getQuery() {
        return this.theQuery;
    }

    @Override
    public void setQuery(Query<T> q) {
        try {
            this.theQuery = q.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.count = this.theQuery.countAll();
        this.limit = this.theQuery.getLimit();
        if (this.limit <= 0L) {
            this.limit = this.count;
        }
    }

    @Override
    public int getCurrentBufferSize() {
        if (this.prefetchBuffers == null) {
            return 0;
        }
        if (this.prefetchBuffers[0] == null || this.prefetchBuffers[0].getData() == null) {
            return 0;
        }
        int cnt = 0;
        for (Container<T> buffer : this.prefetchBuffers) {
            if (buffer.getData() == null) continue;
            cnt += buffer.getData().size();
        }
        return cnt;
    }

    @Override
    public List<T> getCurrentBuffer() {
        if (this.prefetchBuffers == null || this.prefetchBuffers[0] == null || this.prefetchBuffers[0].getData() == null) {
            return new ArrayList();
        }
        return this.prefetchBuffers[0].getData();
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public int getCursor() {
        return this.cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ahead(int jump) {
        if (this.multithreaddedAccess) {
            PrefetchingMorphiumIterator prefetchingMorphiumIterator = this;
            synchronized (prefetchingMorphiumIterator) {
                this.doAhead(jump);
            }
        } else {
            this.doAhead(jump);
        }
    }

    private void doAhead(int jump) {
        if (this.cursor / this.windowSize * this.windowSize + this.windowSize <= this.cursor + jump) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Would jump over boundary - resetting buffer");
            }
            this.prefetchBuffers = null;
        }
        this.cursor += jump;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void back(int jump) {
        if (this.multithreaddedAccess) {
            PrefetchingMorphiumIterator prefetchingMorphiumIterator = this;
            synchronized (prefetchingMorphiumIterator) {
                this.doBack(jump);
            }
        } else {
            this.doBack(jump);
        }
    }

    private void doBack(int jump) {
        if (this.cursor / this.windowSize * this.windowSize > this.cursor - jump) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Would jump before boundary - resetting buffer");
            }
            this.prefetchBuffers = null;
        }
        this.cursor -= jump;
    }

    @Override
    public void setNumberOfPrefetchWindows(int n) {
        this.prefetchWindows = n;
    }

    @Override
    public int getNumberOfAvailableThreads() {
        return this.theQuery.getMorphium().getNumberOfAvailableThreads();
    }

    @Override
    public int getNumberOfThreads() {
        return this.theQuery.getMorphium().getActiveThreads();
    }

    @Override
    public boolean isMultithreaddedAccess() {
        return this.multithreaddedAccess;
    }

    @Override
    public void setMultithreaddedAccess(boolean mu) {
        this.multithreaddedAccess = mu;
    }

    private class Container<T> {
        private List<T> data;

        private Container() {
        }

        public List<T> getData() {
            return this.data;
        }

        public void setData(List<T> data) {
            this.data = data;
        }
    }
}

