/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.mongodb;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequest;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.bulk.DeleteBulkRequest;
import de.caluga.morphium.driver.bulk.InsertBulkRequest;
import de.caluga.morphium.driver.bulk.StoreBulkRequest;
import de.caluga.morphium.driver.bulk.UpdateBulkRequest;
import de.caluga.morphium.driver.mongodb.Driver;
import de.caluga.morphium.driver.mongodb.DriverHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbBulkContext
extends BulkRequestContext {
    private final Logger log = LoggerFactory.getLogger(MongodbBulkContext.class);
    private final Driver driver;
    private final boolean ordered;
    private final String db;
    private final String collection;
    private final WriteConcern wc;
    private final List<BulkRequest> requests;

    public MongodbBulkContext(Morphium m, String db, String collection, Driver driver, boolean ordered, int batchSize, WriteConcern wc) {
        super(m);
        this.driver = driver;
        this.ordered = ordered;
        this.db = db;
        this.collection = collection;
        this.wc = wc;
        this.setBatchSize(batchSize);
        this.requests = new ArrayList<BulkRequest>();
    }

    public void addRequest(BulkRequest br) {
        this.requests.add(br);
    }

    @Override
    public UpdateBulkRequest addUpdateBulkRequest() {
        UpdateBulkRequest up = new UpdateBulkRequest();
        this.addRequest(up);
        return up;
    }

    @Override
    public InsertBulkRequest addInsertBulkRequest(List<Map<String, Object>> toInsert) {
        InsertBulkRequest in = new InsertBulkRequest(toInsert);
        this.addRequest(in);
        return in;
    }

    @Override
    public StoreBulkRequest addStoreBulkRequest(List<Map<String, Object>> toStore) {
        StoreBulkRequest store = new StoreBulkRequest(toStore);
        this.addRequest(store);
        return store;
    }

    @Override
    public DeleteBulkRequest addDeleteBulkRequest() {
        DeleteBulkRequest del = new DeleteBulkRequest();
        this.addRequest(del);
        return del;
    }

    @Override
    public Map<String, Object> execute() {
        ArrayList<WriteModel<? extends Document>> lst = new ArrayList<WriteModel<? extends Document>>();
        int count = 0;
        ArrayList<BulkWriteResult> results = new ArrayList<BulkWriteResult>();
        for (BulkRequest br : this.requests) {
            if (br instanceof InsertBulkRequest) {
                InsertBulkRequest ib = (InsertBulkRequest)br;
                DriverHelper.replaceMorphiumIdByObjectId(ib.getToInsert());
                for (Map<String, Object> o : ib.getToInsert()) {
                    Document document = new Document(o);
                    lst.add((WriteModel<? extends Document>)new InsertOneModel((Object)document));
                }
            } else if (br instanceof DeleteBulkRequest) {
                DeleteBulkRequest dbr = (DeleteBulkRequest)br;
                DriverHelper.replaceMorphiumIdByObjectId(((DeleteBulkRequest)br).getQuery());
                if (dbr.isMultiple()) {
                    lst.add((WriteModel<? extends Document>)new DeleteManyModel((Bson)new Document(dbr.getQuery())));
                } else {
                    lst.add((WriteModel<? extends Document>)new DeleteOneModel((Bson)new Document(dbr.getQuery())));
                }
            } else {
                UpdateBulkRequest up = (UpdateBulkRequest)br;
                UpdateOptions upd = new UpdateOptions();
                upd.upsert(up.isUpsert());
                DriverHelper.replaceMorphiumIdByObjectId(up.getQuery());
                DriverHelper.replaceMorphiumIdByObjectId(up.getCmd());
                if (up.isMultiple()) {
                    UpdateManyModel updateModel = new UpdateManyModel((Bson)new Document(up.getQuery()), (Bson)new Document(up.getCmd()), upd);
                    lst.add((WriteModel<? extends Document>)updateModel);
                } else {
                    lst.add((WriteModel<? extends Document>)new UpdateOneModel((Bson)new Document(up.getQuery()), (Bson)new Document(up.getCmd()), upd));
                }
            }
            if (++count < this.driver.getMaximums().getMaxWriteBatchSize()) continue;
            results.add(this.commitWrite(lst));
            lst.clear();
        }
        if (!lst.isEmpty()) {
            results.add(this.commitWrite(lst));
            lst.clear();
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        int delCount = 0;
        int matchedCount = 0;
        int insertCount = 0;
        int modifiedCount = 0;
        int upsertCount = 0;
        for (BulkWriteResult r : results) {
            delCount += r.getDeletedCount();
            matchedCount += r.getMatchedCount();
            insertCount += r.getInsertedCount();
            modifiedCount += r.getModifiedCount();
            upsertCount += r.getUpserts().size();
        }
        res.put("num_del", delCount);
        res.put("num_matched", matchedCount);
        res.put("num_insert", insertCount);
        res.put("num_modified", modifiedCount);
        res.put("num_upserts", upsertCount);
        return res;
    }

    private BulkWriteResult commitWrite(List<WriteModel<? extends Document>> lst) {
        BulkWriteOptions bulkWriteOptions = new BulkWriteOptions();
        bulkWriteOptions.ordered(this.ordered);
        return this.driver.getCollection(this.driver.getDb(this.db), this.collection, ReadPreference.nearest(), this.wc).bulkWrite(lst, bulkWriteOptions);
    }
}

