/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.ClientSessionOptions;
import com.mongodb.CommandResult;
import com.mongodb.CursorType;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.GroupCommand;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoCredential;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadConcern;
import com.mongodb.ServerAddress;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import com.mongodb.TransactionOptions;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.driver.DriverTailableIterationCallback;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumDriverOperation;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.driver.MorphiumTransactionContext;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.mongodb.DriverHelper;
import de.caluga.morphium.driver.mongodb.Maximums;
import de.caluga.morphium.driver.mongodb.MongoTransactionContext;
import de.caluga.morphium.driver.mongodb.MongodbBulkContext;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver
implements MorphiumDriver {
    private final Logger log = LoggerFactory.getLogger(Driver.class);
    private String[] hostSeed;
    private int maxConnectionsPerHost = 50;
    private int minConnectionsPerHost = 10;
    private int maxConnectionLifetime = 60000;
    private int maxConnectionIdleTime = 20000;
    private int socketTimeout = 1000;
    private int connectionTimeout = 1000;
    private int defaultW = 1;
    private int maxBlockintThreadMultiplier = 5;
    private int heartbeatFrequency = 1000;
    private int heartbeatSocketTimeout = 1000;
    private boolean useSSL = false;
    private boolean defaultJ = false;
    private int writeTimeout = 1000;
    private int localThreshold = 15;
    private boolean defaultFsync;
    private boolean socketKeepAlive;
    private int heartbeatConnectTimeout;
    private int maxWaitTime;
    private int defaultBatchSize = 100;
    private int retriesOnNetworkError = 2;
    private int sleepBetweenErrorRetries = 500;
    private ReadPreference defaultReadPreference;
    private Map<String, String[]> credentials = new HashMap<String, String[]>();
    private MongoClient mongo;
    private Maximums maximums;
    private boolean replicaset;
    private ThreadLocal<MongoTransactionContext> currentTransaction = new ThreadLocal();

    @Override
    public boolean isReplicaset() {
        return this.replicaset;
    }

    @Override
    public void setCredentials(String db, String login, char[] pwd) {
        String[] cred = new String[]{login, new String(pwd)};
        this.credentials.put(db, cred);
    }

    @Override
    public List<String> listDatabases() throws MorphiumDriverException {
        if (!this.isConnected()) {
            return null;
        }
        HashMap<String, Object> command = new HashMap<String, Object>();
        command.put("listDatabases", 1);
        Map<String, Object> res = this.runCommand("admin", command);
        ArrayList<String> ret = new ArrayList<String>();
        if (res.get("databases") != null) {
            List lst = (List)res.get("databases");
            for (Map db : lst) {
                if (db.get("name") != null) {
                    ret.add(db.get("name").toString());
                    continue;
                }
                this.log.error("No DB Name for this entry...");
            }
        }
        return ret;
    }

    @Override
    public List<String> listCollections(String db, String pattern) throws MorphiumDriverException {
        if (!this.isConnected()) {
            return null;
        }
        LinkedHashMap<String, Object> command = new LinkedHashMap<String, Object>();
        command.put("listCollections", 1);
        if (pattern != null) {
            HashMap<String, Pattern> query = new HashMap<String, Pattern>();
            query.put("name", Pattern.compile(pattern));
            command.put("filter", query);
        }
        Map<String, Object> res = this.runCommand(db, command);
        ArrayList<Map<String, Object>> colList = new ArrayList<Map<String, Object>>();
        ArrayList<String> colNames = new ArrayList<String>();
        this.addToListFromCursor(db, colList, res);
        for (Map map : colList) {
            colNames.add(map.get("name").toString());
        }
        return colNames;
    }

    private void addToListFromCursor(String db, List<Map<String, Object>> data, Map<String, Object> res) throws MorphiumDriverException {
        boolean valid;
        Map<String, Object> crs = (Map<String, Object>)res.get("cursor");
        do {
            if (crs.get("firstBatch") != null) {
                data.addAll((List)crs.get("firstBatch"));
            } else if (crs.get("nextBatch") != null) {
                data.addAll((List)crs.get("firstBatch"));
            }
            LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
            if (crs.get("id") != null && !crs.get("id").toString().equals("0")) {
                valid = true;
                doc.put("getMore", crs.get("id"));
                crs = this.runCommand(db, doc);
                continue;
            }
            valid = false;
        } while (valid);
    }

    public ReadPreference getDefaultReadPreference() {
        return this.defaultReadPreference;
    }

    @Override
    public void setDefaultReadPreference(ReadPreference defaultReadPreference) {
        this.defaultReadPreference = defaultReadPreference;
    }

    @Override
    public String[] getCredentials(String db) {
        return this.credentials.get(db);
    }

    @Override
    public boolean isDefaultFsync() {
        return this.defaultFsync;
    }

    @Override
    public void setDefaultFsync(boolean j) {
        this.defaultFsync = j;
    }

    @Override
    public String[] getHostSeed() {
        return this.hostSeed;
    }

    @Override
    public void setHostSeed(String ... host) {
        this.hostSeed = host;
    }

    @Override
    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    @Override
    public void setMaxConnectionsPerHost(int mx) {
        this.maxConnectionsPerHost = mx;
    }

    @Override
    public int getMinConnectionsPerHost() {
        return this.minConnectionsPerHost;
    }

    @Override
    public void setMinConnectionsPerHost(int mx) {
        this.minConnectionsPerHost = mx;
    }

    @Override
    public int getMaxConnectionLifetime() {
        return this.maxConnectionLifetime;
    }

    @Override
    public void setMaxConnectionLifetime(int timeout) {
        this.maxConnectionLifetime = timeout;
    }

    @Override
    public int getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    @Override
    public void setMaxConnectionIdleTime(int time) {
        this.maxConnectionIdleTime = time;
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    @Override
    public int getDefaultW() {
        return this.defaultW;
    }

    @Override
    public void setDefaultW(int w) {
        this.defaultW = w;
    }

    @Override
    public int getMaxBlockintThreadMultiplier() {
        return this.maxBlockintThreadMultiplier;
    }

    @Override
    public int getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    @Override
    public void setHeartbeatFrequency(int heartbeatFrequency) {
        this.heartbeatFrequency = heartbeatFrequency;
    }

    @Override
    public void setDefaultBatchSize(int defaultBatchSize) {
        this.defaultBatchSize = defaultBatchSize;
    }

    @Override
    public void setCredentials(Map<String, String[]> credentials) {
        this.credentials = credentials;
    }

    public void setMongo(MongoClient mongo) {
        this.mongo = mongo;
    }

    @Override
    public int getHeartbeatSocketTimeout() {
        return this.heartbeatSocketTimeout;
    }

    @Override
    public void setHeartbeatSocketTimeout(int heartbeatSocketTimeout) {
        this.heartbeatSocketTimeout = heartbeatSocketTimeout;
    }

    @Override
    public boolean isUseSSL() {
        return this.useSSL;
    }

    @Override
    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    @Override
    public boolean isDefaultJ() {
        return this.defaultJ;
    }

    @Override
    public void setDefaultJ(boolean j) {
        this.defaultJ = j;
    }

    @Override
    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    @Override
    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    @Override
    public int getLocalThreshold() {
        return this.localThreshold;
    }

    @Override
    public void setLocalThreshold(int thr) {
        this.localThreshold = thr;
    }

    @Override
    public void setMaxBlockingThreadMultiplier(int m) {
        this.maxBlockintThreadMultiplier = m;
    }

    @Override
    public void heartBeatFrequency(int t) {
        this.heartbeatFrequency = t;
    }

    @Override
    public void heartBeatSocketTimeout(int t) {
        this.heartbeatSocketTimeout = t;
    }

    @Override
    public void useSsl(boolean ssl) {
        this.useSSL = ssl;
    }

    @Override
    public void connect() throws MorphiumDriverException {
        this.connect(null);
    }

    @Override
    public void connect(String replicasetName) throws MorphiumDriverException {
        block11: {
            try {
                MongoClientOptions.Builder o = MongoClientOptions.builder();
                com.mongodb.WriteConcern w = new com.mongodb.WriteConcern(this.getDefaultW(), this.getWriteTimeout(), this.isDefaultFsync(), this.isDefaultJ());
                o.writeConcern(w);
                o.socketTimeout(this.getSocketTimeout());
                o.connectTimeout(this.getConnectionTimeout());
                o.connectionsPerHost(this.getMaxConnectionsPerHost());
                o.socketKeepAlive(this.isSocketKeepAlive());
                o.threadsAllowedToBlockForConnectionMultiplier(this.getMaxBlockintThreadMultiplier());
                o.heartbeatConnectTimeout(this.getHeartbeatConnectTimeout());
                o.heartbeatFrequency(this.getHeartbeatFrequency());
                o.heartbeatSocketTimeout(this.getHeartbeatSocketTimeout());
                o.minConnectionsPerHost(this.getMinConnectionsPerHost());
                o.minHeartbeatFrequency(this.getHeartbeatFrequency());
                o.localThreshold(this.getLocalThreshold());
                o.maxConnectionIdleTime(this.getMaxConnectionIdleTime());
                o.maxConnectionLifeTime(this.getMaxConnectionLifetime());
                if (replicasetName != null) {
                    o.requiredReplicaSetName(replicasetName);
                }
                o.maxWaitTime(this.getMaxWaitTime());
                ArrayList<MongoCredential> lst = new ArrayList<MongoCredential>();
                for (Map.Entry<String, String[]> e : this.credentials.entrySet()) {
                    MongoCredential cred = MongoCredential.createCredential((String)e.getKey(), (String)e.getValue()[0], (char[])e.getValue()[1].toCharArray());
                    lst.add(cred);
                }
                if (this.hostSeed.length == 1) {
                    ServerAddress adr = new ServerAddress(this.hostSeed[0]);
                    this.mongo = new MongoClient(adr, lst, o.build());
                } else {
                    ArrayList<ServerAddress> adrLst = new ArrayList<ServerAddress>();
                    for (String h : this.hostSeed) {
                        adrLst.add(new ServerAddress(h));
                    }
                    this.mongo = new MongoClient(adrLst, lst, o.build());
                }
                try {
                    Document res = this.mongo.getDatabase("local").runCommand((Bson)new BasicDBObject("isMaster", (Object)true));
                    if (res.get((Object)"setName") != null) {
                        this.replicaset = true;
                    }
                }
                catch (MongoCommandException mce) {
                    if (mce.getCode() == 20) {
                        this.replicaset = false;
                        break block11;
                    }
                    throw new MorphiumDriverException("Error getting replicaset status", mce);
                }
            }
            catch (Exception e) {
                throw new MorphiumDriverException("Error creating connection to mongo", e);
            }
        }
    }

    @Override
    public Maximums getMaximums() {
        if (this.maximums == null) {
            this.maximums = new Maximums();
            try {
                HashMap<String, Object> cmd = new HashMap<String, Object>();
                cmd.put("isMaster", 1);
                Map<String, Object> res = this.runCommand("admin", cmd);
                this.maximums.setMaxBsonSize((Integer)res.get("maxBsonObjectSize"));
                this.maximums.setMaxMessageSize((Integer)res.get("maxMessageSizeBytes"));
                this.maximums.setMaxWriteBatchSize((Integer)res.get("maxWriteBatchSize"));
            }
            catch (Exception e) {
                this.log.error("Error reading max avalues from DB", (Throwable)e);
            }
        }
        return this.maximums;
    }

    @Override
    public boolean isConnected() {
        return this.mongo != null;
    }

    @Override
    public int getDefaultWriteTimeout() {
        return this.writeTimeout;
    }

    @Override
    public void setDefaultWriteTimeout(int wt) {
        this.writeTimeout = wt;
    }

    @Override
    public void close() throws MorphiumDriverException {
        try {
            this.mongo.close();
        }
        catch (Exception e) {
            throw new MorphiumDriverException("error closing", e);
        }
    }

    @Override
    public Map<String, Object> getReplsetStatus() throws MorphiumDriverException {
        return DriverHelper.doCall(() -> {
            Document ret = this.mongo.getDatabase("admin").runCommand((Bson)new BasicDBObject("replSetGetStatus", (Object)1));
            List mem = (List)ret.get((Object)"members");
            if (mem == null) {
                return null;
            }
            mem.stream().filter(d -> d.get((Object)"optime") instanceof Map).forEach(d -> d.put("optime", ((Map)d.get((Object)"optime")).get("ts")));
            return this.convertBSON((Map)ret);
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public Map<String, Object> getDBStats(String db) throws MorphiumDriverException {
        return DriverHelper.doCall(() -> {
            Document ret = this.mongo.getDatabase(db).runCommand((Bson)new BasicDBObject("dbstats", (Object)1));
            return this.convertBSON((Map)ret);
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public Map<String, Object> getOps(long threshold) {
        throw new RuntimeException("Not implemented yet, sorry...");
    }

    @Override
    public Map<String, Object> runCommand(String db, Map<String, Object> cmd) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(cmd);
        return DriverHelper.doCall(() -> {
            Document ret = this.mongo.getDatabase(db).runCommand((Bson)new BasicDBObject(cmd));
            return this.convertBSON((Map)ret);
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public MorphiumCursor initIteration(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, Map<String, Object> findMetaData) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(query);
        return (MorphiumCursor)DriverHelper.doCall(() -> {
            FindIterable it;
            MongoDatabase database = this.mongo.getDatabase(db);
            MongoCollection<Document> c = this.getCollection(database, collection, readPreference, null);
            FindIterable findIterable = it = this.currentTransaction.get() == null ? c.find((Bson)new BasicDBObject(query)) : c.find(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query));
            if (projection != null) {
                it.projection((Bson)new BasicDBObject(projection));
            }
            if (sort != null) {
                it.sort((Bson)new BasicDBObject(sort));
            }
            if (skip != 0) {
                it.skip(skip);
            }
            if (limit != 0) {
                it.limit(limit);
            }
            if (batchSize != 0) {
                it.batchSize(batchSize);
            } else {
                it.batchSize(this.defaultBatchSize);
            }
            MongoCursor ret = it.iterator();
            this.handleMetaData(findMetaData, (MongoCursor<Document>)ret);
            ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
            while (ret.hasNext()) {
                Document d = (Document)ret.next();
                Map<String, Object> obj = this.convertBSON((Map)d);
                values.add(obj);
                int cnt = values.size();
                if ((cnt < batchSize || batchSize == 0) && (cnt < 1000 || batchSize != 0)) continue;
                break;
            }
            HashMap r = new HashMap();
            MorphiumCursor<MongoCursor> crs = new MorphiumCursor<MongoCursor>();
            crs.setBatchSize(batchSize);
            if (values.size() < batchSize && batchSize != 0 || values.size() < 1000 && batchSize == 0) {
                ret.close();
            } else {
                crs.setInternalCursorObject(ret);
            }
            crs.setBatch(values);
            r.put("result", crs);
            return r;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries).get("result");
    }

    @Override
    public void watch(String db, int maxWaitTime, boolean fullDocumentOnUpdate, DriverTailableIterationCallback cb) throws MorphiumDriverException {
        this.watch(db, null, maxWaitTime, fullDocumentOnUpdate, cb);
    }

    private boolean processChangeStreamEvent(DriverTailableIterationCallback cb, MongoCursor<ChangeStreamDocument<Document>> iterator, long start) {
        try {
            ChangeStreamDocument doc = (ChangeStreamDocument)iterator.next();
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("clusterTime", doc.getClusterTime().getValue());
            if (doc.getDocumentKey() != null) {
                obj.put("documentKey", new MorphiumId(((BsonObjectId)doc.getDocumentKey().get((Object)"_id")).getValue().toByteArray()));
            }
            obj.put("operationType", doc.getOperationType().getValue());
            if (doc.getFullDocument() != null) {
                obj.put("fullDocument", new LinkedHashMap((Map)doc.getFullDocument()));
            }
            if (doc.getResumeToken() != null) {
                obj.put("resumeToken", new LinkedHashMap(doc.getResumeToken()));
            }
            if (doc.getNamespace() != null) {
                obj.put("collectionName", doc.getNamespace().getCollectionName());
                obj.put("dbName", doc.getNamespace().getDatabaseName());
            }
            if (doc.getUpdateDescription() != null) {
                obj.put("removedFields", doc.getUpdateDescription().getRemovedFields());
                obj.put("updatedFields", new LinkedHashMap(doc.getUpdateDescription().getUpdatedFields()));
            }
            DriverHelper.replaceBsonValues(obj);
            boolean con = cb.incomingData(obj, System.currentTimeMillis() - start);
            return con;
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    @Override
    public void watch(String db, String collection, int maxWaitTime, boolean fullDocumentOnUpdate, DriverTailableIterationCallback cb) throws MorphiumDriverException {
        DriverHelper.doCall(() -> {
            boolean run = true;
            while (run) {
                ChangeStreamIterable it = null;
                it = collection != null ? this.mongo.getDatabase(db).getCollection(collection).watch() : this.mongo.getDatabase(db).watch();
                it.maxAwaitTime((long)maxWaitTime, TimeUnit.MILLISECONDS);
                it.batchSize(this.defaultBatchSize);
                it.fullDocument(fullDocumentOnUpdate ? FullDocument.UPDATE_LOOKUP : FullDocument.DEFAULT);
                MongoCursor iterator = it.iterator();
                long start = System.currentTimeMillis();
                while (iterator.hasNext() && run && (run = this.processChangeStreamEvent(cb, (MongoCursor<ChangeStreamDocument<Document>>)iterator, start))) {
                }
                iterator.close();
            }
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public void tailableIteration(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, int timeout, DriverTailableIterationCallback cb) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(query);
        DriverHelper.doCall(() -> {
            Document d;
            Map<String, Object> obj;
            FindIterable ret;
            MongoDatabase database = this.mongo.getDatabase(db);
            MongoCollection<Document> coll = this.getCollection(database, collection, readPreference, null);
            FindIterable findIterable = ret = this.currentTransaction.get() == null ? coll.find((Bson)new BasicDBObject(query)) : coll.find(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query));
            if (projection != null) {
                ret.projection((Bson)new BasicDBObject(projection));
            }
            if (sort != null) {
                ret = ret.sort((Bson)new BasicDBObject(sort));
            }
            if (skip != 0) {
                ret = ret.skip(skip);
            }
            if (limit != 0) {
                ret = ret.limit(limit);
            }
            if (batchSize != 0) {
                ret.batchSize(batchSize);
            } else {
                ret.batchSize(this.defaultBatchSize);
            }
            ret.cursorType(CursorType.TailableAwait);
            if (timeout == 0) {
                ret.noCursorTimeout(true);
            } else {
                ret.maxAwaitTime((long)timeout, TimeUnit.MILLISECONDS);
                ret.maxTime((long)timeout, TimeUnit.MILLISECONDS);
            }
            long start = System.currentTimeMillis();
            MongoCursor mongoCursor = ret.iterator();
            while (mongoCursor.hasNext() && cb.incomingData(obj = this.convertBSON((Map)(d = (Document)mongoCursor.next())), System.currentTimeMillis() - start)) {
            }
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    private void handleMetaData(Map<String, Object> findMetaData, MongoCursor<Document> ret) {
        if (findMetaData != null) {
            if (ret.getServerAddress() != null) {
                findMetaData.put("server", ret.getServerAddress().getHost() + ":" + ret.getServerAddress().getPort());
            }
            if (ret.getServerCursor() != null) {
                findMetaData.put("cursorId", ret.getServerCursor().getId());
            }
        }
    }

    @Override
    public MorphiumCursor nextIteration(MorphiumCursor crs) throws MorphiumDriverException {
        return (MorphiumCursor)DriverHelper.doCall(() -> {
            ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
            MorphiumCursor crs2 = crs;
            int batchSize = crs.getBatchSize();
            MongoCursor ret = (MongoCursor)crs2.getInternalCursorObject();
            if (ret == null) {
                return new HashMap();
            }
            while (ret.hasNext()) {
                Document d = (Document)ret.next();
                Map<String, Object> obj = this.convertBSON((Map)d);
                values.add(obj);
                int cnt = values.size();
                if ((cnt < batchSize || batchSize == 0) && (cnt < 1000 || batchSize != 0)) continue;
                break;
            }
            HashMap r = new HashMap();
            MorphiumCursor<MongoCursor> crs1 = new MorphiumCursor<MongoCursor>();
            crs1.setBatchSize(batchSize);
            if (values.size() < batchSize && batchSize != 0 || values.size() < 1000 && batchSize == 0) {
                ret.close();
            } else {
                crs1.setInternalCursorObject(ret);
            }
            crs1.setBatch(values);
            r.put("result", crs1);
            return r;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries).get("result");
    }

    @Override
    public void closeIteration(MorphiumCursor crs) throws MorphiumDriverException {
        DriverHelper.doCall(() -> {
            if (crs != null) {
                MongoCursor ret = (MongoCursor)crs.getInternalCursorObject();
                ret.close();
            }
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public List<Map<String, Object>> find(final String db, final String collection, final Map<String, Object> query, final Map<String, Integer> sort, final Map<String, Object> projection, final int skip, final int limit, final int batchSize, final ReadPreference readPreference, final Map<String, Object> findMetaData) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(query);
        return (List)DriverHelper.doCall(new MorphiumDriverOperation(){

            @Override
            public Map<String, Object> execute() {
                FindIterable it;
                MongoDatabase database = Driver.this.mongo.getDatabase(db);
                MongoCollection<Document> coll = Driver.this.getCollection(database, collection, Driver.this.currentTransaction.get() == null ? readPreference : ReadPreference.primary(), null);
                FindIterable findIterable = it = Driver.this.currentTransaction.get() == null ? coll.find((Bson)new BasicDBObject(query)) : coll.find(((MongoTransactionContext)((Driver)Driver.this).currentTransaction.get()).session, (Bson)new BasicDBObject(query));
                if (projection != null) {
                    it.projection((Bson)new BasicDBObject(projection));
                }
                if (sort != null) {
                    it.sort((Bson)new BasicDBObject(sort));
                }
                if (skip != 0) {
                    it.skip(skip);
                }
                if (limit != 0) {
                    it.limit(limit);
                }
                if (batchSize != 0) {
                    it.batchSize(batchSize);
                } else {
                    it.batchSize(Driver.this.defaultBatchSize);
                }
                it.maxAwaitTime((long)Driver.this.getMaxWaitTime(), TimeUnit.MILLISECONDS);
                it.maxTime((long)Driver.this.getMaxWaitTime(), TimeUnit.MILLISECONDS);
                MongoCursor ret = it.iterator();
                Driver.this.handleMetaData(findMetaData, (MongoCursor<Document>)ret);
                ArrayList<Map> values = new ArrayList<Map>();
                while (ret.hasNext()) {
                    Document d = (Document)ret.next();
                    Map obj = Driver.this.convertBSON((Map)d);
                    values.add(obj);
                }
                HashMap<String, Object> r = new HashMap<String, Object>();
                r.put("result", values);
                ret.close();
                return r;
            }
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries).get("result");
    }

    private Map<String, Object> convertBSON(Map d) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        for (Object k : d.keySet()) {
            HashMap m;
            Object value = d.get(k);
            if (value instanceof BsonTimestamp) {
                value = ((BsonTimestamp)value).getTime() * 1000;
            } else if (value instanceof BsonDocument) {
                value = this.convertBSON((Map)value);
            } else if (value instanceof BsonBoolean) {
                value = ((BsonBoolean)value).getValue();
            } else if (value instanceof BsonDateTime) {
                value = ((BsonDateTime)value).getValue();
            } else if (value instanceof BsonInt32) {
                value = ((BsonInt32)value).getValue();
            } else if (value instanceof BsonInt64) {
                value = ((BsonInt64)value).getValue();
            } else if (value instanceof BsonDouble) {
                value = ((BsonDouble)value).getValue();
            } else if (value instanceof ObjectId) {
                value = new MorphiumId(((ObjectId)value).toByteArray());
            } else if (value instanceof BasicDBList) {
                m = new HashMap();
                m.put("list", new ArrayList((BasicDBList)value));
                value = this.convertBSON(m).get("list");
            } else if (value instanceof BasicBSONObject || value instanceof Document || value instanceof BSONObject) {
                value = this.convertBSON((Map)value);
            } else if (value instanceof Binary) {
                Binary b = (Binary)value;
                value = b.getData();
            } else if (value instanceof BsonString) {
                value = value.toString();
            } else if (value instanceof List) {
                ArrayList<Object> v = new ArrayList<Object>();
                for (Object o : (List)value) {
                    if (o instanceof BSON || o instanceof BsonValue || o instanceof Map) {
                        v.add(this.convertBSON((Map)o));
                        continue;
                    }
                    if (o instanceof ObjectId) {
                        v.add(new MorphiumId(((ObjectId)o).toString()));
                        continue;
                    }
                    v.add(o);
                }
                value = v;
            } else if (value instanceof BsonArray) {
                m = new HashMap();
                m.put("list", new ArrayList(((BsonArray)value).getValues()));
                value = this.convertBSON(m).get("list");
            } else if (value instanceof Document) {
                value = this.convertBSON((Map)value);
            } else if (value instanceof BSONObject) {
                value = this.convertBSON((Map)value);
            }
            obj.put(k.toString(), value);
        }
        return obj;
    }

    public DBCollection getColl(DB database, String collection, ReadPreference readPreference, WriteConcern wc) {
        DBCollection coll = database.getCollection(collection);
        if (readPreference == null) {
            readPreference = this.defaultReadPreference;
        }
        if (readPreference != null) {
            com.mongodb.ReadPreference prf;
            TagSet tags = null;
            if (readPreference.getTagSet() != null) {
                List tagList = readPreference.getTagSet().entrySet().stream().map(e -> new Tag((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
                tags = new TagSet(tagList);
            }
            switch (readPreference.getType()) {
                case NEAREST: {
                    if (tags != null) {
                        prf = com.mongodb.ReadPreference.nearest(tags);
                        break;
                    }
                    prf = com.mongodb.ReadPreference.nearest();
                    break;
                }
                case PRIMARY: {
                    prf = com.mongodb.ReadPreference.primary();
                    if (tags == null) break;
                    this.log.warn("Cannot use tags with primary only read preference!");
                    break;
                }
                case PRIMARY_PREFERRED: {
                    if (tags != null) {
                        prf = com.mongodb.ReadPreference.primaryPreferred(tags);
                        break;
                    }
                    prf = com.mongodb.ReadPreference.primaryPreferred();
                    break;
                }
                case SECONDARY: {
                    if (tags != null) {
                        prf = com.mongodb.ReadPreference.secondary(tags);
                        break;
                    }
                    prf = com.mongodb.ReadPreference.secondary();
                    break;
                }
                case SECONDARY_PREFERRED: {
                    if (tags != null) {
                        prf = com.mongodb.ReadPreference.secondaryPreferred(tags);
                        break;
                    }
                    prf = com.mongodb.ReadPreference.secondary();
                    break;
                }
                default: {
                    this.log.error("Unhandeled read preference: " + readPreference.toString());
                    prf = null;
                }
            }
            if (prf != null) {
                coll.setReadPreference(prf);
            }
        }
        if (wc != null) {
            com.mongodb.WriteConcern writeConcern;
            if (wc.getW() < 0) {
                writeConcern = com.mongodb.WriteConcern.MAJORITY;
                writeConcern = writeConcern.withFsync(wc.isFsync());
                writeConcern = writeConcern.withJ(wc.isJ());
            } else {
                writeConcern = new com.mongodb.WriteConcern(wc.getW(), wc.getWtimeout(), wc.isFsync(), wc.isJ());
            }
            coll.setWriteConcern(writeConcern);
        }
        return coll;
    }

    public MongoCollection<Document> getCollection(MongoDatabase database, String collection, ReadPreference readPreference, WriteConcern wc) {
        MongoCollection coll = database.getCollection(collection);
        if (readPreference == null) {
            readPreference = this.defaultReadPreference;
        }
        if (readPreference != null) {
            com.mongodb.ReadPreference prf;
            TagSet tags = null;
            if (readPreference.getTagSet() != null) {
                List tagList = readPreference.getTagSet().entrySet().stream().map(e -> new Tag((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
                tags = new TagSet(tagList);
            }
            switch (readPreference.getType()) {
                case NEAREST: {
                    if (tags != null) {
                        prf = com.mongodb.ReadPreference.nearest(tags);
                        break;
                    }
                    prf = com.mongodb.ReadPreference.nearest();
                    break;
                }
                case PRIMARY: {
                    prf = com.mongodb.ReadPreference.primary();
                    if (tags == null) break;
                    this.log.warn("Cannot use tags with primary only read preference!");
                    break;
                }
                case PRIMARY_PREFERRED: {
                    if (tags != null) {
                        prf = com.mongodb.ReadPreference.primaryPreferred(tags);
                        break;
                    }
                    prf = com.mongodb.ReadPreference.primaryPreferred();
                    break;
                }
                case SECONDARY: {
                    if (tags != null) {
                        prf = com.mongodb.ReadPreference.secondary(tags);
                        break;
                    }
                    prf = com.mongodb.ReadPreference.secondary();
                    break;
                }
                case SECONDARY_PREFERRED: {
                    if (tags != null) {
                        prf = com.mongodb.ReadPreference.secondaryPreferred(tags);
                        break;
                    }
                    prf = com.mongodb.ReadPreference.secondary();
                    break;
                }
                default: {
                    this.log.error("Unhandeled read preference: " + readPreference.toString());
                    prf = null;
                }
            }
            if (prf != null) {
                coll = coll.withReadPreference(prf);
            }
        }
        if (wc != null) {
            com.mongodb.WriteConcern writeConcern;
            if (wc.getW() < 0) {
                writeConcern = com.mongodb.WriteConcern.MAJORITY;
                writeConcern = writeConcern.withFsync(wc.isFsync());
                writeConcern = writeConcern.withJ(wc.isJ());
            } else {
                writeConcern = new com.mongodb.WriteConcern(wc.getW(), wc.getWtimeout() >= 0 ? wc.getWtimeout() : 0, wc.isFsync(), wc.isJ());
            }
            coll = coll.withWriteConcern(writeConcern);
        }
        return coll;
    }

    @Override
    public long count(String db, String collection, Map<String, Object> query, ReadPreference rp) {
        DriverHelper.replaceMorphiumIdByObjectId(query);
        MongoDatabase database = this.mongo.getDatabase(db);
        MongoCollection<Document> coll = this.getCollection(database, collection, rp, null);
        return coll.count((Bson)new BasicDBObject(query));
    }

    @Override
    public Map<String, Object> store(String db, String collection, List<Map<String, Object>> objs, WriteConcern wc) throws MorphiumDriverException {
        ArrayList<Map<String, Object>> isnew = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> notnew = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> o : objs) {
            if (o.get("_id") == null) {
                isnew.add(o);
                continue;
            }
            notnew.add(o);
        }
        if (!isnew.isEmpty()) {
            this.insert(db, collection, isnew, wc);
        }
        Map<String, Object> m = DriverHelper.doCall(() -> {
            DriverHelper.replaceMorphiumIdByObjectId(notnew);
            MongoCollection c = this.mongo.getDatabase(db).getCollection(collection);
            HashMap<String, Integer> ret = new HashMap<String, Integer>();
            int total = notnew.size();
            int updated = 0;
            for (Map toUpdate : notnew) {
                UpdateOptions o = new UpdateOptions();
                o.upsert(true);
                Document filter = new Document();
                Object id = toUpdate.get("_id");
                if (id instanceof MorphiumId) {
                    id = new ObjectId(id.toString());
                }
                filter.put("_id", id);
                if (toUpdate.get("morphium version") != null) {
                    filter.put("morphium version", toUpdate.get("morphium version"));
                }
                Document tDocument = new Document(toUpdate);
                for (String k : tDocument.keySet()) {
                    if (!(tDocument.get((Object)k) instanceof byte[])) continue;
                    BsonBinary b = new BsonBinary((byte[])tDocument.get((Object)k));
                    tDocument.put(k, (Object)b);
                }
                tDocument.remove((Object)"_id");
                try {
                    UpdateResult res = c.replaceOne((Bson)filter, (Object)tDocument, o);
                    updated = (int)((long)updated + res.getModifiedCount());
                    id = toUpdate.get("_id");
                    if (!(id instanceof ObjectId)) continue;
                    toUpdate.put("_id", new MorphiumId(((ObjectId)id).toHexString()));
                }
                catch (Exception e) {
                    if (e instanceof MongoWriteException && e.getMessage().contains("E11000 duplicate key error")) {
                        throw new ConcurrentModificationException("Version mismach - write failed", e);
                    }
                    throw new RuntimeException(e);
                }
            }
            ret.put("modified", updated);
            ret.put("total", total);
            return ret;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
        m.put("inserted", isnew.size());
        return m;
    }

    @Override
    public void insert(String db, String collection, List<Map<String, Object>> objs, WriteConcern wc) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(objs);
        if (objs == null || objs.isEmpty()) {
            return;
        }
        List lst = objs.stream().map(Document::new).collect(Collectors.toList());
        for (Document d : lst) {
            for (String k : d.keySet()) {
                if (!(d.get((Object)k) instanceof byte[])) continue;
                BsonBinary b = new BsonBinary((byte[])d.get((Object)k));
                d.put(k, (Object)b);
            }
        }
        DriverHelper.doCall(() -> {
            MongoCollection c = this.mongo.getDatabase(db).getCollection(collection);
            if (lst.size() == 1) {
                InsertOneOptions op = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
                if (this.currentTransaction.get() == null) {
                    c.insertOne(lst.get(0), op);
                } else {
                    c.insertOne(this.currentTransaction.get().getSession(), lst.get(0), op);
                }
            } else {
                InsertManyOptions imo = new InsertManyOptions();
                imo.ordered(false);
                imo.bypassDocumentValidation(Boolean.valueOf(true));
                if (this.currentTransaction.get() == null) {
                    c.insertMany(lst, imo);
                } else {
                    c.insertMany(this.currentTransaction.get().getSession(), lst, imo);
                }
            }
            for (int i = 0; i < lst.size(); ++i) {
                Object id = ((Document)lst.get(i)).get((Object)"_id");
                if (id instanceof ObjectId) {
                    id = new MorphiumId(((ObjectId)id).toHexString());
                }
                ((Map)objs.get(i)).put("_id", id);
            }
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public Map<String, Object> update(String db, String collection, Map<String, Object> query, Map<String, Object> op, boolean multiple, boolean upsert, WriteConcern wc) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(query);
        DriverHelper.replaceMorphiumIdByObjectId(op);
        return DriverHelper.doCall(() -> {
            UpdateOptions opts = new UpdateOptions();
            com.mongodb.WriteConcern w = new com.mongodb.WriteConcern(wc != null ? wc.getW() : this.getDefaultW(), wc != null ? wc.getWtimeout() : this.getDefaultWriteTimeout(), wc != null ? wc.isFsync() : true, wc != null ? wc.isJ() : false);
            opts.upsert(upsert);
            UpdateResult res = multiple ? (this.currentTransaction.get() == null ? this.mongo.getDatabase(db).getCollection(collection).withWriteConcern(w).updateMany((Bson)new BasicDBObject(query), (Bson)new BasicDBObject(op), opts) : this.mongo.getDatabase(db).getCollection(collection).withWriteConcern(w).updateMany(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query), (Bson)new BasicDBObject(op), opts)) : (this.currentTransaction.get() == null ? this.mongo.getDatabase(db).getCollection(collection).withWriteConcern(w).updateOne((Bson)new BasicDBObject(query), (Bson)new BasicDBObject(op), opts) : this.mongo.getDatabase(db).getCollection(collection).withWriteConcern(w).updateOne(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query), (Bson)new BasicDBObject(op), opts));
            HashMap<String, Constable> ret = new HashMap<String, Constable>();
            if (w.isAcknowledged()) {
                ret.put("matched", Long.valueOf(res.getMatchedCount()));
                ret.put("modified", Long.valueOf(res.getModifiedCount()));
                ret.put("acc", Boolean.valueOf(res.wasAcknowledged()));
            }
            return ret;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public Map<String, Object> delete(String db, String collection, Map<String, Object> query, boolean multiple, WriteConcern wc) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(query);
        return DriverHelper.doCall(() -> {
            MongoDatabase database = this.mongo.getDatabase(db);
            MongoCollection coll = database.getCollection(collection);
            DeleteResult res = multiple ? (this.currentTransaction.get() == null ? coll.deleteMany((Bson)new BasicDBObject(query)) : coll.deleteMany(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query))) : (this.currentTransaction.get() == null ? coll.deleteOne((Bson)new BasicDBObject(query)) : coll.deleteOne(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query)));
            HashMap<String, Constable> r = new HashMap<String, Constable>();
            r.put("deleted", Long.valueOf(res.getDeletedCount()));
            r.put("acc", Boolean.valueOf(res.wasAcknowledged()));
            return r;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public void drop(String db, String collection, WriteConcern wc) throws MorphiumDriverException {
        DriverHelper.doCall(() -> {
            MongoDatabase database = this.mongo.getDatabase(db);
            MongoCollection coll = database.getCollection(collection);
            coll.drop();
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public void drop(String db, WriteConcern wc) throws MorphiumDriverException {
        DriverHelper.doCall(() -> {
            MongoDatabase database = this.mongo.getDatabase(db);
            if (wc != null) {
                com.mongodb.WriteConcern writeConcern = new com.mongodb.WriteConcern(wc.getW(), wc.getWtimeout(), wc.isFsync(), wc.isJ());
                database = database.withWriteConcern(writeConcern);
            }
            database.drop();
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public boolean exists(String db) {
        for (String dbName : this.mongo.getDatabaseNames()) {
            if (!dbName.equals(db)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Object> distinct(String db, String collection, String field, Map<String, Object> filter, ReadPreference rp) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(filter);
        ArrayList<Object> ret = new ArrayList<Object>();
        DriverHelper.doCall(() -> {
            DistinctIterable it = null;
            if (this.currentTransaction.get() == null) {
                List lst = this.getColl(this.mongo.getDB(db), collection, this.getDefaultReadPreference(), null).distinct(field, (DBObject)new BasicDBObject(filter));
                for (Object o : lst) {
                    ret.add(o);
                }
            } else {
                List<Map<String, Object>> r = this.find(db, collection, filter, null, (Map<String, Object>)new BasicDBObject(field, (Object)1), 0, 1, 1, this.defaultReadPreference, null);
                if (r == null || r.size() == 0) {
                    return null;
                }
                it = this.getCollection(this.mongo.getDatabase(db), collection, this.getDefaultReadPreference(), null).distinct(this.currentTransaction.get().getSession(), field, (Bson)new BasicDBObject(filter), r.get(0).get(field).getClass());
                for (Object d : it) {
                    ret.add(d);
                }
            }
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
        return ret;
    }

    @Override
    public boolean exists(String db, String collection) throws MorphiumDriverException {
        Map<String, Object> found = DriverHelper.doCall(() -> {
            HashMap ret = new HashMap();
            Document result = this.mongo.getDatabase(db).runCommand((Bson)new Document("listCollections", (Object)1));
            ArrayList batch = (ArrayList)((Map)result.get((Object)"cursor")).get("firstBatch");
            for (Document d : batch) {
                if (!d.get((Object)"name").equals(collection)) continue;
                return d;
            }
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
        return found != null && !found.isEmpty();
    }

    @Override
    public List<Map<String, Object>> getIndexes(String db, String collection) throws MorphiumDriverException {
        return (List)DriverHelper.doCall(() -> {
            ArrayList values = new ArrayList();
            for (Document d : this.mongo.getDatabase(db).getCollection(collection).listIndexes()) {
                values.add(new HashMap(d));
            }
            HashMap ret = new HashMap();
            ret.put("values", values);
            return ret;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries).get("values");
    }

    @Override
    public List<String> getCollectionNames(String db) throws MorphiumDriverException {
        ArrayList<String> ret = new ArrayList<String>();
        DriverHelper.doCall(() -> {
            if (this.currentTransaction.get() == null) {
                for (String c : this.mongo.getDatabase(db).listCollectionNames()) {
                    ret.add(c);
                }
            } else {
                for (String c : this.mongo.getDatabase(db).listCollectionNames(this.currentTransaction.get().getSession())) {
                    ret.add(c);
                }
            }
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
        return ret;
    }

    @Override
    public Map<String, Object> group(String db, String coll, Map<String, Object> query, Map<String, Object> initial, String jsReduce, String jsFinalize, ReadPreference rp, String ... keys) {
        DriverHelper.replaceMorphiumIdByObjectId(query);
        DriverHelper.replaceMorphiumIdByObjectId(initial);
        BasicDBObject k = new BasicDBObject();
        BasicDBObject ini = new BasicDBObject();
        ini.putAll(initial);
        for (String ks : keys) {
            if (ks.startsWith("-")) {
                k.put((Object)ks.substring(1), (Object)"false");
                continue;
            }
            if (ks.startsWith("+")) {
                k.put((Object)ks.substring(1), (Object)"true");
                continue;
            }
            k.put((Object)ks, (Object)"true");
        }
        if (!jsReduce.trim().startsWith("function(")) {
            jsReduce = "function (obj,data) { " + jsReduce + " }";
        }
        if (jsFinalize == null) {
            jsFinalize = "";
        }
        if (!jsFinalize.trim().startsWith("function(")) {
            jsFinalize = "function (data) {" + jsFinalize + "}";
        }
        DBCollection collection = this.mongo.getDB(db).getCollection(coll);
        GroupCommand cmd = new GroupCommand(collection, (DBObject)k, (DBObject)new BasicDBObject(query), (DBObject)ini, jsReduce, jsFinalize);
        return this.convertBSON((Map)cmd.toDBObject());
    }

    @Override
    public List<Map<String, Object>> aggregate(String db, String collection, List<Map<String, Object>> pipeline, boolean explain, boolean allowDiskUse, ReadPreference readPreference) {
        DriverHelper.replaceMorphiumIdByObjectId(pipeline);
        ArrayList list = new ArrayList(pipeline.stream().map(BasicDBObject::new).collect(Collectors.toList()));
        if (explain) {
            CommandResult ret = this.getColl(this.mongo.getDB(db), collection, this.getDefaultReadPreference(), null).explainAggregate(list, null);
            ArrayList<Map<String, Object>> o = new ArrayList<Map<String, Object>>();
            o.add(new HashMap(ret));
            return o;
        }
        MongoCollection<Document> c = this.getCollection(this.mongo.getDatabase(db), collection, this.getDefaultReadPreference(), null);
        AggregateIterable it = null;
        it = this.currentTransaction.get() == null ? c.aggregate(list, Document.class) : c.aggregate(this.currentTransaction.get().getSession(), list, Document.class);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Document doc : it) {
            result.add(this.convertBSON(new HashMap(doc)));
        }
        return result;
    }

    @Override
    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    @Override
    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    @Override
    public int getHeartbeatConnectTimeout() {
        return this.heartbeatConnectTimeout;
    }

    @Override
    public void setHeartbeatConnectTimeout(int heartbeatConnectTimeout) {
        this.heartbeatConnectTimeout = heartbeatConnectTimeout;
    }

    @Override
    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    @Override
    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    @Override
    public int getRetriesOnNetworkError() {
        return this.retriesOnNetworkError;
    }

    @Override
    public void setRetriesOnNetworkError(int retriesOnNetworkError) {
        this.retriesOnNetworkError = retriesOnNetworkError;
    }

    @Override
    public int getSleepBetweenErrorRetries() {
        return this.sleepBetweenErrorRetries;
    }

    @Override
    public void setSleepBetweenErrorRetries(int sleepBetweenErrorRetries) {
        this.sleepBetweenErrorRetries = sleepBetweenErrorRetries;
    }

    public Map<String, Object> getCollectionStats(String db, String coll, int scale, boolean verbose) throws MorphiumDriverException {
        Map<String, Object> cmd = new LinkedHashMap<String, Object>();
        cmd.put("collStats", coll);
        cmd.put("scale", scale);
        cmd.put("verbose", verbose);
        cmd = this.runCommand(db, cmd);
        return cmd;
    }

    @Override
    public boolean isCapped(String db, String coll) throws MorphiumDriverException {
        Object capped = this.getCollectionStats(db, coll, 1024, false).get("capped");
        if (capped instanceof String) {
            return capped.equals("true");
        }
        return capped.equals(Boolean.TRUE) || capped.equals(1) || capped.equals(true);
    }

    @Override
    public BulkRequestContext createBulkContext(Morphium m, String db, String collection, boolean ordered, WriteConcern wc) {
        return new MongodbBulkContext(m, db, collection, this, ordered, this.defaultBatchSize, wc);
    }

    public MongoDatabase getDb(String db) {
        return this.mongo.getDatabase(db);
    }

    public MongoCollection getCollection(String db, String coll) {
        return this.mongo.getDatabase(db).getCollection(coll);
    }

    @Override
    public void createIndex(String db, String collection, Map<String, Object> index, Map<String, Object> options) throws MorphiumDriverException {
        DriverHelper.doCall(() -> {
            BasicDBObject options1 = options == null ? new BasicDBObject() : new BasicDBObject(options);
            this.mongo.getDB(db).getCollection(collection).createIndex((DBObject)new BasicDBObject(index), (DBObject)options1);
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing) {
        return this.mapReduce(db, collection, mapping, reducing, null, null);
    }

    @Override
    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing, Map<String, Object> query) {
        return this.mapReduce(db, collection, mapping, reducing, query, null);
    }

    @Override
    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing, Map<String, Object> query, Map<String, Object> sorting) {
        MapReduceIterable res = null;
        res = this.currentTransaction.get() == null ? this.mongo.getDatabase(db).getCollection(collection).mapReduce(mapping, reducing) : this.mongo.getDatabase(db).getCollection(collection).mapReduce(this.currentTransaction.get().getSession(), mapping, reducing);
        if (query != null) {
            BasicDBObject v = new BasicDBObject(query);
            res.filter((Bson)v);
        }
        if (sorting != null) {
            res.sort((Bson)new BasicDBObject(sorting));
        }
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        for (Document d : res) {
            Map value = (Map)d.get((Object)"value");
            for (Map.Entry s : value.entrySet()) {
                if (!(s.getValue() instanceof ObjectId)) continue;
                value.put(s.getKey(), new MorphiumId(((ObjectId)s.getValue()).toHexString()));
            }
            ret.add(value);
        }
        return ret;
    }

    @Override
    public void startTransaction() {
        if (this.currentTransaction.get() != null) {
            throw new IllegalArgumentException("Transaction in progress");
        }
        ClientSessionOptions.Builder b = ClientSessionOptions.builder();
        b.causallyConsistent(true);
        b.defaultTransactionOptions(TransactionOptions.builder().readConcern(ReadConcern.DEFAULT).readPreference(com.mongodb.ReadPreference.primary()).build());
        ClientSession ses = this.mongo.startSession(b.build());
        ses.startTransaction();
        MongoTransactionContext ctx = new MongoTransactionContext();
        ctx.setSession(ses);
        this.currentTransaction.set(ctx);
    }

    @Override
    public void commitTransaction() {
        if (this.currentTransaction.get() == null) {
            throw new IllegalArgumentException("No transaction in progress");
        }
        this.currentTransaction.get().getSession().abortTransaction();
        this.currentTransaction.set(null);
    }

    @Override
    public MorphiumTransactionContext getTransactionContext() {
        return this.currentTransaction.get();
    }

    @Override
    public void abortTransaction() {
        if (this.currentTransaction.get() == null) {
            throw new IllegalArgumentException("No transaction in progress");
        }
        this.currentTransaction.get().getSession().abortTransaction();
        this.currentTransaction.set(null);
    }

    @Override
    public void setTransactionContext(MorphiumTransactionContext ctx) {
        if (this.currentTransaction.get() != null) {
            throw new IllegalArgumentException("Transaction in progress!");
        }
        this.currentTransaction.set((MongoTransactionContext)ctx);
    }
}

