/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.StatisticValue;
import de.caluga.morphium.cache.CacheElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Statistics
extends HashMap<String, Double> {
    private static final long serialVersionUID = -2368547656520608318L;
    private final transient Morphium morphium;

    public Statistics(Morphium morphium) {
        this.morphium = morphium;
        for (Map.Entry<StatisticKeys, StatisticValue> et : morphium.getStats().entrySet()) {
            super.put(et.getKey().name(), Double.valueOf(et.getValue().get()));
        }
        double entries = 0.0;
        Map<Class<?>, Map<String, CacheElement>> cc = morphium.getCache().getCache();
        for (Map.Entry<Class<?>, Map<String, CacheElement>> en : cc.entrySet()) {
            Map<String, CacheElement> lst = en.getValue();
            entries += (double)lst.size();
            super.put("X-Entries for: " + en.getKey().getName(), Double.valueOf(lst.size()));
        }
        super.put(StatisticKeys.CACHE_ENTRIES.name(), entries);
        super.put(StatisticKeys.WRITE_BUFFER_ENTRIES.name(), Double.valueOf(morphium.getWriteBufferCount()));
        super.put(StatisticKeys.CHITSPERC.name(), (double)morphium.getStats().get((Object)StatisticKeys.CHITS).get() / (double)(morphium.getStats().get((Object)StatisticKeys.CHITS).get() + morphium.getStats().get((Object)StatisticKeys.CMISS).get()) * 100.0);
        super.put(StatisticKeys.CMISSPERC.name(), (double)morphium.getStats().get((Object)StatisticKeys.CMISS).get() / (double)(morphium.getStats().get((Object)StatisticKeys.CHITS).get() + morphium.getStats().get((Object)StatisticKeys.CMISS).get()) * 100.0);
    }

    public Double get(Enum key) {
        return (Double)this.get(key.name());
    }

    @Override
    public Double put(String arg0, Double arg1) {
        throw new RuntimeException("not allowed!");
    }

    @Override
    public void putAll(Map arg0) {
        throw new RuntimeException("not allowed");
    }

    @Override
    public Double remove(Object arg0) {
        throw new RuntimeException("not allowed");
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        StatisticKeys[] lst = this.morphium.getStats().keySet().toArray(new StatisticKeys[0]);
        Arrays.sort((Object[])lst);
        for (StatisticKeys k : lst) {
            b.append("- ");
            b.append(k.toString());
            b.append("\t");
            b.append(this.morphium.getStats().get((Object)k));
            b.append("\n");
        }
        return b.toString();
    }
}

