/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Logger;
import de.caluga.morphium.LoggerRegistry;
import de.caluga.morphium.ObjectMapper;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.Utils;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.AggregatorFactory;
import de.caluga.morphium.aggregation.AggregatorFactoryImpl;
import de.caluga.morphium.aggregation.AggregatorImpl;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.cache.MorphiumCache;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.ReadPreferenceType;
import de.caluga.morphium.driver.mongodb.Driver;
import de.caluga.morphium.query.MongoField;
import de.caluga.morphium.query.MongoFieldImpl;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.query.QueryFactory;
import de.caluga.morphium.query.QueryFactoryImpl;
import de.caluga.morphium.query.QueryImpl;
import de.caluga.morphium.writer.AsyncWriterImpl;
import de.caluga.morphium.writer.BufferedMorphiumWriterImpl;
import de.caluga.morphium.writer.MorphiumWriter;
import de.caluga.morphium.writer.MorphiumWriterImpl;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.json.simple.parser.ParseException;

@Embedded
public class MorphiumConfig {
    @AdditionalData(readOnly=false)
    private Map<String, String> restoreData;
    private int maxConnections;
    private int housekeepingTimeout;
    private int globalCacheValidTime = 5000;
    private int writeCacheTimeout = 5000;
    private String database;
    @Transient
    private MorphiumWriter writer;
    @Transient
    private MorphiumWriter bufferedWriter;
    @Transient
    private MorphiumWriter asyncWriter;
    private int connectionTimeout = 0;
    private int socketTimeout = 0;
    private boolean socketKeepAlive = true;
    private boolean safeMode = false;
    private boolean globalFsync = false;
    private boolean globalJ = false;
    private boolean checkForNew = false;
    private int writeTimeout = 0;
    private boolean replicaset = true;
    private int globalLogLevel = 0;
    private boolean globalLogSynced = false;
    private String globalLogFile = null;
    private int maximumRetriesBufferedWriter = 10;
    private int maximumRetriesWriter = 10;
    private int maximumRetriesAsyncWriter = 10;
    private int retryWaitTimeBufferedWriter = 200;
    private int retryWaitTimeWriter = 200;
    private int retryWaitTimeAsyncWriter = 200;
    private int globalW = 1;
    private int maxWaitTime = 120000;
    private int writeBufferTime = 1000;
    private int writeBufferTimeGranularity = 100;
    private boolean autoreconnect = true;
    private int maxAutoReconnectTime = 0;
    private int blockingThreadsMultiplier = 5;
    private boolean autoIndexAndCappedCreationOnWrite = true;
    @Transient
    private Class<? extends Query> queryClass;
    @Transient
    private Class<? extends Aggregator> aggregatorClass;
    @Transient
    private QueryFactory queryFact;
    @Transient
    private AggregatorFactory aggregatorFactory;
    @Transient
    private MorphiumCache cache;
    private int replicaSetMonitoringTimeout = 5000;
    private int retriesOnNetworkError = 1;
    private int sleepBetweenNetworkErrorRetries = 1000;
    private String mongoLogin = null;
    private String mongoPassword = null;
    private boolean autoValues = true;
    private boolean readCacheEnabled = true;
    private boolean asyncWritesEnabled = true;
    private boolean bufferedWritesEnabled = true;
    private boolean camelCaseConversionEnabled = true;
    private String mongoAdminUser;
    private String mongoAdminPwd;
    @Transient
    private Class<? extends ObjectMapper> omClass = ObjectMapperImpl.class;
    @Transient
    private Class<? extends MongoField> fieldImplClass = MongoFieldImpl.class;
    @Transient
    private ReadPreference defaultReadPreference;
    @Transient
    private String defaultReadPreferenceType;
    private String driverClass;
    private int acceptableLatencyDifference = 15;
    private int threadPoolMessagingCoreSize = 0;
    private int threadPoolMessagingMaxSize = 100;
    private long threadPoolMessagingKeepAliveTime = 2000L;
    private int threadPoolAsyncOpCoreSize = 1;
    private int threadPoolAsyncOpMaxSize = 1000;
    private long threadPoolAsyncOpKeepAliveTime = 1000L;
    private boolean objectSerializationEnabled = true;
    private boolean cursorFinalizerEnabled = false;
    private boolean alwaysUseMBeans = false;
    private int heartbeatConnectTimeout = 0;
    private int heartbeatFrequency = 1000;
    private int heartbeatSocketTimeout = 1000;
    private int minConnectionsPerHost = 1;
    private int minHearbeatFrequency = 2000;
    private int localThreashold = 0;
    private int maxConnectionIdleTime = 10000;
    private int maxConnectionLifeTime = 60000;
    private List<String> hostSeed = new ArrayList<String>();
    private String defaultTags;
    private String requiredReplicaSetName = null;
    private int cursorBatchSize = 1000;
    private boolean oplogMonitorEnabled = false;

    public MorphiumConfig(Properties prop) {
        this(null, prop);
    }

    public MorphiumConfig(String prefix, Properties prop) {
        Object lst;
        AnnotationAndReflectionHelper an = new AnnotationAndReflectionHelper(true);
        List<Field> flds = an.getAllFields(MorphiumConfig.class);
        prefix = prefix != null ? prefix + "." : "";
        for (Field field : flds) {
            if (field.isAnnotationPresent(Transient.class)) continue;
            field.setAccessible(true);
            String fName = prefix + field.getName();
            if (prop.getProperty(fName) == null) continue;
            try {
                if (field.getType().equals(Integer.TYPE) || field.getType().equals(Integer.class)) {
                    field.set(this, Integer.parseInt((String)prop.get(fName)));
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    field.set(this, prop.get(fName));
                    continue;
                }
                if (List.class.isAssignableFrom(field.getType())) {
                    String lst2 = (String)prop.get(fName);
                    ArrayList l = new ArrayList();
                    lst2 = lst2.replaceAll("[\\[\\]]", "");
                    Collections.addAll(l, lst2.split(","));
                    field.set(this, l);
                    continue;
                }
                if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                    field.set(this, prop.get(fName).equals("true"));
                    continue;
                }
                if (!field.getType().equals(Long.TYPE) && !field.getType().equals(Long.class)) continue;
                field.set(this, Long.parseLong((String)prop.get(fName)));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if ((this.hostSeed == null || this.hostSeed.isEmpty()) && (lst = (String)prop.get(prefix + "hosts")) != null) {
            lst = ((String)lst).replaceAll("[\\[\\]]", "");
            for (String s : ((String)lst).split(",")) {
                this.addHostToSeed(s);
            }
        }
        if (this.globalLogFile == null) {
            this.globalLogFile = "-";
        }
        if (prop.containsKey(prefix + "log.level")) {
            this.setGlobalLogLevel(Integer.valueOf((String)prop.get(prefix + "log.level")));
        }
        if (prop.containsKey(prefix + "log.file")) {
            this.setGlobalLogFile((String)prop.get(prefix + "log.file"));
        }
        if (prop.containsKey(prefix + "log.synced")) {
            this.setGlobalLogSynced(prop.get(prefix + "log.synced").equals("true"));
        }
        this.setGlobalLogLevel(this.globalLogLevel);
        this.setGlobalLogSynced(this.globalLogSynced);
        this.setGlobalLogFile(this.globalLogFile);
        for (Object e : prop.keySet()) {
            String key = (String)e;
            if (!key.startsWith(prefix + "log.")) continue;
            System.setProperty("morphium." + key.substring(prefix.length()), prop.get(e).toString());
        }
        try {
            MorphiumConfig.parseClassSettings(this, prop);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | UnknownHostException e) {
            throw new RuntimeException(e);
        }
        LoggerRegistry.get().updateSettings();
    }

    public MorphiumConfig() {
        this("test", 10, 60000, 10000);
    }

    public MorphiumConfig(String db, int maxConnections, int globalCacheValidTime, int housekeepingTimeout) {
        this.database = db;
        this.maxConnections = maxConnections;
        this.globalCacheValidTime = globalCacheValidTime;
        this.housekeepingTimeout = housekeepingTimeout;
    }

    public static MorphiumConfig createFromJson(String json) throws ParseException, NoSuchFieldException, ClassNotFoundException, IllegalAccessException, InstantiationException, UnknownHostException, NoSuchMethodException, InvocationTargetException {
        MorphiumConfig cfg = new ObjectMapperImpl().unmarshall(MorphiumConfig.class, json);
        MorphiumConfig.parseClassSettings(cfg, cfg.restoreData);
        Iterator<String> iterator = cfg.restoreData.keySet().iterator();
        while (iterator.hasNext()) {
            String ko;
            String k = ko = iterator.next();
            String value = cfg.restoreData.get(k);
            if (!k.equals("hosts") && !k.equals("hostSeed")) continue;
            value = value.replaceAll("\\[", "").replaceAll("]", "");
            for (String adr : value.split(",")) {
                String[] a = adr.split(":");
                cfg.addHostToSeed(a[0].trim(), Integer.parseInt(a[1].trim()));
            }
        }
        return cfg;
    }

    private static void parseClassSettings(MorphiumConfig cfg, Map settings) throws UnknownHostException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException, InstantiationException {
        for (Object ko : settings.keySet()) {
            String[] n;
            String k = (String)ko;
            String value = (String)settings.get(k);
            if (!k.endsWith("ClassName")) continue;
            if (k.contains(".")) {
                k = k.substring(0, k.indexOf(".") + 1);
            }
            if ((n = k.split("_")).length != 3) continue;
            Class<?> cls = Class.forName(value);
            Field f = MorphiumConfig.class.getDeclaredField(n[0]);
            f.setAccessible(true);
            if (n[1].equals("C")) {
                f.set(cfg, cls);
                continue;
            }
            if (!n[1].equals("I")) continue;
            f.set(cfg, cls.newInstance());
        }
        cfg.getAggregatorFactory().setAggregatorClass(cfg.getAggregatorClass());
        cfg.getQueryFact().setQueryImpl(cfg.getQueryClass());
    }

    public static MorphiumConfig fromProperties(String prefix, Properties p) throws ClassNotFoundException, NoSuchFieldException, InstantiationException, IllegalAccessException, UnknownHostException {
        return new MorphiumConfig(prefix, p);
    }

    public static MorphiumConfig fromProperties(Properties p) throws ClassNotFoundException, NoSuchFieldException, InstantiationException, IllegalAccessException, UnknownHostException {
        return new MorphiumConfig(p);
    }

    public boolean isReplicaset() {
        return this.replicaset;
    }

    public void setReplicasetMonitoring(boolean replicaset) {
        this.replicaset = replicaset;
    }

    public String getDriverClass() {
        if (this.driverClass == null) {
            this.driverClass = Driver.class.getName();
        }
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public boolean isAutoIndexAndCappedCreationOnWrite() {
        return this.autoIndexAndCappedCreationOnWrite;
    }

    public void setAutoIndexAndCappedCreationOnWrite(boolean autoIndexAndCappedCreationOnWrite) {
        this.autoIndexAndCappedCreationOnWrite = autoIndexAndCappedCreationOnWrite;
    }

    public boolean isCheckForNew() {
        return this.checkForNew;
    }

    public void setCheckForNew(boolean checkForNew) {
        this.checkForNew = checkForNew;
    }

    public int getRetriesOnNetworkError() {
        return this.retriesOnNetworkError;
    }

    public void setRetriesOnNetworkError(int retriesOnNetworkError) {
        if (retriesOnNetworkError == 0) {
            new Logger(MorphiumConfig.class).warn("Cannot set retries on network error to 0 - minimum is 1");
            retriesOnNetworkError = 1;
        }
        this.retriesOnNetworkError = retriesOnNetworkError;
    }

    public int getSleepBetweenNetworkErrorRetries() {
        return this.sleepBetweenNetworkErrorRetries;
    }

    public void setSleepBetweenNetworkErrorRetries(int sleepBetweenNetworkErrorRetries) {
        this.sleepBetweenNetworkErrorRetries = sleepBetweenNetworkErrorRetries;
    }

    public int getReplicaSetMonitoringTimeout() {
        return this.replicaSetMonitoringTimeout;
    }

    public void setReplicaSetMonitoringTimeout(int replicaSetMonitoringTimeout) {
        this.replicaSetMonitoringTimeout = replicaSetMonitoringTimeout;
    }

    public int getWriteBufferTimeGranularity() {
        return this.writeBufferTimeGranularity;
    }

    public void setWriteBufferTimeGranularity(int writeBufferTimeGranularity) {
        this.writeBufferTimeGranularity = writeBufferTimeGranularity;
    }

    public MorphiumCache getCache() {
        return this.cache;
    }

    public void setCache(MorphiumCache cache) {
        this.cache = cache;
    }

    public boolean isOplogMonitorEnabled() {
        return this.oplogMonitorEnabled;
    }

    public void setOplogMonitorEnabled(boolean op) {
        this.oplogMonitorEnabled = op;
    }

    public int getWriteBufferTime() {
        return this.writeBufferTime;
    }

    public void setWriteBufferTime(int writeBufferTime) {
        this.writeBufferTime = writeBufferTime;
    }

    public Class<? extends ObjectMapper> getOmClass() {
        return this.omClass;
    }

    public void setOmClass(Class<? extends ObjectMapper> omClass) {
        this.omClass = omClass;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public int getGlobalW() {
        return this.globalW;
    }

    public void setGlobalW(int globalW) {
        this.globalW = globalW;
    }

    public boolean isGlobalJ() {
        return this.globalJ;
    }

    public void setGlobalJ(boolean globalJ) {
        this.globalJ = globalJ;
    }

    public Class<? extends Query> getQueryClass() {
        if (this.queryClass == null) {
            this.queryClass = QueryImpl.class;
        }
        return this.queryClass;
    }

    public void setQueryClass(Class<Query> queryClass) {
        this.queryClass = queryClass;
    }

    public QueryFactory getQueryFact() {
        if (this.queryFact == null) {
            this.queryFact = new QueryFactoryImpl(this.getQueryClass());
        }
        return this.queryFact;
    }

    public void setQueryFact(QueryFactory queryFact) {
        this.queryFact = queryFact;
    }

    public AggregatorFactory getAggregatorFactory() {
        if (this.aggregatorFactory == null) {
            this.aggregatorFactory = new AggregatorFactoryImpl(this.getAggregatorClass());
        }
        return this.aggregatorFactory;
    }

    public void setAggregatorFactory(AggregatorFactory aggregatorFactory) {
        this.aggregatorFactory = aggregatorFactory;
    }

    public Class<? extends Aggregator> getAggregatorClass() {
        if (this.aggregatorClass == null) {
            this.aggregatorClass = AggregatorImpl.class;
        }
        return this.aggregatorClass;
    }

    public void setAggregatorClass(Class<? extends Aggregator> aggregatorClass) {
        this.aggregatorClass = aggregatorClass;
    }

    public boolean isGlobalFsync() {
        return this.globalFsync;
    }

    public void setGlobalFsync(boolean globalFsync) {
        this.globalFsync = globalFsync;
    }

    public boolean isSafeMode() {
        return this.safeMode;
    }

    public void setSafeMode(boolean safeMode) {
        this.safeMode = safeMode;
    }

    public int getBlockingThreadsMultiplier() {
        return this.blockingThreadsMultiplier;
    }

    public void setBlockingThreadsMultiplier(int blockingThreadsMultiplier) {
        this.blockingThreadsMultiplier = blockingThreadsMultiplier;
    }

    public MorphiumWriter getBufferedWriter() {
        if (this.bufferedWriter == null) {
            this.bufferedWriter = new BufferedMorphiumWriterImpl();
        }
        return this.bufferedWriter;
    }

    public void setBufferedWriter(MorphiumWriter bufferedWriter) {
        this.bufferedWriter = bufferedWriter;
    }

    public MorphiumWriter getWriter() {
        if (this.writer == null) {
            this.writer = new MorphiumWriterImpl();
        }
        return this.writer;
    }

    public void setWriter(MorphiumWriter writer) {
        this.writer = writer;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public Class<? extends MongoField> getFieldImplClass() {
        return this.fieldImplClass;
    }

    public void setFieldImplClass(Class<? extends MongoField> fieldImplClass) {
        this.fieldImplClass = fieldImplClass;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public boolean isAutoreconnect() {
        return this.autoreconnect;
    }

    public void setAutoreconnect(boolean autoreconnect) {
        this.autoreconnect = autoreconnect;
    }

    public int getMaxAutoReconnectTime() {
        return this.maxAutoReconnectTime;
    }

    public void setMaxAutoReconnectTime(int maxAutoReconnectTime) {
        this.maxAutoReconnectTime = maxAutoReconnectTime;
    }

    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    public String getMongoLogin() {
        return this.mongoLogin;
    }

    public void setMongoLogin(String mongoLogin) {
        this.mongoLogin = mongoLogin;
    }

    public String getMongoPassword() {
        return this.mongoPassword;
    }

    public void setMongoPassword(String mongoPassword) {
        this.mongoPassword = mongoPassword;
    }

    public ReadPreference getDefaultReadPreference() {
        return this.defaultReadPreference;
    }

    public void setDefaultReadPreference(ReadPreference defaultReadPreference) {
        this.defaultReadPreference = defaultReadPreference;
    }

    public String getDefaultReadPreferenceType() {
        return this.defaultReadPreferenceType;
    }

    public void setDefaultReadPreferenceType(String stringDefaultReadPreference) {
        ReadPreferenceType readPreferenceType;
        this.defaultReadPreferenceType = stringDefaultReadPreference;
        try {
            readPreferenceType = ReadPreferenceType.valueOf(stringDefaultReadPreference.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            readPreferenceType = null;
        }
        if (readPreferenceType == null) {
            throw new RuntimeException("Could not set defaultReadPreferenceByString " + stringDefaultReadPreference);
        }
        ReadPreference defaultReadPreference = new ReadPreference();
        defaultReadPreference.setType(readPreferenceType);
        this.defaultReadPreference = defaultReadPreference;
    }

    public String getMongoAdminUser() {
        return this.mongoAdminUser;
    }

    public void setMongoAdminUser(String mongoAdminUser) {
        this.mongoAdminUser = mongoAdminUser;
    }

    public String getMongoAdminPwd() {
        return this.mongoAdminPwd;
    }

    public void setMongoAdminPwd(String mongoAdminPwd) {
        this.mongoAdminPwd = mongoAdminPwd;
    }

    public int getWriteCacheTimeout() {
        return this.writeCacheTimeout;
    }

    public void setWriteCacheTimeout(int writeCacheTimeout) {
        this.writeCacheTimeout = writeCacheTimeout;
    }

    public void setHostSeed(List<String> str) {
        this.hostSeed = str;
    }

    public void setHostSeed(List<String> str, List<Integer> ports) {
        this.hostSeed.clear();
        for (int i = 0; i < str.size(); ++i) {
            String host = str.get(i).replaceAll(" ", "") + ":" + ports.get(i);
            this.hostSeed.add(host);
        }
    }

    public List<String> getHostSeed() {
        return this.hostSeed;
    }

    public void setHostSeed(String hostPorts) {
        String[] h;
        this.hostSeed.clear();
        for (String host : h = hostPorts.split(",")) {
            this.addHostToSeed(host);
        }
    }

    public void setHostSeed(String hosts, String ports) {
        this.hostSeed.clear();
        hosts = hosts.replaceAll(" ", "");
        ports = ports.replaceAll(" ", "");
        String[] h = hosts.split(",");
        String[] p = ports.split(",");
        for (int i = 0; i < h.length; ++i) {
            if (p.length < i) {
                this.addHostToSeed(h[i], 27017);
                continue;
            }
            this.addHostToSeed(h[i], Integer.parseInt(p[i]));
        }
    }

    public void addHostToSeed(String host, int port) {
        host = host.replaceAll(" ", "") + ":" + port;
        this.hostSeed.add(host);
    }

    public void addHostToSeed(String host) {
        if ((host = host.replaceAll(" ", "")).contains(":")) {
            String[] h = host.split(":");
            this.addHostToSeed(h[0], Integer.parseInt(h[1]));
        } else {
            this.addHostToSeed(host, 27017);
        }
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getGlobalCacheValidTime() {
        return this.globalCacheValidTime;
    }

    public void setGlobalCacheValidTime(int globalCacheValidTime) {
        this.globalCacheValidTime = globalCacheValidTime;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public int getHousekeepingTimeout() {
        return this.housekeepingTimeout;
    }

    public void setHousekeepingTimeout(int housekeepingTimeout) {
        this.housekeepingTimeout = housekeepingTimeout;
    }

    public long getValidTime() {
        return this.globalCacheValidTime;
    }

    public void setValidTime(int tm) {
        this.globalCacheValidTime = tm;
    }

    public String toString() {
        this.updateAdditionals();
        try {
            return Utils.toJsonString(this.getOmClass().newInstance().marshall(this));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void updateAdditionals() {
        this.restoreData = new HashMap<String, String>();
        this.addClassSettingsTo("", this.restoreData);
    }

    private void addClassSettingsTo(String prefix, Map p) {
        MorphiumConfig defaults = new MorphiumConfig();
        this.getWriter();
        this.getBufferedWriter();
        this.getAsyncWriter();
        if (!defaults.getWriter().getClass().equals(this.getWriter().getClass())) {
            p.put(prefix + "writer_I_ClassName", this.getWriter().getClass().getName());
        }
        if (!defaults.getBufferedWriter().getClass().equals(this.getBufferedWriter().getClass())) {
            p.put(prefix + "bufferedWriter_I_ClassName", this.getBufferedWriter().getClass().getName());
        }
        if (!defaults.getAsyncWriter().getClass().equals(this.getAsyncWriter().getClass())) {
            p.put(prefix + "asyncWriter_I_ClassName", this.getAsyncWriter().getClass().getName());
        }
        if (this.getCache() != null) {
            p.put(prefix + "cache_I_ClassName", this.getCache().getClass().getName());
        }
        if (!defaults.getAggregatorClass().equals(this.getAggregatorClass())) {
            p.put(prefix + "aggregatorClass_C_ClassName", this.getAggregatorClass().getName());
        }
        if (!defaults.getAggregatorFactory().getClass().equals(this.getAggregatorFactory().getClass())) {
            p.put(prefix + "aggregatorFactory_I_ClassName", this.getAggregatorFactory().getClass().getName());
        }
        if (!defaults.getOmClass().equals(this.getOmClass())) {
            p.put(prefix + "omClass_C_ClassName", this.getOmClass().getName());
        }
        if (!defaults.getQueryClass().equals(this.getQueryClass())) {
            p.put(prefix + "queryClass_C_ClassName", this.getQueryClass().getName());
        }
        if (!defaults.getQueryFact().getClass().equals(this.getQueryFact().getClass())) {
            p.put(prefix + "queryFact_I_ClassName", this.getQueryFact().getClass().getName());
        }
    }

    public MorphiumWriter getAsyncWriter() {
        if (this.asyncWriter == null) {
            this.asyncWriter = new AsyncWriterImpl();
        }
        return this.asyncWriter;
    }

    public void setAsyncWriter(MorphiumWriter asyncWriter) {
        this.asyncWriter = asyncWriter;
    }

    public int getMaximumRetriesBufferedWriter() {
        return this.maximumRetriesBufferedWriter;
    }

    public void setMaximumRetriesBufferedWriter(int maximumRetriesBufferedWriter) {
        this.maximumRetriesBufferedWriter = maximumRetriesBufferedWriter;
    }

    public int getMaximumRetriesWriter() {
        return this.maximumRetriesWriter;
    }

    public void setMaximumRetriesWriter(int maximumRetriesWriter) {
        this.maximumRetriesWriter = maximumRetriesWriter;
    }

    public int getMaximumRetriesAsyncWriter() {
        return this.maximumRetriesAsyncWriter;
    }

    public void setMaximumRetriesAsyncWriter(int maximumRetriesAsyncWriter) {
        this.maximumRetriesAsyncWriter = maximumRetriesAsyncWriter;
    }

    public int getRetryWaitTimeBufferedWriter() {
        return this.retryWaitTimeBufferedWriter;
    }

    public void setRetryWaitTimeBufferedWriter(int retryWaitTimeBufferedWriter) {
        this.retryWaitTimeBufferedWriter = retryWaitTimeBufferedWriter;
    }

    public int getRetryWaitTimeWriter() {
        return this.retryWaitTimeWriter;
    }

    public void setRetryWaitTimeWriter(int retryWaitTimeWriter) {
        this.retryWaitTimeWriter = retryWaitTimeWriter;
    }

    public int getRetryWaitTimeAsyncWriter() {
        return this.retryWaitTimeAsyncWriter;
    }

    public void setRetryWaitTimeAsyncWriter(int retryWaitTimeAsyncWriter) {
        this.retryWaitTimeAsyncWriter = retryWaitTimeAsyncWriter;
    }

    public Properties asProperties() {
        return this.asProperties(null);
    }

    public Properties asProperties(String prefix) {
        return this.asProperties(prefix, true);
    }

    public Properties asProperties(String prefix, boolean effectiveConfig) {
        prefix = prefix == null ? "" : prefix + ".";
        MorphiumConfig defaults = new MorphiumConfig();
        Properties p = new Properties();
        AnnotationAndReflectionHelper an = new AnnotationAndReflectionHelper(true);
        List<Field> flds = an.getAllFields(MorphiumConfig.class);
        for (Field f : flds) {
            if (f.isAnnotationPresent(Transient.class)) continue;
            f.setAccessible(true);
            try {
                if (f.get(this) == null || f.get(this).equals(f.get(defaults))) continue;
                p.put(prefix + f.getName(), f.get(this).toString());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        this.addClassSettingsTo(prefix, p);
        if (effectiveConfig) {
            Properties sysprop = System.getProperties();
            for (Object sysk : sysprop.keySet()) {
                String k = (String)sysk;
                if (!k.startsWith("morphium.")) continue;
                String value = sysprop.get(k).toString();
                k = k.substring(9);
                p.put(prefix + k, value);
            }
        }
        return p;
    }

    public boolean isReadCacheEnabled() {
        return this.readCacheEnabled;
    }

    public void setReadCacheEnabled(boolean readCacheEnabled) {
        this.readCacheEnabled = readCacheEnabled;
    }

    public void disableReadCache() {
        this.readCacheEnabled = false;
    }

    public void enableReadCache() {
        this.readCacheEnabled = true;
    }

    public boolean isAsyncWritesEnabled() {
        return this.asyncWritesEnabled;
    }

    public void setAsyncWritesEnabled(boolean asyncWritesEnabled) {
        this.asyncWritesEnabled = asyncWritesEnabled;
    }

    public void disableAsyncWrites() {
        this.asyncWritesEnabled = false;
    }

    public void enableAsyncWrites() {
        this.asyncWritesEnabled = true;
    }

    public boolean isBufferedWritesEnabled() {
        return this.bufferedWritesEnabled;
    }

    public void setBufferedWritesEnabled(boolean bufferedWritesEnabled) {
        this.bufferedWritesEnabled = bufferedWritesEnabled;
    }

    public void disableBufferedWrites() {
        this.bufferedWritesEnabled = false;
    }

    public void enableBufferedWrites() {
        this.bufferedWritesEnabled = true;
    }

    public boolean isAutoValuesEnabled() {
        return this.autoValues;
    }

    public void setAutoValuesEnabled(boolean enabled) {
        this.autoValues = enabled;
    }

    public void enableAutoValues() {
        this.autoValues = true;
    }

    public void disableAutoValues() {
        this.autoValues = false;
    }

    public int getAcceptableLatencyDifference() {
        return this.acceptableLatencyDifference;
    }

    public void setAcceptableLatencyDifference(int acceptableLatencyDifference) {
        this.acceptableLatencyDifference = acceptableLatencyDifference;
    }

    public boolean isCamelCaseConversionEnabled() {
        return this.camelCaseConversionEnabled;
    }

    public void setCamelCaseConversionEnabled(boolean camelCaseConversionEnabled) {
        this.camelCaseConversionEnabled = camelCaseConversionEnabled;
    }

    public int getThreadPoolMessagingCoreSize() {
        return this.threadPoolMessagingCoreSize;
    }

    public void setThreadPoolMessagingCoreSize(int threadPoolMessagingCoreSize) {
        this.threadPoolMessagingCoreSize = threadPoolMessagingCoreSize;
    }

    public int getThreadPoolMessagingMaxSize() {
        return this.threadPoolMessagingMaxSize;
    }

    public void setThreadPoolMessagingMaxSize(int threadPoolMessagingMaxSize) {
        this.threadPoolMessagingMaxSize = threadPoolMessagingMaxSize;
    }

    public long getThreadPoolMessagingKeepAliveTime() {
        return this.threadPoolMessagingKeepAliveTime;
    }

    public void setThreadPoolMessagingKeepAliveTime(long threadPoolMessagingKeepAliveTime) {
        this.threadPoolMessagingKeepAliveTime = threadPoolMessagingKeepAliveTime;
    }

    public int getThreadPoolAsyncOpCoreSize() {
        return this.threadPoolAsyncOpCoreSize;
    }

    public void setThreadPoolAsyncOpCoreSize(int threadPoolAsyncOpCoreSize) {
        this.threadPoolAsyncOpCoreSize = threadPoolAsyncOpCoreSize;
    }

    public int getThreadPoolAsyncOpMaxSize() {
        return this.threadPoolAsyncOpMaxSize;
    }

    public void setThreadPoolAsyncOpMaxSize(int threadPoolAsyncOpMaxSize) {
        this.threadPoolAsyncOpMaxSize = threadPoolAsyncOpMaxSize;
    }

    public long getThreadPoolAsyncOpKeepAliveTime() {
        return this.threadPoolAsyncOpKeepAliveTime;
    }

    public void setThreadPoolAsyncOpKeepAliveTime(long threadPoolAsyncOpKeepAliveTime) {
        this.threadPoolAsyncOpKeepAliveTime = threadPoolAsyncOpKeepAliveTime;
    }

    public boolean isObjectSerializationEnabled() {
        return this.objectSerializationEnabled;
    }

    public void setObjectSerializationEnabled(boolean objectSerializationEnabled) {
        this.objectSerializationEnabled = objectSerializationEnabled;
    }

    public boolean isCursorFinalizerEnabled() {
        return this.cursorFinalizerEnabled;
    }

    public void setCursorFinalizerEnabled(boolean cursorFinalizerEnabled) {
        this.cursorFinalizerEnabled = cursorFinalizerEnabled;
    }

    public boolean isAlwaysUseMBeans() {
        return this.alwaysUseMBeans;
    }

    public void setAlwaysUseMBeans(boolean alwaysUseMBeans) {
        this.alwaysUseMBeans = alwaysUseMBeans;
    }

    public int getHeartbeatConnectTimeout() {
        return this.heartbeatConnectTimeout;
    }

    public void setHeartbeatConnectTimeout(int heartbeatConnectTimeout) {
        this.heartbeatConnectTimeout = heartbeatConnectTimeout;
    }

    public int getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    public void setHeartbeatFrequency(int heartbeatFrequency) {
        this.heartbeatFrequency = heartbeatFrequency;
    }

    public int getHeartbeatSocketTimeout() {
        return this.heartbeatSocketTimeout;
    }

    public void setHeartbeatSocketTimeout(int heartbeatSocketTimeout) {
        this.heartbeatSocketTimeout = heartbeatSocketTimeout;
    }

    public int getMinConnectionsPerHost() {
        return this.minConnectionsPerHost;
    }

    public void setMinConnectionsPerHost(int minConnectionsPerHost) {
        this.minConnectionsPerHost = minConnectionsPerHost;
    }

    public int getMinHearbeatFrequency() {
        return this.minHearbeatFrequency;
    }

    public void setMinHearbeatFrequency(int minHearbeatFrequency) {
        this.minHearbeatFrequency = minHearbeatFrequency;
    }

    public int getLocalThreashold() {
        return this.localThreashold;
    }

    public void setLocalThreashold(int localThreashold) {
        this.localThreashold = localThreashold;
    }

    public int getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    public void setMaxConnectionIdleTime(int maxConnectionIdleTime) {
        this.maxConnectionIdleTime = maxConnectionIdleTime;
    }

    public int getMaxConnectionLifeTime() {
        return this.maxConnectionLifeTime;
    }

    public void setMaxConnectionLifeTime(int maxConnectionLifeTime) {
        this.maxConnectionLifeTime = maxConnectionLifeTime;
    }

    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    public void setRequiredReplicaSetName(String requiredReplicaSetName) {
        this.requiredReplicaSetName = requiredReplicaSetName;
    }

    public int getGlobalLogLevel() {
        return this.globalLogLevel;
    }

    public void setGlobalLogLevel(int globalLogLevel) {
        this.globalLogLevel = globalLogLevel;
        System.setProperty("morphium.log.level", "" + globalLogLevel);
        LoggerRegistry.get().updateSettings();
    }

    public boolean isGlobalLogSynced() {
        return this.globalLogSynced;
    }

    public void setGlobalLogSynced(boolean globalLogSynced) {
        this.globalLogSynced = globalLogSynced;
        System.setProperty("morphium.log.synced", "" + globalLogSynced);
        LoggerRegistry.get().updateSettings();
    }

    public String getGlobalLogFile() {
        return this.globalLogFile;
    }

    public void setGlobalLogFile(String globalLogFile) {
        this.globalLogFile = globalLogFile;
        System.setProperty("morphium.log.file", globalLogFile);
        LoggerRegistry.get().updateSettings();
    }

    public void setLogFileForClass(Class cls, String file) {
        this.setLogFileForPrefix(cls.getName(), file);
    }

    public void setLogFileForPrefix(String prf, String file) {
        System.setProperty("morphium.log.file." + prf, file);
        LoggerRegistry.get().updateSettings();
    }

    public void setLogLevelForClass(Class cls, int level) {
        this.setLogLevelForPrefix(cls.getName(), level);
    }

    public void setLogLevelForPrefix(String cls, int level) {
        System.setProperty("morphium.log.level." + cls, "" + level);
        LoggerRegistry.get().updateSettings();
    }

    public void setLogSyncedForClass(Class cls, boolean synced) {
        this.setLogSyncedForPrefix(cls.getName(), synced);
    }

    public void setLogSyncedForPrefix(String cls, boolean synced) {
        System.setProperty("morphium.log.synced." + cls, synced ? "true" : "false");
        LoggerRegistry.get().updateSettings();
    }

    public String getDefaultTags() {
        return this.defaultTags;
    }

    public void addDefaultTag(String name, String value) {
        this.defaultTags = this.defaultTags != null ? this.defaultTags + "," : "";
        this.defaultTags = this.defaultTags + name + ":" + value;
    }

    public List<Map<String, String>> getDefaultTagSet() {
        if (this.defaultTags == null) {
            return null;
        }
        ArrayList<Map<String, String>> tagList = new ArrayList<Map<String, String>>();
        for (String t : this.defaultTags.split(",")) {
            String[] tag = t.split(":");
            tagList.add(Utils.getMap(tag[0], tag[1]));
        }
        return tagList;
    }

    public int getCursorBatchSize() {
        return this.cursorBatchSize;
    }

    public void setCursorBatchSize(int cursorBatchSize) {
        this.cursorBatchSize = cursorBatchSize;
    }
}

