/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.aggregation;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.Utils;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.Group;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.query.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AggregatorImpl<T, R>
implements Aggregator<T, R> {
    private final List<Map<String, Object>> params = new ArrayList<Map<String, Object>>();
    private final List<Group<T, R>> groups = new ArrayList<Group<T, R>>();
    private Class<? extends T> type;
    private Morphium morphium;
    private Class<? extends R> rType;
    private String collectionName;
    private boolean useDisk = false;
    private boolean explain = false;

    @Override
    public boolean isUseDisk() {
        return this.useDisk;
    }

    @Override
    public void setUseDisk(boolean useDisk) {
        this.useDisk = useDisk;
    }

    @Override
    public boolean isExplain() {
        return this.explain;
    }

    @Override
    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    @Override
    public Morphium getMorphium() {
        return this.morphium;
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
    }

    @Override
    public Class<? extends T> getSearchType() {
        return this.type;
    }

    @Override
    public void setSearchType(Class<? extends T> type) {
        this.type = type;
    }

    @Override
    public Class<? extends R> getResultType() {
        return this.rType;
    }

    @Override
    public void setResultType(Class<? extends R> type) {
        this.rType = type;
    }

    @Override
    public Aggregator<T, R> project(String ... m) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String sm : m) {
            map.put(sm, 1);
        }
        return this.project(map);
    }

    @Override
    public Aggregator<T, R> project(Map<String, Object> m) {
        Map<String, Map<String, Object>> o = Utils.getMap("$project", m);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> match(Query<T> q) {
        Map<String, Map<String, Object>> o = Utils.getMap("$match", q.toQueryObject());
        this.collectionName = q.getCollectionName();
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> matchSubQuery(Query<?> q) {
        Map<String, Map<String, Object>> o = Utils.getMap("$match", q.toQueryObject());
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> limit(int num) {
        Map<String, Integer> o = Utils.getMap("$limit", num);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> skip(int num) {
        Map<String, Integer> o = Utils.getMap("$skip", num);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> unwind(String listField) {
        Map<String, String> o = Utils.getMap("$unwind", listField);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> sort(String ... prefixed) {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        String[] stringArray = prefixed;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String i2;
            String fld = i2 = stringArray[i];
            int val = 1;
            if (i2.startsWith("-")) {
                fld = i2.substring(1);
                val = -1;
            } else if (i2.startsWith("+")) {
                fld = i2.substring(1);
                val = 1;
            }
            if (i2.startsWith("$") && !(fld = fld.substring(1)).contains(".")) {
                fld = this.morphium.getARHelper().getFieldName(this.type, fld);
            }
            m.put(fld, val);
        }
        this.sort(m);
        return this;
    }

    @Override
    public Aggregator<T, R> sort(Map<String, Integer> sort) {
        Map<String, Map<String, Integer>> o = Utils.getMap("$sort", sort);
        this.params.add(o);
        return this;
    }

    @Override
    public String getCollectionName() {
        if (this.collectionName == null) {
            this.collectionName = this.morphium.getMapper().getCollectionName(this.type);
        }
        return this.collectionName;
    }

    @Override
    public void setCollectionName(String cn) {
        this.collectionName = cn;
    }

    @Override
    public Group<T, R> group(Map<String, Object> id) {
        return new Group(this, id);
    }

    @Override
    public Group<T, R> groupSubObj(Map<String, String> idSubObject) {
        Group gr = new Group(this, idSubObject);
        this.groups.add(gr);
        return gr;
    }

    @Override
    public Group<T, R> group(String id) {
        Group gr = new Group(this, id);
        this.groups.add(gr);
        return gr;
    }

    @Override
    public void addOperator(Map<String, Object> o) {
        this.params.add(o);
    }

    @Override
    public List<R> aggregate() {
        return this.morphium.aggregate(this);
    }

    @Override
    public void aggregate(AsyncOperationCallback<R> callback) {
        if (callback == null) {
            this.morphium.aggregate(this);
        } else {
            this.morphium.queueTask(() -> {
                long start = System.currentTimeMillis();
                List ret = this.morphium.aggregate(this);
                callback.onOperationSucceeded(AsyncOperationType.READ, null, System.currentTimeMillis() - start, ret, null, this);
            });
        }
    }

    @Override
    public List<Map<String, Object>> toAggregationList() {
        for (Group<T, R> g : this.groups) {
            g.end();
        }
        this.groups.clear();
        return this.params;
    }
}

