/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.query;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import de.caluga.morphium.FilterExpression;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.ObjectMapper;
import de.caluga.morphium.ReadAccessType;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.DefaultReadPreference;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.LastAccess;
import de.caluga.morphium.annotations.ReadPreferenceLevel;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.query.MongoField;
import de.caluga.morphium.query.MorphiumIterator;
import de.caluga.morphium.query.Query;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.bson.BSONObject;

public class QueryImpl<T>
implements Query<T>,
Cloneable {
    private static Logger log = Logger.getLogger(Query.class);
    private String where;
    private Class<? extends T> type;
    private List<FilterExpression> andExpr;
    private List<Query<T>> orQueries;
    private List<Query<T>> norQueries;
    private ReadPreferenceLevel readPreferenceLevel;
    private ReadPreference readPreference;
    private boolean additionalDataPresent = false;
    private int limit = 0;
    private int skip = 0;
    private Map<String, Object> sort;
    private Morphium morphium;
    private ThreadPoolExecutor executor;
    private String collectionName;
    private ServerAddress srv = null;
    private DBObject fieldList;
    private boolean autoValuesEnabled = true;
    private DBObject additionalFields;

    public QueryImpl() {
    }

    public QueryImpl(Morphium m, Class<? extends T> type, ThreadPoolExecutor executor) {
        this(m);
        this.setType(type);
        this.executor = executor;
    }

    public QueryImpl(Morphium m) {
        this.setMorphium(m);
    }

    @Override
    public void disableAutoValues() {
        this.autoValuesEnabled = false;
    }

    @Override
    public void enableAutoValues() {
        this.autoValuesEnabled = true;
    }

    @Override
    public boolean isAutoValuesEnabled() {
        return this.autoValuesEnabled;
    }

    @Override
    public void setAutoValuesEnabled(boolean autoValuesEnabled) {
        this.autoValuesEnabled = autoValuesEnabled;
    }

    @Override
    public ServerAddress getServer() {
        return this.srv;
    }

    public ThreadPoolExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        }
        return this.executor;
    }

    @Override
    public void setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    @Override
    public String getWhere() {
        return this.where;
    }

    @Override
    public Morphium getMorphium() {
        return this.morphium;
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        this.andExpr = new Vector<FilterExpression>();
        this.orQueries = new Vector<Query<T>>();
        this.norQueries = new Vector<Query<T>>();
    }

    @Override
    public ReadPreferenceLevel getReadPreferenceLevel() {
        return this.readPreferenceLevel;
    }

    @Override
    public void setReadPreferenceLevel(ReadPreferenceLevel readPreferenceLevel) {
        this.readPreferenceLevel = readPreferenceLevel;
        this.readPreference = readPreferenceLevel.getPref();
    }

    @Override
    public Query<T> q() {
        QueryImpl<T> q = new QueryImpl<T>(this.morphium, this.type, this.executor);
        q.setCollectionName(this.getCollectionName());
        return q;
    }

    @Override
    public List<T> complexQuery(DBObject query) {
        return this.complexQuery(query, (String)null, 0, 0);
    }

    @Override
    public List<T> complexQuery(DBObject query, String sort, int skip, int limit) {
        HashMap<String, Integer> srt = new HashMap<String, Integer>();
        if (sort != null) {
            String[] tok;
            for (String t : tok = sort.split(",")) {
                if (t.startsWith("-")) {
                    srt.put(t.substring(1), -1);
                    continue;
                }
                if (t.startsWith("+")) {
                    srt.put(t.substring(1), 1);
                    continue;
                }
                srt.put(t, 1);
            }
        }
        return this.complexQuery(query, srt, skip, limit);
    }

    @Override
    public List<T> complexQuery(DBObject query, Map<String, Integer> sort, int skip, int limit) {
        Cache ca = this.morphium.getARHelper().getAnnotationFromHierarchy(this.type, Cache.class);
        boolean useCache = ca != null && ca.readCache() && this.morphium.isReadCacheEnabledForThread();
        String ck = this.morphium.getCache().getCacheKey(query, sort, this.getCollectionName(), skip, limit);
        if (useCache && this.morphium.getCache().isCached(this.type, ck)) {
            return this.morphium.getCache().getFromCache(this.type, ck);
        }
        long start = System.currentTimeMillis();
        DBCollection c = this.morphium.getDatabase().getCollection(this.getCollectionName());
        this.setReadPreferenceFor(c);
        BasicDBObject lst = this.getFieldListForQuery();
        ArrayList<T> ret = new ArrayList<T>();
        int retries = this.morphium.getConfig().getRetriesOnNetworkError();
        for (int i = 0; i < retries; ++i) {
            try {
                DBCursor cursor = c.find(query, (DBObject)lst);
                if (sort != null) {
                    BasicDBObject srt = new BasicDBObject();
                    srt.putAll(sort);
                    cursor.sort((DBObject)srt);
                }
                if (skip > 0) {
                    cursor.skip(skip);
                }
                if (limit > 0) {
                    cursor.limit(limit);
                }
                while (cursor.hasNext()) {
                    T unmarshall = this.morphium.getMapper().unmarshall(this.type, cursor.next());
                    if (unmarshall == null) continue;
                    ret.add(unmarshall);
                }
                this.srv = cursor.getServerAddress();
                break;
            }
            catch (RuntimeException e) {
                this.morphium.handleNetworkError(i, e);
                continue;
            }
        }
        this.morphium.fireProfilingReadEvent(this, System.currentTimeMillis() - start, ReadAccessType.AS_LIST);
        if (useCache) {
            this.morphium.getCache().addToCache(ck, this.type, ret);
        }
        return ret;
    }

    private BasicDBObject getFieldListForQuery() {
        List<Field> fldlst = this.morphium.getARHelper().getAllFields(this.type);
        BasicDBObject lst = new BasicDBObject();
        lst.put("_id", (Object)1);
        Entity e = this.morphium.getARHelper().getAnnotationFromHierarchy(this.type, Entity.class);
        if (e.polymorph()) {
            lst.put("class_name", (Object)1);
        }
        if (this.fieldList != null) {
            lst.putAll((BSONObject)this.fieldList);
        } else {
            for (Field f : fldlst) {
                if (f.isAnnotationPresent(AdditionalData.class)) {
                    lst = new BasicDBObject();
                    break;
                }
                String n = this.morphium.getARHelper().getFieldName(this.type, f.getName());
                lst.put(n, (Object)1);
            }
        }
        if (this.additionalFields != null) {
            lst.putAll((BSONObject)this.additionalFields);
        }
        return lst;
    }

    @Override
    public List distinct(String field) {
        return this.morphium.getDatabase().getCollection(this.getCollectionName()).distinct(field, this.toQueryObject());
    }

    @Override
    public T complexQueryOne(DBObject query) {
        return this.complexQueryOne(query, null, 0);
    }

    @Override
    public T complexQueryOne(DBObject query, Map<String, Integer> sort, int skip) {
        List<T> ret = this.complexQuery(query, sort, skip, 1);
        if (ret != null && !ret.isEmpty()) {
            return ret.get(0);
        }
        return null;
    }

    @Override
    public T complexQueryOne(DBObject query, Map<String, Integer> sort) {
        return this.complexQueryOne(query, sort, 0);
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getSkip() {
        return this.skip;
    }

    @Override
    public Map<String, Object> getSort() {
        return this.sort;
    }

    @Override
    public void addChild(FilterExpression ex) {
        this.andExpr.add(ex);
    }

    @Override
    public Query<T> where(String wh) {
        this.where = wh;
        return this;
    }

    @Override
    public MongoField<T> f(Enum f) {
        return this.f(f.name());
    }

    @Override
    public MongoField<T> f(String ... f) {
        StringBuffer b = new StringBuffer();
        for (String e : f) {
            b.append(e);
            b.append(".");
        }
        b.deleteCharAt(b.length());
        return this.f(b.toString());
    }

    @Override
    public MongoField<T> f(Enum ... f) {
        StringBuffer b = new StringBuffer();
        for (Enum e : f) {
            b.append(e.name());
            b.append(".");
        }
        b.deleteCharAt(b.length());
        return this.f(b.toString());
    }

    @Override
    public MongoField<T> f(String f) {
        StringBuffer fieldPath = new StringBuffer();
        String cf = f;
        Class<Object> clz = this.type;
        if (f.contains(".")) {
            String[] fieldNames;
            for (String fieldName : fieldNames = f.split("\\.")) {
                String fieldNameInstance = this.morphium.getARHelper().getFieldName(clz, fieldName);
                Field field = this.morphium.getARHelper().getField(clz, fieldNameInstance);
                if (field == null) {
                    throw new IllegalArgumentException("Field " + fieldNameInstance + " not found!");
                }
                if (field.isAnnotationPresent(Reference.class)) {
                    throw new IllegalArgumentException("cannot subquery references: " + fieldNameInstance + " of type " + clz.getName() + " has @Reference");
                }
                fieldPath.append(fieldNameInstance);
                fieldPath.append('.');
                clz = field.getType();
                if (clz.equals(List.class) || clz.equals(Collection.class) || clz.equals(Array.class) || clz.equals(Set.class) || clz.equals(Map.class)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Cannot check fields in generic lists or maps");
                    }
                    clz = Object.class;
                }
                if (clz.equals(Object.class)) break;
            }
            cf = clz.equals(Object.class) ? f : fieldPath.substring(0, fieldPath.length() - 1);
        } else {
            cf = this.morphium.getARHelper().getFieldName(clz, f);
        }
        if (this.additionalDataPresent) {
            log.debug((Object)"Additional data is available, not checking field");
        }
        MongoField fld = this.morphium.createMongoField();
        fld.setFieldString(cf);
        fld.setMapper(this.morphium.getMapper());
        fld.setQuery(this);
        return fld;
    }

    @Override
    public Query<T> or(Query<T> ... qs) {
        this.orQueries.addAll(Arrays.asList(qs));
        return this;
    }

    @Override
    public Query<T> or(List<Query<T>> qs) {
        this.orQueries.addAll(qs);
        return this;
    }

    private Query<T> getClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)"Clone not supported?!?!?!");
            throw new RuntimeException(e);
        }
    }

    @Override
    public Query<T> nor(Query<T> ... qs) {
        this.norQueries.addAll(Arrays.asList(qs));
        return this;
    }

    @Override
    public Query<T> limit(int i) {
        this.limit = i;
        return this;
    }

    @Override
    public Query<T> skip(int i) {
        this.skip = i;
        return this;
    }

    @Override
    public Query<T> sort(Map<String, Object> n) {
        this.sort = n;
        return this;
    }

    @Override
    public Query<T> sort(String ... prefixedString) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        String[] arr$ = prefixedString;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String i;
            String fld = i = arr$[i$];
            int val = 1;
            if (i.startsWith("-")) {
                fld = i.substring(1);
                val = -1;
            } else if (i.startsWith("+")) {
                fld = i.substring(1);
                val = 1;
            }
            if (!fld.contains(".") && !fld.startsWith("$")) {
                fld = this.morphium.getARHelper().getFieldName(this.type, fld);
            }
            m.put(fld, val);
        }
        return this.sort(m);
    }

    @Override
    public Query<T> sort(Enum ... naturalOrder) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Enum i : naturalOrder) {
            String fld = this.morphium.getARHelper().getFieldName(this.type, i.name());
            m.put(fld, 1);
        }
        return this.sort(m);
    }

    @Override
    public void countAll(final AsyncOperationCallback<T> c) {
        if (c == null) {
            throw new IllegalArgumentException("Not really useful to read from db and not use the result");
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    long ret = QueryImpl.this.countAll();
                    c.onOperationSucceeded(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, null, null, ret);
                }
                catch (Exception e) {
                    c.onOperationError(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
                }
            }
        };
        this.getExecutor().submit(r);
    }

    @Override
    public long countAll() {
        this.morphium.inc(StatisticKeys.READS);
        long start = System.currentTimeMillis();
        DBCollection collection = this.morphium.getDatabase().getCollection(this.getCollectionName());
        this.setReadPreferenceFor(collection);
        for (int i = 0; i < this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
            try {
                DBCursor cu = collection.find(this.toQueryObject());
                long ret = cu.count();
                this.srv = cu.getServerAddress();
                this.morphium.fireProfilingReadEvent(this, System.currentTimeMillis() - start, ReadAccessType.COUNT);
                return ret;
            }
            catch (RuntimeException e) {
                this.morphium.handleNetworkError(i, e);
                continue;
            }
        }
        return 0L;
    }

    private void setReadPreferenceFor(DBCollection c) {
        if (this.readPreference != null) {
            c.setReadPreference(this.readPreference);
        } else {
            c.setReadPreference(null);
        }
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
        this.readPreferenceLevel = null;
    }

    @Override
    public DBObject toQueryObject() {
        boolean onlyAnd;
        BasicDBObject o = new BasicDBObject();
        BasicDBList lst = new BasicDBList();
        boolean bl = onlyAnd = this.orQueries.isEmpty() && this.norQueries.isEmpty() && this.where == null;
        if (this.where != null) {
            o.put("$where", (Object)this.where);
        }
        if (this.andExpr.size() == 1 && onlyAnd) {
            return this.andExpr.get(0).dbObject();
        }
        if (this.andExpr.size() == 1 && onlyAnd) {
            return this.andExpr.get(0).dbObject();
        }
        if (this.andExpr.isEmpty() && onlyAnd) {
            return o;
        }
        if (this.andExpr.size() > 0) {
            for (FilterExpression filterExpression : this.andExpr) {
                lst.add((Object)filterExpression.dbObject());
            }
            o.put("$and", (Object)lst);
            lst = new BasicDBList();
        }
        if (this.orQueries.size() != 0) {
            for (Query query : this.orQueries) {
                lst.add((Object)query.toQueryObject());
            }
            if (o.get("$and") != null) {
                ((BasicDBList)o.get("$and")).add((Object)new BasicDBObject("$or", (Object)lst));
            } else {
                o.put("$or", (Object)lst);
            }
        }
        if (this.norQueries.size() != 0) {
            for (Query query : this.norQueries) {
                lst.add((Object)query.toQueryObject());
            }
            if (o.get("$and") != null) {
                ((BasicDBList)o.get("$and")).add((Object)new BasicDBObject("$nor", (Object)lst));
            } else {
                o.put("$nor", (Object)lst);
            }
        }
        return o;
    }

    @Override
    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public void setType(Class<? extends T> type) {
        List<String> fields;
        this.type = type;
        DefaultReadPreference pr = this.morphium.getARHelper().getAnnotationFromHierarchy(type, DefaultReadPreference.class);
        if (pr != null) {
            this.setReadPreferenceLevel(pr.value());
        }
        this.additionalDataPresent = (fields = this.morphium.getARHelper().getFields(type, AdditionalData.class)) != null && fields.size() != 0;
    }

    @Override
    public void asList(final AsyncOperationCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    List lst = QueryImpl.this.asList();
                    callback.onOperationSucceeded(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, lst, null, new Object[0]);
                }
                catch (Exception e) {
                    callback.onOperationError(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
                }
            }
        };
        this.getExecutor().submit(r);
    }

    @Override
    public List<T> asList() {
        this.morphium.inc(StatisticKeys.READS);
        Cache c = this.morphium.getARHelper().getAnnotationFromHierarchy(this.type, Cache.class);
        boolean useCache = c != null && c.readCache() && this.morphium.isReadCacheEnabledForThread();
        String ck = this.morphium.getCache().getCacheKey(this);
        if (useCache) {
            if (this.morphium.getCache().isCached(this.type, ck)) {
                this.morphium.inc(StatisticKeys.CHITS);
                return this.morphium.getCache().getFromCache(this.type, ck);
            }
            this.morphium.inc(StatisticKeys.CMISS);
        } else {
            this.morphium.inc(StatisticKeys.NO_CACHED_READS);
        }
        long start = System.currentTimeMillis();
        DBCollection collection = this.morphium.getDatabase().getCollection(this.getCollectionName());
        this.setReadPreferenceFor(collection);
        BasicDBObject lst = this.getFieldListForQuery();
        ArrayList<T> ret = new ArrayList<T>();
        for (int i = 0; i < this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
            ret.clear();
            try {
                DBCursor query = collection.find(this.toQueryObject(), (DBObject)lst);
                if (this.skip > 0) {
                    query.skip(this.skip);
                }
                if (this.limit > 0) {
                    query.limit(this.limit);
                }
                if (this.sort != null) {
                    BasicDBObject srt = new BasicDBObject();
                    for (String k : this.sort.keySet()) {
                        srt.append(k, this.sort.get(k));
                    }
                    query.sort((DBObject)new BasicDBObject((Map)srt));
                }
                this.srv = query.getServerAddress();
                for (DBObject o : query) {
                    T unmarshall = this.morphium.getMapper().unmarshall(this.type, o);
                    if (unmarshall == null) continue;
                    ret.add(unmarshall);
                    this.updateLastAccess(unmarshall);
                    this.morphium.firePostLoadEvent(unmarshall);
                }
                break;
            }
            catch (Throwable es) {
                this.morphium.handleNetworkError(i, es);
                continue;
            }
        }
        this.morphium.fireProfilingReadEvent(this, System.currentTimeMillis() - start, ReadAccessType.AS_LIST);
        if (useCache) {
            this.morphium.getCache().addToCache(ck, this.type, ret);
        }
        this.morphium.firePostLoad(ret);
        return ret;
    }

    @Override
    public MorphiumIterator<T> asIterable() {
        return this.asIterable(10, 1);
    }

    @Override
    public MorphiumIterator<T> asIterable(int windowSize) {
        return this.asIterable(windowSize, 1);
    }

    @Override
    public MorphiumIterator<T> asIterable(int windowSize, int prefixWindows) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("creating iterable for query - windowsize " + windowSize));
            }
            MorphiumIterator it = this.morphium.getConfig().getIteratorClass().newInstance();
            it.setQuery(this);
            it.setWindowSize(windowSize);
            it.setNumberOfPrefetchWindows(prefixWindows);
            return it;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateLastAccess(T unmarshall) {
        if (!this.autoValuesEnabled) {
            return;
        }
        if (!this.morphium.isAutoValuesEnabledForThread()) {
            return;
        }
        if (this.morphium.getARHelper().isAnnotationPresentInHierarchy(this.type, LastAccess.class)) {
            List<String> lst = this.morphium.getARHelper().getFields(this.type, LastAccess.class);
            for (String ctf : lst) {
                Field f = this.morphium.getARHelper().getField(this.type, ctf);
                if (f == null) continue;
                try {
                    long currentTime = System.currentTimeMillis();
                    if (f.getType().equals(Date.class)) {
                        f.set(unmarshall, new Date());
                    } else if (f.getType().equals(String.class)) {
                        LastAccess ctField = f.getAnnotation(LastAccess.class);
                        SimpleDateFormat df = new SimpleDateFormat(ctField.dateFormat());
                        f.set(unmarshall, df.format(currentTime));
                    } else {
                        f.set(unmarshall, currentTime);
                    }
                    ObjectMapper mapper = this.morphium.getMapper();
                    String collName = mapper.getCollectionName(unmarshall.getClass());
                    Object id = this.morphium.getARHelper().getId(unmarshall);
                    this.morphium.getDatabase().getCollection(collName).update((DBObject)new BasicDBObject("_id", id), (DBObject)new BasicDBObject("$set", (Object)new BasicDBObject(ctf, (Object)currentTime)));
                }
                catch (IllegalAccessException e) {
                    System.out.println("Could not set modification time");
                }
            }
        }
    }

    @Override
    public void getById(final Object id, final AsyncOperationCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback is null");
        }
        Runnable c = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    Object res = QueryImpl.this.getById(id);
                    ArrayList result = new ArrayList();
                    result.add(res);
                    callback.onOperationSucceeded(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, result, res, new Object[0]);
                }
                catch (Exception e) {
                    callback.onOperationError(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
                }
            }
        };
        this.getExecutor().submit(c);
    }

    @Override
    public T getById(Object id) {
        List<String> flds = this.morphium.getARHelper().getFields(this.type, Id.class);
        if (flds == null || flds.isEmpty()) {
            throw new RuntimeException("Type does not have an ID-Field? " + this.type.getSimpleName());
        }
        String f = flds.get(0);
        Query<T> q = this.q().f(f).eq(id);
        return q.get();
    }

    @Override
    public void get(final AsyncOperationCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback is null");
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    ArrayList ret = new ArrayList();
                    Object ent = QueryImpl.this.get();
                    ret.add(ent);
                    callback.onOperationSucceeded(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, ret, ent, new Object[0]);
                }
                catch (Exception e) {
                    callback.onOperationError(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
                }
            }
        };
        this.getExecutor().submit(r);
    }

    @Override
    public T get() {
        Cache c = this.morphium.getARHelper().getAnnotationFromHierarchy(this.type, Cache.class);
        boolean useCache = c != null && c.readCache() && this.morphium.isReadCacheEnabledForThread();
        String ck = this.morphium.getCache().getCacheKey(this);
        this.morphium.inc(StatisticKeys.READS);
        if (useCache) {
            if (this.morphium.getCache().isCached(this.type, ck)) {
                this.morphium.inc(StatisticKeys.CHITS);
                List<T> lst = this.morphium.getCache().getFromCache(this.type, ck);
                if (lst == null || lst.isEmpty()) {
                    return null;
                }
                return lst.get(0);
            }
            this.morphium.inc(StatisticKeys.CMISS);
        } else {
            this.morphium.inc(StatisticKeys.NO_CACHED_READS);
        }
        long start = System.currentTimeMillis();
        DBCollection coll = this.morphium.getDatabase().getCollection(this.getCollectionName());
        this.setReadPreferenceFor(coll);
        BasicDBObject fl = this.getFieldListForQuery();
        DBCursor srch = coll.find(this.toQueryObject(), (DBObject)fl);
        srch.limit(1);
        if (this.skip != 0) {
            srch = srch.skip(this.skip);
        }
        if (this.sort != null) {
            BasicDBObject srt = new BasicDBObject();
            for (String k : this.sort.keySet()) {
                srt.append(k, this.sort.get(k));
            }
            srch.sort((DBObject)new BasicDBObject((Map)srt));
        }
        if (srch.length() == 0) {
            return null;
        }
        DBObject ret = null;
        for (int i = 0; i < this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
            try {
                ret = (DBObject)srch.toArray(1).get(0);
                this.srv = srch.getServerAddress();
                break;
            }
            catch (RuntimeException e) {
                this.morphium.handleNetworkError(i, e);
                continue;
            }
        }
        ArrayList<T> lst = new ArrayList<T>(1);
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingReadEvent(this, dur, ReadAccessType.GET);
        if (ret != null) {
            T unmarshall = this.morphium.getMapper().unmarshall(this.type, ret);
            if (unmarshall != null) {
                this.morphium.firePostLoadEvent(unmarshall);
                this.updateLastAccess(unmarshall);
                lst.add(unmarshall);
                if (useCache) {
                    this.morphium.getCache().addToCache(ck, this.type, lst);
                }
            }
            return unmarshall;
        }
        if (useCache) {
            this.morphium.getCache().addToCache(ck, this.type, lst);
        }
        return null;
    }

    @Override
    public void idList(final AsyncOperationCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callable is null?");
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    List ret = QueryImpl.this.idList();
                    callback.onOperationSucceeded(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, null, null, ret);
                }
                catch (Exception e) {
                    callback.onOperationError(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
                }
            }
        };
        this.getExecutor().submit(r);
    }

    @Override
    public <R> List<R> idList() {
        Cache c = this.morphium.getARHelper().getAnnotationFromHierarchy(this.type, Cache.class);
        boolean useCache = c != null && c.readCache() && this.morphium.isReadCacheEnabledForThread();
        ArrayList<Object> ret = new ArrayList<Object>();
        String ck = this.morphium.getCache().getCacheKey(this);
        ck = ck + " idlist";
        this.morphium.inc(StatisticKeys.READS);
        if (useCache) {
            if (this.morphium.getCache().isCached(this.type, ck)) {
                this.morphium.inc(StatisticKeys.CHITS);
                return this.morphium.getCache().getFromCache(this.type, ck);
            }
            this.morphium.inc(StatisticKeys.CMISS);
        } else {
            this.morphium.inc(StatisticKeys.NO_CACHED_READS);
        }
        long start = System.currentTimeMillis();
        DBCollection collection = this.morphium.getDatabase().getCollection(this.getCollectionName());
        this.setReadPreferenceFor(collection);
        for (int i = 0; i < this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
            try {
                DBCursor query = collection.find(this.toQueryObject(), (DBObject)new BasicDBObject("_id", (Object)1));
                if (this.sort != null) {
                    query.sort((DBObject)new BasicDBObject(this.sort));
                }
                if (this.skip > 0) {
                    query.skip(this.skip);
                }
                if (this.limit > 0) {
                    query.limit(0);
                }
                for (DBObject o : query) {
                    ret.add(o.get("_id"));
                }
                this.srv = query.getServerAddress();
                break;
            }
            catch (RuntimeException e) {
                this.morphium.handleNetworkError(i, e);
                continue;
            }
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingReadEvent(this, dur, ReadAccessType.ID_LIST);
        if (useCache) {
            this.morphium.getCache().addToCache(ck, this.type, ret);
        }
        return ret;
    }

    @Override
    public Query<T> clone() throws CloneNotSupportedException {
        try {
            QueryImpl ret = (QueryImpl)super.clone();
            if (this.andExpr != null) {
                ret.andExpr = new Vector<FilterExpression>();
                ret.andExpr.addAll(this.andExpr);
            }
            if (this.norQueries != null) {
                ret.norQueries = new Vector<Query<T>>();
                ret.norQueries.addAll(this.norQueries);
            }
            if (this.sort != null) {
                ret.sort = new Hashtable<String, Object>();
                ret.sort.putAll(this.sort);
            }
            if (this.orQueries != null) {
                ret.orQueries = new Vector<Query<T>>();
                ret.orQueries.addAll(this.orQueries);
            }
            if (this.readPreferenceLevel != null) {
                ret.readPreferenceLevel = this.readPreferenceLevel;
            }
            if (this.readPreference != null) {
                ret.readPreference = this.readPreference;
            }
            if (this.where != null) {
                ret.where = this.where;
            }
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete() {
        this.morphium.delete(this);
    }

    @Override
    public int getNumberOfPendingRequests() {
        return this.getExecutor().getActiveCount();
    }

    @Override
    public String getCollectionName() {
        if (this.collectionName == null) {
            this.collectionName = this.morphium.getMapper().getCollectionName(this.type);
        }
        return this.collectionName;
    }

    @Override
    public void setCollectionName(String n) {
        this.collectionName = n;
    }

    @Override
    public Query<T> text(String ... text) {
        return this.text(null, (Query.TextSearchLanguages)null, text);
    }

    @Override
    public Query<T> text(Query.TextSearchLanguages lang, String ... text) {
        return this.text(null, lang, text);
    }

    @Override
    public Query<T> text(String metaScoreField, Query.TextSearchLanguages lang, String ... text) {
        FilterExpression f = new FilterExpression();
        f.setField("$text");
        StringBuilder b = new StringBuilder();
        for (String t : text) {
            b.append(t);
            b.append(" ");
        }
        f.setValue(new BasicDBObject("$search", (Object)b.toString()));
        if (lang != null) {
            ((BasicDBObject)f.getValue()).put("$language", (Object)lang.toString());
        }
        this.addChild(f);
        if (metaScoreField != null) {
            this.additionalFields = new BasicDBObject(metaScoreField, (Object)new BasicDBObject((Map)new BasicDBObject("$meta", (Object)"textScore")));
        }
        return this;
    }

    @Override
    @Deprecated
    public List<T> textSearch(String ... texts) {
        return this.textSearch(Query.TextSearchLanguages.mongo_default, texts);
    }

    @Override
    @Deprecated
    public List<T> textSearch(Query.TextSearchLanguages lang, String ... texts) {
        CommandResult result;
        if (texts.length == 0) {
            return new ArrayList();
        }
        BasicDBObject txt = new BasicDBObject();
        txt.append("text", (Object)this.getCollectionName());
        StringBuilder b = new StringBuilder();
        for (String t : texts) {
            b.append(t);
            b.append(" ");
        }
        txt.append("search", (Object)b.toString());
        txt.append("filter", (Object)this.toQueryObject());
        if (this.getLimit() > 0) {
            txt.append("limit", (Object)this.limit);
        }
        if (!lang.equals((Object)Query.TextSearchLanguages.mongo_default)) {
            txt.append("language", (Object)lang.name());
        }
        if (!(result = this.morphium.getDatabase().command((DBObject)txt)).ok()) {
            return null;
        }
        BasicDBList lst = (BasicDBList)result.get("results");
        ArrayList<T> ret = new ArrayList<T>();
        for (Object o : lst) {
            DBObject obj = (DBObject)o;
            T unmarshall = this.morphium.getMapper().unmarshall(this.getType(), obj);
            if (unmarshall == null) continue;
            ret.add(unmarshall);
        }
        return ret;
    }

    @Override
    public void setReturnedFields(Enum ... fl) {
        for (Enum f : fl) {
            this.addReturnedField(f);
        }
    }

    @Override
    public void setReturnedFields(String ... fl) {
        this.fieldList = new BasicDBObject();
        for (String f : fl) {
            this.addReturnedField(f);
        }
    }

    @Override
    public void addReturnedField(Enum f) {
        this.addReturnedField(f.name());
    }

    @Override
    public void addReturnedField(String f) {
        if (this.fieldList == null) {
            this.fieldList = new BasicDBObject();
        }
        String n = this.morphium.getARHelper().getFieldName(this.type, f);
        this.fieldList.put(n, (Object)1);
    }

    public String toString() {
        StringBuilder and = new StringBuilder();
        if (this.andExpr != null && this.andExpr.size() > 0) {
            and.append("[");
            for (FilterExpression fe : this.andExpr) {
                and.append(fe.toString());
                and.append(", ");
            }
            and.deleteCharAt(and.length() - 1);
            and.deleteCharAt(and.length() - 1);
            and.append(" ]");
        }
        StringBuilder ors = new StringBuilder();
        if (this.orQueries != null && this.orQueries.size() > 0) {
            ors.append("[ ");
            for (Query<T> o : this.orQueries) {
                ors.append(o.toString());
                ors.append(", ");
            }
            ors.deleteCharAt(ors.length() - 1);
            ors.deleteCharAt(ors.length() - 1);
            ors.append(" ]");
        }
        StringBuilder nors = new StringBuilder();
        if (this.norQueries != null && this.norQueries.size() > 0) {
            nors.append("[ ");
            for (Query<T> o : this.norQueries) {
                nors.append(o.toString());
                nors.append(", ");
            }
            nors.deleteCharAt(nors.length() - 1);
            nors.deleteCharAt(nors.length() - 1);
            nors.append(" ]");
        }
        String ret = "Query{ collectionName='" + this.collectionName + '\'' + ", type=" + this.type.getName() + ", skip=" + this.skip + ", limit=" + this.limit + ", andExpr=" + and.toString() + ", orQueries=" + ors + ", norQueries=" + nors + ", sort=" + this.sort + ", readPreferenceLevel=" + (Object)((Object)this.readPreferenceLevel) + ", additionalDataPresent=" + this.additionalDataPresent + ", where='" + this.where + '\'' + '}';
        if (this.fieldList != null) {
            ret = ret + " Fields " + this.fieldList.toString();
        }
        return ret;
    }
}

