/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.writer;

import com.mongodb.BulkWriteError;
import com.mongodb.BulkWriteException;
import de.caluga.morphium.Logger;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.ShutdownListener;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.annotations.caching.WriteBuffer;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.bulk.BulkOperationContext;
import de.caluga.morphium.bulk.BulkRequestWrapper;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.writer.MorphiumWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import org.bson.types.ObjectId;

public class BufferedMorphiumWriterImpl
implements MorphiumWriter,
ShutdownListener {
    private Morphium morphium;
    private MorphiumWriter directWriter;
    private Map<Class<?>, List<WriteBufferEntry>> opLog = new ConcurrentHashMap();
    private Map<Class<?>, Long> lastRun = new ConcurrentHashMap();
    private Thread housekeeping;
    private boolean running = true;
    private static Logger logger = new Logger(BufferedMorphiumWriterImpl.class);
    private boolean orderedExecution = false;

    public boolean isOrderedExecution() {
        return this.orderedExecution;
    }

    public void setOrderedExecution(boolean orderedExecution) {
        this.orderedExecution = orderedExecution;
    }

    private List<WriteBufferEntry> flushToQueue(List<WriteBufferEntry> localQueue) {
        ArrayList<WriteBufferEntry> didNotWrite = new ArrayList<WriteBufferEntry>();
        BulkOperationContext ctx = new BulkOperationContext(this.morphium, false);
        BulkOperationContext octx = new BulkOperationContext(this.morphium, true);
        for (WriteBufferEntry entry : localQueue) {
            try {
                WriteBuffer w = this.morphium.getARHelper().getAnnotationFromHierarchy(entry.getEntityType(), WriteBuffer.class);
                if (w.ordered()) {
                    entry.getToRun().exec(octx);
                } else {
                    entry.getToRun().exec(ctx);
                }
                entry.getCb().onOperationSucceeded(entry.getType(), null, 0L, null, null, new Object[0]);
            }
            catch (RejectedExecutionException e) {
                logger.info("too much load - add write to next run");
                didNotWrite.add(entry);
            }
            catch (Exception e) {
                logger.error("could not write", e);
            }
        }
        try {
            ctx.execute();
        }
        catch (BulkWriteException bwe) {
            logger.error("Error executing unordered bulk", bwe);
            for (BulkWriteError err : bwe.getWriteErrors()) {
                logger.error("Write error: " + err.getMessage() + "\n" + err.getDetails().toString());
            }
        }
        catch (Exception e) {
            logger.error("Error during exeecution of unordered bulk", e);
        }
        try {
            octx.execute();
        }
        catch (BulkWriteException bwe) {
            logger.error("Error executing ordered bulk", bwe);
            for (BulkWriteError err : bwe.getWriteErrors()) {
                logger.error("Write error: " + err.getMessage() + "\n" + err.getDetails().toString());
            }
        }
        catch (Exception e) {
            logger.error("Error during exeecution of ordered bulk", e);
        }
        return didNotWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToWriteQueue(Class<?> type, BufferedBulkOp r, AsyncOperationCallback c, AsyncOperationType t) {
        Map<Class<?>, List<WriteBufferEntry>> map = this.opLog;
        synchronized (map) {
            WriteBufferEntry wb = new WriteBufferEntry(type, r, System.currentTimeMillis(), c, t);
            if (this.opLog.get(type) == null) {
                this.opLog.put(type, new Vector());
            }
            WriteBuffer w = this.morphium.getARHelper().getAnnotationFromHierarchy(type, WriteBuffer.class);
            int size = 0;
            int timeout = this.morphium.getConfig().getWriteBufferTime();
            WriteBuffer.STRATEGY strategy = WriteBuffer.STRATEGY.JUST_WARN;
            boolean ordered = false;
            if (w != null) {
                ordered = w.ordered();
                size = w.size();
                strategy = w.strategy();
            }
            if (size > 0 && this.opLog.get(type).size() > size) {
                logger.warn("WARNING: Write buffer for type " + type.getName() + " maximum exceeded: " + this.opLog.get(type).size() + " entries now, max is " + size);
                BulkOperationContext ctx = new BulkOperationContext(this.morphium, ordered);
                switch (strategy) {
                    case JUST_WARN: {
                        this.opLog.get(type).add(wb);
                        break;
                    }
                    case IGNORE_NEW: {
                        logger.warn("ignoring new incoming...");
                        return;
                    }
                    case WRITE_NEW: {
                        logger.warn("directly writing data... due to strategy setting");
                        r.exec(ctx);
                        break;
                    }
                    case WRITE_OLD: {
                        Collections.sort(this.opLog.get(type), new Comparator<WriteBufferEntry>(){

                            @Override
                            public int compare(WriteBufferEntry o1, WriteBufferEntry o2) {
                                return Long.valueOf(o1.getTimestamp()).compareTo(o2.getTimestamp());
                            }
                        });
                        this.opLog.get(type).get(0).getToRun().exec(ctx);
                        this.opLog.get(type).remove(0);
                        this.opLog.get(type).add(wb);
                        break;
                    }
                    case DEL_OLD: {
                        Collections.sort(this.opLog.get(type), new Comparator<WriteBufferEntry>(){

                            @Override
                            public int compare(WriteBufferEntry o1, WriteBufferEntry o2) {
                                return Long.valueOf(o1.getTimestamp()).compareTo(o2.getTimestamp());
                            }
                        });
                        if (logger.isDebugEnabled()) {
                            logger.debug("Deleting oldest entry");
                        }
                        this.opLog.get(type).remove(0);
                        this.opLog.get(type).add(wb);
                        return;
                    }
                }
                ctx.execute();
            } else {
                this.opLog.get(type).add(wb);
            }
        }
    }

    @Override
    public <T> void store(final T o, String collection, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(o.getClass(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                boolean isNew;
                boolean bl = isNew = BufferedMorphiumWriterImpl.this.morphium.getARHelper().getId(o) == null;
                if (!isNew && !BufferedMorphiumWriterImpl.this.morphium.getARHelper().getIdField(o).getType().equals(ObjectId.class)) {
                    isNew = BufferedMorphiumWriterImpl.this.morphium.createQueryFor(o.getClass()).f("_id").eq(BufferedMorphiumWriterImpl.this.morphium.getId(o)).countAll() == 0L;
                }
                BufferedMorphiumWriterImpl.this.morphium.firePreStoreEvent(o, isNew);
                if (isNew) {
                    ctx.insert(o);
                } else {
                    BulkRequestWrapper wr = ctx.addFind(BufferedMorphiumWriterImpl.this.morphium.createQueryFor(o.getClass()).f(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getIdFieldName(o)).eq(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getId(o)));
                    for (String f : BufferedMorphiumWriterImpl.this.morphium.getARHelper().getFields(o.getClass(), new Class[0])) {
                        try {
                            wr.set(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getFieldName(o.getClass(), f), BufferedMorphiumWriterImpl.this.morphium.getMapper().marshallIfNecessary(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getField(o.getClass(), f).get(o)), false);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                }
                BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(o.getClass());
                BufferedMorphiumWriterImpl.this.morphium.firePostStoreEvent(o, isNew);
            }
        }, c, AsyncOperationType.WRITE);
    }

    @Override
    public <T> void store(final List<T> lst, AsyncOperationCallback<T> c) {
        if (lst == null || lst.size() == 0) {
            if (c != null) {
                c.onOperationSucceeded(AsyncOperationType.WRITE, null, 0L, lst, null, new Object[0]);
            }
            return;
        }
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(lst.get(0).getClass(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                HashMap<Object, Boolean> map = new HashMap<Object, Boolean>();
                BufferedMorphiumWriterImpl.this.morphium.firePreStoreEvent(map);
                for (Object o : lst) {
                    map.put(o, BufferedMorphiumWriterImpl.this.morphium.getARHelper().getId(o) == null);
                    ctx.insert(o);
                    BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(o.getClass());
                }
                BufferedMorphiumWriterImpl.this.morphium.firePostStore(map);
            }
        }, c, AsyncOperationType.WRITE);
    }

    @Override
    public <T> void updateUsingFields(final T ent, final String collection, AsyncOperationCallback<T> c, final String ... fields) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(ent.getClass(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                BufferedMorphiumWriterImpl.this.morphium.firePreUpdateEvent(ent.getClass(), MorphiumStorageListener.UpdateTypes.SET);
                Query<?> query = BufferedMorphiumWriterImpl.this.morphium.createQueryFor(ent.getClass()).f(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getIdFieldName(ent)).eq(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getId(ent));
                if (collection != null) {
                    query.setCollectionName(collection);
                }
                BulkRequestWrapper r = ctx.addFind(query);
                String[] flds = fields;
                if (flds.length == 0) {
                    flds = BufferedMorphiumWriterImpl.this.morphium.getARHelper().getAllFields(ent.getClass()).toArray(flds);
                }
                for (String f : flds) {
                    String fld = BufferedMorphiumWriterImpl.this.morphium.getARHelper().getFieldName(query.getType(), f);
                    r.set(fld, BufferedMorphiumWriterImpl.this.morphium.getARHelper().getValue(ent, f), false);
                }
                BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(ent.getClass());
                BufferedMorphiumWriterImpl.this.morphium.firePostUpdateEvent(ent.getClass(), MorphiumStorageListener.UpdateTypes.SET);
            }
        }, c, AsyncOperationType.UPDATE);
    }

    @Override
    public <T> void set(final T toSet, final String collection, final String field, final Object value, final boolean insertIfNotExists, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(toSet.getClass(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                BufferedMorphiumWriterImpl.this.morphium.firePreUpdateEvent(toSet.getClass(), MorphiumStorageListener.UpdateTypes.SET);
                Query<?> query = BufferedMorphiumWriterImpl.this.morphium.createQueryFor(toSet.getClass()).f(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getIdFieldName(toSet)).eq(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getId(toSet));
                if (collection != null) {
                    query.setCollectionName(collection);
                }
                BulkRequestWrapper wr = ctx.addFind(query);
                if (insertIfNotExists) {
                    wr = wr.upsert();
                }
                BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(toSet.getClass());
                String fld = BufferedMorphiumWriterImpl.this.morphium.getARHelper().getFieldName(query.getType(), field);
                wr.set(fld, value, multiple);
                BufferedMorphiumWriterImpl.this.morphium.firePostUpdateEvent(toSet.getClass(), MorphiumStorageListener.UpdateTypes.SET);
            }
        }, c, AsyncOperationType.SET);
    }

    @Override
    public <T> void set(final Query<T> query, final Map<String, Object> values, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                BufferedMorphiumWriterImpl.this.morphium.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.SET);
                BulkRequestWrapper wr = ctx.addFind(query);
                if (insertIfNotExist) {
                    wr = wr.upsert();
                }
                BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(query.getType());
                for (Map.Entry kv : values.entrySet()) {
                    String fld = BufferedMorphiumWriterImpl.this.morphium.getARHelper().getFieldName(query.getType(), kv.getKey().toString());
                    wr.set(fld, kv.getValue(), multiple);
                }
                BufferedMorphiumWriterImpl.this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.SET);
            }
        }, c, AsyncOperationType.SET);
    }

    @Override
    public <T> void inc(final Query<T> query, final Map<String, Number> fieldsToInc, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                BufferedMorphiumWriterImpl.this.morphium.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.INC);
                BulkRequestWrapper wr = ctx.addFind(query);
                if (insertIfNotExist) {
                    wr = wr.upsert();
                }
                BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(query.getType());
                for (Map.Entry kv : fieldsToInc.entrySet()) {
                    String fld = BufferedMorphiumWriterImpl.this.morphium.getARHelper().getFieldName(query.getType(), kv.getKey().toString());
                    wr.inc(fld, ((Double)kv.getValue()).intValue(), multiple);
                }
                BufferedMorphiumWriterImpl.this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.INC);
            }
        }, c, AsyncOperationType.INC);
    }

    @Override
    public <T> void inc(final Query<T> query, final String field, final Number amount, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                BulkRequestWrapper wr = ctx.addFind(query);
                BufferedMorphiumWriterImpl.this.morphium.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.INC);
                if (insertIfNotExist) {
                    wr = wr.upsert();
                }
                BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(query.getType());
                String fieldName = BufferedMorphiumWriterImpl.this.morphium.getARHelper().getFieldName(query.getType(), field);
                wr.inc(fieldName, amount, multiple);
                BufferedMorphiumWriterImpl.this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.INC);
            }
        }, c, AsyncOperationType.INC);
    }

    @Override
    public <T> void inc(final T obj, final String collection, final String field, final Number amount, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(obj.getClass(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                BufferedMorphiumWriterImpl.this.morphium.firePreUpdateEvent(obj.getClass(), MorphiumStorageListener.UpdateTypes.INC);
                Query<?> q = BufferedMorphiumWriterImpl.this.morphium.createQueryFor(obj.getClass()).f(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getIdFieldName(obj)).eq(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getId(obj));
                q.setCollectionName(collection);
                BulkRequestWrapper wr = ctx.addFind(q);
                BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(obj.getClass());
                String fld = BufferedMorphiumWriterImpl.this.morphium.getARHelper().getFieldName(obj.getClass(), field);
                wr.inc(fld, amount, false);
                BufferedMorphiumWriterImpl.this.morphium.firePostUpdateEvent(obj.getClass(), MorphiumStorageListener.UpdateTypes.INC);
            }
        }, c, AsyncOperationType.INC);
    }

    @Override
    public <T> void pop(final T obj, String collection, final String field, final boolean first, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(obj.getClass(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                BufferedMorphiumWriterImpl.this.morphium.firePreUpdateEvent(obj.getClass(), MorphiumStorageListener.UpdateTypes.POP);
                Query<?> q = BufferedMorphiumWriterImpl.this.morphium.createQueryFor(obj.getClass()).f(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getIdFieldName(obj)).eq(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getId(obj));
                BulkRequestWrapper wr = ctx.addFind(q);
                BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(obj.getClass());
                String fld = BufferedMorphiumWriterImpl.this.morphium.getARHelper().getFieldName(obj.getClass(), field);
                wr.pop(fld, first, false);
                BufferedMorphiumWriterImpl.this.morphium.firePostUpdateEvent(obj.getClass(), MorphiumStorageListener.UpdateTypes.POP);
            }
        }, c, AsyncOperationType.WRITE);
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        this.directWriter = m.getConfig().getWriter();
        this.housekeeping = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (BufferedMorphiumWriterImpl.this.running) {
                    try {
                        ArrayList<Class> localBuffer = new ArrayList<Class>();
                        Map map = BufferedMorphiumWriterImpl.this.opLog;
                        synchronized (map) {
                            for (Class clz : BufferedMorphiumWriterImpl.this.opLog.keySet()) {
                                localBuffer.add(clz);
                            }
                            for (Class clz : localBuffer) {
                                if (BufferedMorphiumWriterImpl.this.opLog.get(clz) == null || ((List)BufferedMorphiumWriterImpl.this.opLog.get(clz)).size() == 0) continue;
                                WriteBuffer w = BufferedMorphiumWriterImpl.this.morphium.getARHelper().getAnnotationFromHierarchy(clz, WriteBuffer.class);
                                int size = 0;
                                int timeout = BufferedMorphiumWriterImpl.this.morphium.getConfig().getWriteBufferTime();
                                if (w != null) {
                                    size = w.size();
                                    timeout = w.timeout();
                                }
                                if (timeout == -1 && size > 0 && ((List)BufferedMorphiumWriterImpl.this.opLog.get(clz)).size() < size || BufferedMorphiumWriterImpl.this.lastRun.get(clz) != null && System.currentTimeMillis() - (Long)BufferedMorphiumWriterImpl.this.lastRun.get(clz) < (long)timeout) continue;
                                BufferedMorphiumWriterImpl.this.lastRun.put(clz, System.currentTimeMillis());
                                List localQueue = (List)BufferedMorphiumWriterImpl.this.opLog.get(clz);
                                BufferedMorphiumWriterImpl.this.opLog.put(clz, new Vector());
                                ((List)BufferedMorphiumWriterImpl.this.opLog.get(clz)).addAll(BufferedMorphiumWriterImpl.this.flushToQueue(localQueue));
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.info("Got exception during write buffer handling!", e);
                    }
                    try {
                        if (BufferedMorphiumWriterImpl.this.morphium != null) {
                            if (BufferedMorphiumWriterImpl.this.morphium.getConfig() == null) {
                                BufferedMorphiumWriterImpl.this.running = false;
                                break;
                            }
                            Thread.sleep(BufferedMorphiumWriterImpl.this.morphium.getConfig().getWriteBufferTimeGranularity());
                            continue;
                        }
                        logger.warn("Morphium not set - assuming timeout of 1sec");
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.housekeeping.setDaemon(true);
        this.housekeeping.start();
        m.addShutdownListener(new ShutdownListener(){

            @Override
            public void onShutdown(Morphium m) {
                BufferedMorphiumWriterImpl.this.running = false;
                try {
                    long start = System.currentTimeMillis();
                    while (BufferedMorphiumWriterImpl.this.housekeeping.isAlive()) {
                        if (System.currentTimeMillis() - start > 1000L) {
                            BufferedMorphiumWriterImpl.this.housekeeping.stop();
                            break;
                        }
                        Thread.sleep(50L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public <T> void remove(List<T> lst, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        for (final T obj : lst) {
            this.addToWriteQueue(obj.getClass(), new BufferedBulkOp(){

                @Override
                public void exec(BulkOperationContext ctx) {
                    Query<?> q = BufferedMorphiumWriterImpl.this.morphium.createQueryFor(obj.getClass()).f(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getIdFieldName(obj)).eq(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getId(obj));
                    BufferedMorphiumWriterImpl.this.morphium.firePreRemoveEvent(q);
                    BulkRequestWrapper r = ctx.addFind(q);
                    r.remove();
                    BufferedMorphiumWriterImpl.this.morphium.firePostRemoveEvent(q);
                }
            }, c, AsyncOperationType.REMOVE);
        }
    }

    @Override
    public <T> void remove(final T o, String collection, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(o.getClass(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                Query<?> q = BufferedMorphiumWriterImpl.this.morphium.createQueryFor(o.getClass()).f(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getIdFieldName(o)).eq(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getId(o));
                BufferedMorphiumWriterImpl.this.morphium.firePreRemoveEvent(q);
                BulkRequestWrapper r = ctx.addFind(q);
                r.remove();
                BufferedMorphiumWriterImpl.this.morphium.firePostRemoveEvent(q);
            }
        }, c, AsyncOperationType.REMOVE);
    }

    @Override
    public <T> void remove(final Query<T> q, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(q.getType(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                BulkRequestWrapper r = ctx.addFind(q);
                BufferedMorphiumWriterImpl.this.morphium.firePreRemoveEvent(q);
                BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(q.getType());
                r.remove();
                BufferedMorphiumWriterImpl.this.morphium.firePostRemoveEvent(q);
            }
        }, c, AsyncOperationType.REMOVE);
    }

    @Override
    public <T> void pushPull(final boolean push, final Query<T> q, final String field, final Object value, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(q.getType(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                BulkRequestWrapper r = ctx.addFind(q);
                if (insertIfNotExist) {
                    r = r.upsert();
                }
                BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(q.getType());
                String fld = BufferedMorphiumWriterImpl.this.morphium.getARHelper().getFieldName(q.getType(), field);
                if (push) {
                    BufferedMorphiumWriterImpl.this.morphium.firePreUpdateEvent(q.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
                    r.push(fld, multiple, value);
                    BufferedMorphiumWriterImpl.this.morphium.firePostUpdateEvent(q.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
                } else {
                    BufferedMorphiumWriterImpl.this.morphium.firePreUpdateEvent(q.getType(), MorphiumStorageListener.UpdateTypes.PULL);
                    r.pull(fld, multiple, value);
                    BufferedMorphiumWriterImpl.this.morphium.firePostUpdateEvent(q.getType(), MorphiumStorageListener.UpdateTypes.PULL);
                }
            }
        }, c, push ? AsyncOperationType.PUSH : AsyncOperationType.PULL);
    }

    @Override
    public <T> void pushPullAll(final boolean push, final Query<T> q, final String field, final List<?> value, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(q.getType(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                BulkRequestWrapper r = ctx.addFind(q);
                if (insertIfNotExist) {
                    r = r.upsert();
                }
                BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(q.getType());
                String fld = BufferedMorphiumWriterImpl.this.morphium.getARHelper().getFieldName(q.getType(), field);
                if (push) {
                    BufferedMorphiumWriterImpl.this.morphium.firePreUpdateEvent(q.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
                    for (Object o : value) {
                        r.push(fld, multiple, o);
                    }
                    BufferedMorphiumWriterImpl.this.morphium.firePostUpdateEvent(q.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
                } else {
                    BufferedMorphiumWriterImpl.this.morphium.firePreUpdateEvent(q.getType(), MorphiumStorageListener.UpdateTypes.PULL);
                    for (Object o : value) {
                        r.pull(fld, multiple, o);
                    }
                    BufferedMorphiumWriterImpl.this.morphium.firePostUpdateEvent(q.getType(), MorphiumStorageListener.UpdateTypes.PULL);
                }
            }
        }, c, push ? AsyncOperationType.PUSH : AsyncOperationType.PULL);
    }

    @Override
    public <T> void unset(final T obj, final String collection, final String field, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(obj.getClass(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                Query<?> q = BufferedMorphiumWriterImpl.this.morphium.createQueryFor(obj.getClass()).f(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getIdFieldName(obj)).eq(BufferedMorphiumWriterImpl.this.morphium.getARHelper().getId(obj));
                if (collection != null) {
                    q.setCollectionName(collection);
                }
                BulkRequestWrapper wr = ctx.addFind(q);
                BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(obj.getClass());
                String fld = BufferedMorphiumWriterImpl.this.morphium.getARHelper().getFieldName(obj.getClass(), field);
                wr.unset(fld, false);
            }
        }, c, AsyncOperationType.UNSET);
    }

    @Override
    public <T> void unset(final Query<T> query, final String field, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                BufferedMorphiumWriterImpl.this.morphium.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.UNSET);
                BulkRequestWrapper wr = ctx.addFind(query);
                String fld = BufferedMorphiumWriterImpl.this.morphium.getARHelper().getFieldName(query.getType(), field);
                wr.unset(fld, multiple);
                BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(query.getType());
                BufferedMorphiumWriterImpl.this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.UNSET);
            }
        }, c, AsyncOperationType.UNSET);
    }

    @Override
    public <T> void unset(final Query<T> query, AsyncOperationCallback<T> c, final boolean multiple, final String ... fields) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                BufferedMorphiumWriterImpl.this.morphium.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.UNSET);
                BulkRequestWrapper wr = ctx.addFind(query);
                for (String f : fields) {
                    String fld = BufferedMorphiumWriterImpl.this.morphium.getARHelper().getFieldName(query.getType(), f);
                    wr.unset(fld, multiple);
                }
                BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(query.getType());
                BufferedMorphiumWriterImpl.this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.UNSET);
            }
        }, c, AsyncOperationType.UNSET);
    }

    @Override
    public <T> void unset(final Query<T> query, AsyncOperationCallback<T> c, final boolean multiple, final Enum ... fields) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                BufferedMorphiumWriterImpl.this.morphium.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.UNSET);
                BulkRequestWrapper wr = ctx.addFind(query);
                for (Enum f : fields) {
                    wr.unset(f.name(), multiple);
                }
                BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(query.getType());
                BufferedMorphiumWriterImpl.this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.UNSET);
            }
        }, c, AsyncOperationType.UNSET);
    }

    @Override
    public <T> void dropCollection(final Class<T> cls, final String collection, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(cls, new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                BufferedMorphiumWriterImpl.this.directWriter.dropCollection(cls, collection, callback);
                BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
            }
        }, c, AsyncOperationType.REMOVE);
    }

    public <T> void ensureIndex(Class<T> cls, String collection, Map<String, Object> index, AsyncOperationCallback<T> c) {
        this.ensureIndex(cls, collection, index, null, c);
    }

    @Override
    public <T> void ensureIndex(final Class<T> cls, final String collection, final Map<String, Object> index, final Map<String, Object> options, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(cls, new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                BufferedMorphiumWriterImpl.this.directWriter.ensureIndex(cls, collection, index, options, callback);
            }
        }, c, AsyncOperationType.ENSURE_INDICES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeBufferCount() {
        int cnt = 0;
        Map<Class<?>, List<WriteBufferEntry>> map = this.opLog;
        synchronized (map) {
            for (List<WriteBufferEntry> lst : this.opLog.values()) {
                cnt += lst.size();
            }
        }
        return cnt;
    }

    @Override
    public <T> void store(final List<T> lst, String collectionName, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        if (lst == null || lst.size() == 0) {
            return;
        }
        this.addToWriteQueue(lst.get(0).getClass(), new BufferedBulkOp(){

            @Override
            public void exec(BulkOperationContext ctx) {
                HashMap<Object, Boolean> map = new HashMap<Object, Boolean>();
                for (Object o : lst) {
                    ctx.insert(o);
                }
                BufferedMorphiumWriterImpl.this.morphium.firePreStoreEvent(map);
                for (Object o : lst) {
                    map.put(o, BufferedMorphiumWriterImpl.this.morphium.getARHelper().getId(o) == null);
                    BufferedMorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(o.getClass());
                }
                BufferedMorphiumWriterImpl.this.morphium.firePostStore(map);
            }
        }, c, AsyncOperationType.WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        ArrayList localBuffer = new ArrayList();
        Map<Class<?>, List<WriteBufferEntry>> map = this.opLog;
        synchronized (map) {
            for (Class<Object> clz : this.opLog.keySet()) {
                localBuffer.add(clz);
            }
            for (Class<Object> clz : localBuffer) {
                if (this.opLog.get(clz) == null || this.opLog.get(clz).size() == 0) continue;
                this.opLog.get(clz).addAll(this.flushToQueue(this.opLog.get(clz)));
            }
        }
    }

    protected void finalize() throws Throwable {
        this.onShutdown(this.morphium);
        super.finalize();
    }

    @Override
    public void onShutdown(Morphium m) {
        logger.info("Stopping housekeeping thread");
        this.running = false;
        try {
            Thread.sleep(this.morphium.getConfig().getWriteBufferTimeGranularity());
            if (this.housekeeping != null) {
                this.housekeeping.stop();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setMaximumQueingTries(int n) {
        this.directWriter.setMaximumQueingTries(n);
    }

    @Override
    public void setPauseBetweenTries(int p) {
        this.directWriter.setPauseBetweenTries(p);
    }

    private static interface BufferedBulkOp {
        public void exec(BulkOperationContext var1);
    }

    private class AsyncOpAdapter<T>
    implements AsyncOperationCallback<T> {
        private AsyncOpAdapter() {
        }

        @Override
        public void onOperationSucceeded(AsyncOperationType type, Query<T> q, long duration, List<T> result, T entity, Object ... param) {
        }

        @Override
        public void onOperationError(AsyncOperationType type, Query<T> q, long duration, String error, Throwable t, T entity, Object ... param) {
        }
    }

    private class WriteBufferEntry {
        private BufferedBulkOp toRun;
        private AsyncOperationCallback cb;
        private AsyncOperationType type;
        private long timestamp;
        private Class entityType;

        private WriteBufferEntry(Class entitiyType, BufferedBulkOp toRun, long timestamp, AsyncOperationCallback c, AsyncOperationType t) {
            this.toRun = toRun;
            this.timestamp = timestamp;
            this.cb = c;
            this.type = t;
            this.entityType = entitiyType;
        }

        public Class getEntityType() {
            return this.entityType;
        }

        public void setEntityType(Class entityType) {
            this.entityType = entityType;
        }

        public AsyncOperationType getType() {
            return this.type;
        }

        public void setType(AsyncOperationType type) {
            this.type = type;
        }

        public AsyncOperationCallback getCb() {
            return this.cb;
        }

        public void setCb(AsyncOperationCallback cb) {
            this.cb = cb;
        }

        public BufferedBulkOp getToRun() {
            return this.toRun;
        }

        public void setToRun(BufferedBulkOp toRun) {
            this.toRun = toRun;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

