/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.bulk;

import com.mongodb.BulkWriteOperation;
import com.mongodb.BulkWriteResult;
import com.mongodb.BulkWriteUpsert;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.WriteAccessType;
import de.caluga.morphium.bulk.BulkRequestWrapper;
import de.caluga.morphium.query.Query;
import java.util.ArrayList;
import java.util.List;

public class BulkOperationContext {
    private Morphium morphium;
    private boolean ordered;
    private BulkWriteOperation bulk = null;
    private List<BulkRequestWrapper> requests;

    public BulkOperationContext(Morphium m, boolean ordered) {
        this.morphium = m;
        this.ordered = ordered;
        this.requests = new ArrayList<BulkRequestWrapper>();
    }

    public <T> void insert(T o) {
        if (this.bulk == null) {
            this.bulk = this.ordered ? this.morphium.getDatabase().getCollection(this.morphium.getMapper().getCollectionName(o.getClass())).initializeOrderedBulkOperation() : this.morphium.getDatabase().getCollection(this.morphium.getMapper().getCollectionName(o.getClass())).initializeUnorderedBulkOperation();
        }
        this.bulk.insert(this.morphium.getMapper().marshall(o));
    }

    public <T> BulkRequestWrapper addFind(Query<T> q) {
        if (this.bulk == null) {
            this.bulk = this.ordered ? this.morphium.getDatabase().getCollection(this.morphium.getMapper().getCollectionName(q.getType())).initializeOrderedBulkOperation() : this.morphium.getDatabase().getCollection(this.morphium.getMapper().getCollectionName(q.getType())).initializeUnorderedBulkOperation();
        }
        BulkRequestWrapper w = new BulkRequestWrapper(this.bulk.find(q.toQueryObject()), this.morphium, q);
        this.requests.add(w);
        return w;
    }

    public BulkWriteResult execute() {
        if (this.bulk == null) {
            return new BulkWriteResult(){

                public boolean isAcknowledged() {
                    return false;
                }

                public int getInsertedCount() {
                    return 0;
                }

                public int getMatchedCount() {
                    return 0;
                }

                public int getRemovedCount() {
                    return 0;
                }

                public boolean isModifiedCountAvailable() {
                    return false;
                }

                public int getModifiedCount() {
                    return 0;
                }

                public List<BulkWriteUpsert> getUpserts() {
                    return null;
                }
            };
        }
        for (BulkRequestWrapper w : this.requests) {
            w.preExec();
        }
        long dur = System.currentTimeMillis();
        BulkWriteResult res = this.bulk.execute();
        dur = System.currentTimeMillis() - dur;
        for (BulkRequestWrapper w : this.requests) {
            w.postExec();
        }
        for (BulkRequestWrapper w : this.requests) {
            this.morphium.fireProfilingWriteEvent(w.getQuery().getType(), this, dur, false, WriteAccessType.BULK_UPDATE);
        }
        return res;
    }
}

