/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.DefaultNameProvider;
import de.caluga.morphium.NameProvider;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class EntityCache {
    private Logger log = Logger.getLogger(EntityCache.class);
    private volatile Map<String, Class> entityByTypeId = new Hashtable<String, Class>();
    private volatile Vector<Class> enumlist = new Vector();
    private volatile Hashtable<Class<?>, NameProvider> nameProviders = new Hashtable();
    private volatile AnnotationAndReflectionHelper hlp = new AnnotationAndReflectionHelper(true);
    private volatile NameProvider defaultNameProvider = new DefaultNameProvider();
    private List<String> paths = new ArrayList<String>();

    public EntityCache() {
        String classpath = System.getProperty("java.class.path");
        String[] p = classpath.split(System.getProperty("path.separator"));
        this.paths.addAll(Arrays.asList(p));
        String javaHome = System.getProperty("java.home");
        this.paths.add(javaHome + File.separator + "lib");
        this.updateClasses();
    }

    public void addClassPathElement(String el) {
        this.paths.add(el);
        this.traverseClassesInDir(new File(el), new File(el));
    }

    public Map<String, Class> getEntityByTypeId() {
        return this.entityByTypeId;
    }

    public Vector<Class> getEnumlist() {
        return this.enumlist;
    }

    public Hashtable<Class<?>, NameProvider> getNameProviders() {
        return this.nameProviders;
    }

    private void registerEntity(String id, Class cls) {
        if (this.entityByTypeId.get(id) != null) {
            this.entityByTypeId.put(cls.getName(), cls);
            this.log.warn((Object)"ID not unique - maybe inherited");
        } else {
            this.entityByTypeId.put(id, cls);
        }
    }

    private void gotClassName(String className) {
        if (className.startsWith("com.sun")) {
            return;
        }
        if (className.startsWith("sun.")) {
            return;
        }
        if (className.startsWith("java.")) {
            return;
        }
        if (className.startsWith("javax.")) {
            return;
        }
        if (className.startsWith("javafx.")) {
            return;
        }
        if (className.startsWith("org.apache.")) {
            return;
        }
        if (className.startsWith("org.junit.")) {
            return;
        }
        if (className.startsWith("net.sf.")) {
            return;
        }
        if (className.startsWith("com.javafx")) {
            return;
        }
        if (className.startsWith("com.apple")) {
            return;
        }
        if (className.startsWith("apple")) {
            return;
        }
        if (className.startsWith("com.oracle")) {
            return;
        }
        if (className.startsWith("jdk.internal.")) {
            return;
        }
        if (className.startsWith("netscape.")) {
            return;
        }
        if (className.startsWith("junit.")) {
            return;
        }
        try {
            Class<?> cls = Class.forName(className);
            Entity ent = this.hlp.getAnnotationFromHierarchy(cls, Entity.class);
            Embedded emb = this.hlp.getAnnotationFromHierarchy(cls, Embedded.class);
            if (ent != null) {
                if (cls.isAnnotationPresent(Entity.class)) {
                    if (ent.typeId().equals(".")) {
                        this.registerEntity(className, cls);
                    } else {
                        this.registerEntity(ent.typeId(), cls);
                    }
                    if (ent.nameProvider() != null) {
                        try {
                            this.nameProviders.put(cls, ent.nameProvider().newInstance());
                        }
                        catch (Exception e) {
                            this.log.fatal((Object)("Error instanciating Nameprovider: " + ent.nameProvider().getName() + " for type " + cls.getName()), (Throwable)e);
                        }
                    } else {
                        this.nameProviders.put(cls, this.defaultNameProvider);
                    }
                } else {
                    this.registerEntity(className, cls);
                }
            } else if (emb != null) {
                if (cls.isAnnotationPresent(Embedded.class)) {
                    if (emb.typeId().equals(".")) {
                        this.registerEntity(className, cls);
                    } else {
                        this.registerEntity(emb.typeId(), cls);
                    }
                } else {
                    this.registerEntity(className, cls);
                }
            } else if (cls.isEnum()) {
                this.enumlist.add(cls);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void updateClasses() {
        this.nameProviders.clear();
        this.entityByTypeId.clear();
        this.enumlist.clear();
        for (String path : this.paths) {
            File file = new File(path);
            if (!file.exists()) continue;
            this.traverseClassesInDir(file, file);
        }
    }

    private void traverseClassesInDir(File root, File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.traverseClassesInDir(root, child);
            }
        } else if (file.getName().toLowerCase().endsWith(".jar")) {
            JarFile jar = null;
            try {
                jar = new JarFile(file);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (jar != null) {
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    int extIndex = name.lastIndexOf(".class");
                    if (extIndex <= 0) continue;
                    this.gotClassName(name.substring(0, extIndex).replace("/", "."));
                }
            }
        } else if (file.getName().toLowerCase().endsWith(".class")) {
            StringBuffer sb = new StringBuffer();
            String fileName = file.getName();
            sb.append(fileName.substring(0, fileName.lastIndexOf(".class")));
            for (file = file.getParentFile(); file != null && !file.equals(root); file = file.getParentFile()) {
                sb.insert(0, '.').insert(0, file.getName());
            }
            this.gotClassName(sb.toString());
        }
    }
}

