/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.cache;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.cache.CacheElement;
import de.caluga.morphium.cache.CacheListener;
import de.caluga.morphium.cache.CacheObject;
import de.caluga.morphium.cache.MorphiumCache;
import de.caluga.morphium.query.Query;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MorphiumCacheImpl
implements MorphiumCache {
    private Hashtable<Class<?>, Hashtable<String, CacheElement>> cache;
    private Hashtable<Class<?>, Hashtable<Object, Object>> idCache;
    private AnnotationAndReflectionHelper annotationHelper = new AnnotationAndReflectionHelper();
    private Vector<CacheListener> cacheListeners;
    private Logger logger = Logger.getLogger(MorphiumCacheImpl.class);

    public MorphiumCacheImpl() {
        this.cache = new Hashtable();
        this.idCache = new Hashtable();
        this.cacheListeners = new Vector();
    }

    @Override
    public void addCacheListener(CacheListener cl) {
        this.cacheListeners.add(cl);
    }

    @Override
    public void removeCacheListener(CacheListener cl) {
        this.cacheListeners.remove(cl);
    }

    @Override
    public <T> void addToCache(String k, Class<? extends T> type, List<T> ret) {
        if (k == null) {
            return;
        }
        CacheObject<Object> co = new CacheObject<Object>();
        co.setKey(k);
        co.setType(type);
        co.setResult(ret);
        for (CacheListener cacheListener : this.cacheListeners) {
            co = cacheListener.wouldAddToCache(co);
            if (co != null) continue;
            return;
        }
        if (!k.endsWith("idlist")) {
            Hashtable<Class<?>, Hashtable<Object, Object>> idCacheClone = this.cloneIdCache();
            for (T record : ret) {
                if (idCacheClone.get(type) == null) {
                    idCacheClone.put(type, new Hashtable());
                }
                idCacheClone.get(type).put(this.annotationHelper.getId(record), record);
            }
            this.setIdCache(idCacheClone);
        }
        CacheElement<T> e = new CacheElement<T>(ret);
        e.setLru(System.currentTimeMillis());
        Hashtable hashtable = (Hashtable)this.cache.clone();
        if (hashtable.get(type) == null) {
            hashtable.put(type, new Hashtable());
        }
        ((Hashtable)hashtable.get(type)).put(k, e);
        this.cache = hashtable;
    }

    @Override
    public void clearCacheIfNecessary(Class cls) {
        Cache c = this.annotationHelper.getAnnotationFromHierarchy(cls, Cache.class);
        if (c != null && c.clearOnWrite()) {
            this.clearCachefor(cls);
        }
    }

    @Override
    public boolean isCached(Class<?> type, String k) {
        Cache c = this.annotationHelper.getAnnotationFromHierarchy(type, Cache.class);
        if (c != null) {
            if (!c.readCache()) {
                return false;
            }
        } else {
            return false;
        }
        Hashtable<Class<?>, Hashtable<String, CacheElement>> snapshotCache = this.cache;
        try {
            return snapshotCache.get(type) != null && snapshotCache.get(type).get(k) != null && snapshotCache.get(type).get(k).getFound() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public <T> List<T> getFromCache(Class<? extends T> type, String k) {
        Hashtable<Class<?>, Hashtable<String, CacheElement>> snapshotCache = this.cache;
        if (snapshotCache.get(type) == null || snapshotCache.get(type).get(k) == null) {
            return null;
        }
        try {
            CacheElement cacheElement = snapshotCache.get(type).get(k);
            cacheElement.setLru(System.currentTimeMillis());
            return cacheElement.getFound();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Hashtable<Class<?>, Hashtable<String, CacheElement>> cloneCache() {
        return (Hashtable)this.cache.clone();
    }

    @Override
    public Hashtable<Class<?>, Hashtable<Object, Object>> cloneIdCache() {
        return (Hashtable)this.idCache.clone();
    }

    @Override
    public <T> T getFromIDCache(Class<? extends T> type, Object id) {
        if (this.idCache.get(type) != null) {
            return (T)this.idCache.get(type).get(id);
        }
        return null;
    }

    @Override
    public String getCacheKey(DBObject qo, Map<String, Integer> sort, String collection, int skip, int limit) {
        StringBuffer b = new StringBuffer();
        b.append(qo.toString());
        b.append(" c:" + collection);
        b.append(" l:");
        b.append(limit);
        b.append(" s:");
        b.append(skip);
        if (sort != null) {
            b.append(" sort:");
            b.append(new BasicDBObject(sort).toString());
        }
        return b.toString();
    }

    @Override
    public String getCacheKey(Query q) {
        return this.getCacheKey(q.toQueryObject(), q.getSort(), q.getCollectionName(), q.getSkip(), q.getLimit());
    }

    @Override
    public void clearCachefor(Class<?> cls) {
        for (CacheListener cl : this.cacheListeners) {
            if (cl.wouldClearCache(cls)) continue;
            this.logger.info((Object)("Not clearing cache due to veto of cache listener " + cl.getClass().getName()));
            return;
        }
        if (this.cache.get(cls) != null) {
            this.cache.get(cls).clear();
        }
        if (this.idCache.get(cls) != null) {
            this.idCache.get(cls).clear();
        }
    }

    @Override
    public void resetCache() {
        this.setCache(new Hashtable());
    }

    @Override
    public void setCache(Hashtable<Class<?>, Hashtable<String, CacheElement>> cache) {
        this.cache = cache;
    }

    @Override
    public void removeEntryFromCache(Class cls, Object id) {
        Hashtable<Class<?>, Hashtable<String, CacheElement>> c = this.cloneCache();
        Hashtable<Class<?>, Hashtable<Object, Object>> idc = this.cloneIdCache();
        if (idc.get(cls) != null && idc.get(cls).get(id) != null) {
            for (CacheListener cl : this.cacheListeners) {
                if (cl.wouldRemoveEntryFromCache(cls, id, idc.get(cls).get(id))) continue;
                this.logger.info((Object)("Not removing from cache due to veto from CacheListener " + cl.getClass().getName()));
                return;
            }
        }
        idc.get(cls).remove(id);
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : c.get(cls).keySet()) {
            for (Object el : c.get(cls).get(key).getFound()) {
                Object lid = this.annotationHelper.getId(el);
                if (lid == null) {
                    this.logger.error((Object)"Null id in CACHE?");
                    toRemove.add(key);
                }
                if (lid == null || !lid.equals(id)) continue;
                toRemove.add(key);
            }
        }
        for (String k : toRemove) {
            c.get(cls).remove(k);
        }
        this.setCache(c);
        this.setIdCache(idc);
    }

    @Override
    public void setIdCache(Hashtable<Class<?>, Hashtable<Object, Object>> c) {
        this.idCache = c;
    }
}

