/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import de.caluga.morphium.aggregation.Aggregator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bson.BSONObject;

public class Group<T, R> {
    private Aggregator<T, R> aggregator;
    private BasicDBObject id;
    private List<BasicDBObject> operators = new ArrayList<BasicDBObject>();

    public Group(Aggregator<T, R> ag, Map<String, String> idSubObject) {
        this.aggregator = ag;
        this.id = new BasicDBObject("_id", (Object)new BasicDBObject(idSubObject));
    }

    public Group(Aggregator<T, R> ag, String id) {
        this.aggregator = ag;
        this.id = new BasicDBObject("_id", (Object)id);
    }

    public Group(Aggregator<T, R> ag, BasicDBObject id) {
        this.aggregator = ag;
        this.id = new BasicDBObject("_id", (Object)new BasicDBObject((Map)id));
    }

    public Group<T, R> addToSet(BasicDBObject param) {
        BasicDBObject o = new BasicDBObject("$addToSet", (Object)param);
        this.operators.add(o);
        return this;
    }

    public Group<T, R> first(String name, Object p) {
        BasicDBObject o = new BasicDBObject(name, (Object)new BasicDBObject("$first", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> last(String name, Object p) {
        BasicDBObject o = new BasicDBObject(name, (Object)new BasicDBObject("$last", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> max(String name, Object p) {
        BasicDBObject o = new BasicDBObject(name, (Object)new BasicDBObject("$max", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> min(String name, Object p) {
        BasicDBObject o = new BasicDBObject(name, (Object)new BasicDBObject("$min", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> avg(String name, Object p) {
        BasicDBObject o = new BasicDBObject(name, (Object)new BasicDBObject("$avg", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> push(String name, Object p) {
        BasicDBObject o = new BasicDBObject(name, (Object)new BasicDBObject("$push", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> sum(String name, int p) {
        return this.sum(name, (Object)p);
    }

    public Group<T, R> sum(String name, long p) {
        return this.sum(name, (Object)p);
    }

    public Group<T, R> sum(String name, Object p) {
        BasicDBObject o = new BasicDBObject(name, (Object)new BasicDBObject("$sum", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> sum(String name, String p) {
        return this.sum(name, (Object)p);
    }

    public Aggregator<T, R> end() {
        BasicDBObject params = new BasicDBObject();
        params.putAll((BSONObject)this.id);
        for (BasicDBObject o : this.operators) {
            params.putAll((BSONObject)o);
        }
        BasicDBObject obj = new BasicDBObject("$group", (Object)params);
        this.aggregator.addOperator((DBObject)obj);
        return this.aggregator;
    }

    public List<BasicDBObject> getOperators() {
        return this.operators;
    }
}

