/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.writer;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.PartiallyUpdateable;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.WriteAccessType;
import de.caluga.morphium.annotations.CreationTime;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.LastChange;
import de.caluga.morphium.annotations.PartialUpdate;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.writer.MorphiumWriter;
import de.caluga.morphium.writer.WriterTask;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.bson.types.ObjectId;

public class MorphiumWriterImpl
implements MorphiumWriter {
    private static Logger logger = Logger.getLogger(MorphiumWriterImpl.class);
    private Morphium morphium;
    private AnnotationAndReflectionHelper annotationHelper = new AnnotationAndReflectionHelper();
    private int maximumRetries = 10;
    private int pause = 250;
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    @Override
    public void setMaximumQueingTries(int n) {
        this.maximumRetries = n;
    }

    @Override
    public void setPauseBetweenTries(int p) {
        this.pause = p;
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        if (m != null) {
            this.annotationHelper = this.morphium.getARHelper();
            this.executor.setCorePoolSize(m.getConfig().getMaxConnections() / 2);
            this.executor.setMaximumPoolSize((int)((double)(m.getConfig().getMaxConnections() * m.getConfig().getBlockingThreadsMultiplier()) * 0.9));
        } else {
            this.annotationHelper = new AnnotationAndReflectionHelper();
        }
    }

    @Override
    public <T> void store(final T obj, final String collection, AsyncOperationCallback<T> callback) {
        if (obj instanceof List) {
            this.store((List)obj, callback);
            return;
        }
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    Cache ch;
                    boolean isNew;
                    Object o;
                    block29: {
                        o = obj;
                        Class<?> type = MorphiumWriterImpl.this.annotationHelper.getRealClass(o.getClass());
                        if (!MorphiumWriterImpl.this.annotationHelper.isAnnotationPresentInHierarchy(type, Entity.class)) {
                            throw new RuntimeException("Not an entity: " + type.getSimpleName() + " Storing not possible!");
                        }
                        MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                        Object id = MorphiumWriterImpl.this.annotationHelper.getId(o);
                        if (MorphiumWriterImpl.this.annotationHelper.isAnnotationPresentInHierarchy(type, PartialUpdate.class) && o instanceof PartiallyUpdateable) {
                            MorphiumWriterImpl.this.updateUsingFields(o, collection, this.callback, ((PartiallyUpdateable)o).getAlteredFields().toArray(new String[((PartiallyUpdateable)o).getAlteredFields().size()]));
                            ((PartiallyUpdateable)o).clearAlteredFields();
                            return;
                        }
                        o = MorphiumWriterImpl.this.annotationHelper.getRealObject(o);
                        if (o == null) {
                            logger.warn((Object)"Illegal Reference? - cannot store Lazy-Loaded / Partial Update Proxy without delegate!");
                            return;
                        }
                        isNew = id == null;
                        Object reread = null;
                        CreationTime creationTime = MorphiumWriterImpl.this.annotationHelper.getAnnotationFromHierarchy(type, CreationTime.class);
                        if (id != null && (MorphiumWriterImpl.this.morphium.getConfig().isCheckForNew() || creationTime != null && creationTime.checkForNew()) && !MorphiumWriterImpl.this.annotationHelper.getIdField(o).getType().equals(ObjectId.class)) {
                            reread = MorphiumWriterImpl.this.morphium.findById(o.getClass(), id);
                            isNew = reread == null;
                        }
                        isNew = MorphiumWriterImpl.this.setAutoValues(o, type, id, isNew, reread);
                        MorphiumWriterImpl.this.morphium.firePreStoreEvent(o, isNew);
                        DBObject marshall = MorphiumWriterImpl.this.morphium.getMapper().marshall(o);
                        String coll = collection;
                        if (coll == null) {
                            coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(type);
                        }
                        for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                            try {
                                if (MorphiumWriterImpl.this.morphium.getDatabase().collectionExists(coll)) break;
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Collection " + coll + " does not exist - ensuring indices"));
                                }
                                MorphiumWriterImpl.this.morphium.ensureIndicesFor(type, coll, this.callback);
                                break;
                            }
                            catch (Throwable t) {
                                MorphiumWriterImpl.this.morphium.handleNetworkError(i, t);
                                continue;
                            }
                        }
                        WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(type);
                        WriteResult result = null;
                        for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                            try {
                                result = wc != null ? MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).save(marshall, wc) : MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).save(marshall);
                                if (result.getLastError().ok()) break;
                                logger.error((Object)("Writing failed: " + result.getLastError().getErrorMessage()));
                                break;
                            }
                            catch (Throwable t) {
                                MorphiumWriterImpl.this.morphium.handleNetworkError(i, t);
                                continue;
                            }
                        }
                        long dur = System.currentTimeMillis() - start;
                        MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(o.getClass(), marshall, dur, true, WriteAccessType.SINGLE_INSERT);
                        if (isNew) {
                            List<String> flds = MorphiumWriterImpl.this.annotationHelper.getFields(o.getClass(), Id.class);
                            if (flds == null) {
                                throw new RuntimeException("Object does not have an ID field!");
                            }
                            try {
                                Field fld = MorphiumWriterImpl.this.annotationHelper.getField(o.getClass(), flds.get(0));
                                if (fld.getType().equals(marshall.get("_id").getClass())) {
                                    fld.set(o, marshall.get("_id"));
                                    break block29;
                                }
                                logger.warn((Object)"got default generated key, but ID-Field is not of type ObjectID... trying string conversion");
                                if (fld.getType().equals(String.class)) {
                                    fld.set(o, ((ObjectId)marshall.get("_id")).toString());
                                    break block29;
                                }
                                throw new IllegalArgumentException("cannot convert ID for given object - id type is: " + fld.getType().getName() + "! Please set ID before write");
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    if ((ch = MorphiumWriterImpl.this.annotationHelper.getAnnotationFromHierarchy(o.getClass(), Cache.class)) != null && ch.clearOnWrite()) {
                        MorphiumWriterImpl.this.morphium.clearCachefor(o.getClass());
                    }
                    MorphiumWriterImpl.this.morphium.firePostStoreEvent(o, isNew);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.WRITE, null, System.currentTimeMillis() - start, null, obj, new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException && e.getClass().getName().equals("javax.validation.ConstraintViolationException")) {
                        try {
                            Method m = e.getClass().getMethod("getConstraintViolations", new Class[0]);
                            Set violations = (Set)m.invoke((Object)e, new Object[0]);
                            for (Object v : violations) {
                                m = v.getClass().getMethod("getMessage", new Class[0]);
                                String msg = (String)m.invoke(v, new Object[0]);
                                m = v.getClass().getMethod("getRootBean", new Class[0]);
                                Object bean = m.invoke(v, new Object[0]);
                                String s = MorphiumWriterImpl.this.morphium.toJsonString(bean);
                                String type = bean.getClass().getName();
                                m = v.getClass().getMethod("getInvalidValue", new Class[0]);
                                Object invalidValue = m.invoke(v, new Object[0]);
                                m = v.getClass().getMethod("getPropertyPath", new Class[0]);
                                Iterable pth = (Iterable)m.invoke(v, new Object[0]);
                                String path = "";
                                for (Object p : pth) {
                                    m = p.getClass().getMethod("getName", new Class[0]);
                                    String name = (String)m.invoke(p, new Object[0]);
                                    path = path + "." + name;
                                }
                                logger.error((Object)("Validation of " + type + " failed: " + msg + " - Invalid Value: " + invalidValue + " for path: " + path + "\n Tried to store: " + s));
                            }
                        }
                        catch (Exception e1) {
                            logger.fatal((Object)"Could not get more information about validation error ", (Throwable)e1);
                        }
                    }
                    if (this.callback == null) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.WRITE, null, System.currentTimeMillis() - start, e.getMessage(), e, obj, new Object[0]);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    private <T> boolean setAutoValues(T o, Class type, Object id, boolean aNew, Object reread) throws IllegalAccessException {
        if (this.annotationHelper.isAnnotationPresentInHierarchy(type, CreationTime.class)) {
            CreationTime ct = this.annotationHelper.getAnnotationFromHierarchy(o.getClass(), CreationTime.class);
            boolean checkForNew = ct.checkForNew() || this.morphium.getConfig().isCheckForNew();
            List<String> lst = this.annotationHelper.getFields(type, CreationTime.class);
            for (String fld : lst) {
                Field field = this.annotationHelper.getField(o.getClass(), fld);
                if (id != null) {
                    if (checkForNew && reread == null) {
                        reread = this.morphium.findById(o.getClass(), id);
                        aNew = reread == null;
                        continue;
                    }
                    if (reread == null) {
                        aNew = id instanceof ObjectId && id == null;
                        continue;
                    }
                    Object value = field.get(reread);
                    field.set(o, value);
                    aNew = false;
                    continue;
                }
                aNew = true;
            }
            if (aNew) {
                if (lst == null || lst.size() == 0) {
                    logger.error((Object)"Unable to store creation time as @CreationTime is missing");
                } else {
                    long now = System.currentTimeMillis();
                    for (String ctf : lst) {
                        Comparable<Long> val = null;
                        Field f = this.annotationHelper.getField(type, ctf);
                        if (f.getType().equals(Long.TYPE) || f.getType().equals(Long.class)) {
                            val = new Long(now);
                        } else if (f.getType().equals(Date.class)) {
                            val = new Date(now);
                        }
                        if (f == null) continue;
                        try {
                            f.set(o, val);
                        }
                        catch (IllegalAccessException e) {
                            logger.error((Object)"Could not set creation time", (Throwable)e);
                        }
                    }
                }
            }
        }
        if (this.annotationHelper.isAnnotationPresentInHierarchy(type, LastChange.class)) {
            List<String> lst = this.annotationHelper.getFields(type, LastChange.class);
            if (lst != null && lst.size() > 0) {
                long now = System.currentTimeMillis();
                for (String ctf : lst) {
                    Comparable<Long> val = null;
                    Field f = this.annotationHelper.getField(type, ctf);
                    if (f.getType().equals(Long.TYPE) || f.getType().equals(Long.class)) {
                        val = new Long(now);
                    } else if (f.getType().equals(Date.class)) {
                        val = new Date(now);
                    }
                    if (f == null) continue;
                    try {
                        f.set(o, val);
                    }
                    catch (IllegalAccessException e) {
                        logger.error((Object)"Could not set modification time", (Throwable)e);
                    }
                }
            } else {
                logger.warn((Object)"Could not store last change - @LastChange missing!");
            }
        }
        return aNew;
    }

    @Override
    public <T> void store(List<T> lst, String collectionName, AsyncOperationCallback<T> callback) {
        if (lst == null || lst.size() == 0) {
            return;
        }
        ArrayList<DBObject> dbLst = new ArrayList<DBObject>();
        DBCollection collection = this.morphium.getDatabase().getCollection(collectionName);
        WriteConcern wc = this.morphium.getWriteConcernForClass(lst.get(0).getClass());
        HashMap<T, Boolean> isNew = new HashMap<T, Boolean>();
        for (T record : lst) {
            DBObject marshall = this.morphium.getMapper().marshall(record);
            Object id = this.annotationHelper.getId(record);
            boolean isn = id == null;
            Object reread = null;
            CreationTime creationTime = this.annotationHelper.getAnnotationFromHierarchy(record.getClass(), CreationTime.class);
            if (!isn && (this.morphium.getConfig().isCheckForNew() || creationTime != null && creationTime.checkForNew()) && !this.annotationHelper.getIdField(record).getType().equals(ObjectId.class)) {
                reread = this.morphium.findById(record.getClass(), id);
                isn = reread == null;
            }
            try {
                isn = this.setAutoValues(record, record.getClass(), id, isn, reread);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            isNew.put(record, isn);
            if (((Boolean)isNew.get(record)).booleanValue()) {
                dbLst.add(marshall);
                continue;
            }
            long start = System.currentTimeMillis();
            WriteResult result = null;
            for (int i = 0; i < this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                try {
                    if (!this.morphium.getDatabase().collectionExists(collectionName)) {
                        logger.warn((Object)"collection does not exist while storing list -  taking first element of list to ensure indices");
                        this.morphium.ensureIndicesFor(lst.get(0).getClass(), collectionName, callback);
                    }
                    if (wc == null) {
                        result = collection.save(marshall);
                        continue;
                    }
                    result = collection.save(marshall, wc);
                    continue;
                }
                catch (Exception e) {
                    this.morphium.handleNetworkError(i, e);
                }
            }
            if (!result.getLastError().ok()) {
                logger.error((Object)("Writing failed: " + result.getLastError().getErrorMessage()));
            }
            long dur = System.currentTimeMillis() - start;
            this.morphium.fireProfilingWriteEvent(lst.get(0).getClass(), marshall, dur, false, WriteAccessType.SINGLE_INSERT);
            this.morphium.firePostStoreEvent(record, (Boolean)isNew.get(record));
        }
        long start = System.currentTimeMillis();
        if (wc == null) {
            collection.insert(dbLst);
        } else {
            collection.insert(dbLst, wc);
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingWriteEvent(lst.get(0).getClass(), dbLst, dur, true, WriteAccessType.BULK_INSERT);
        for (T record : lst) {
            if (!((Boolean)isNew.get(record)).booleanValue()) continue;
            this.morphium.firePostStoreEvent(record, (Boolean)isNew.get(record));
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public <T> void store(final List<T> lst, AsyncOperationCallback<T> callback) {
        if (!lst.isEmpty()) {
            WriterTask r = new WriterTask(){
                private AsyncOperationCallback<T> callback;

                public void setCallback(AsyncOperationCallback cb) {
                    this.callback = cb;
                }

                @Override
                public void run() {
                    HashMap sorted = new HashMap();
                    HashMap isNew = new HashMap();
                    for (Object o : lst) {
                        Class<?> type = MorphiumWriterImpl.this.annotationHelper.getRealClass(o.getClass());
                        if (!MorphiumWriterImpl.this.annotationHelper.isAnnotationPresentInHierarchy(type, Entity.class)) {
                            logger.error((Object)"Not an entity! Storing not possible! Even not in list!");
                            continue;
                        }
                        MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                        if (MorphiumWriterImpl.this.annotationHelper.isAnnotationPresentInHierarchy(type, PartialUpdate.class) && o instanceof PartiallyUpdateable) {
                            MorphiumWriterImpl.this.morphium.updateUsingFields(o, ((PartiallyUpdateable)o).getAlteredFields().toArray(new String[((PartiallyUpdateable)o).getAlteredFields().size()]));
                            ((PartiallyUpdateable)o).clearAlteredFields();
                            continue;
                        }
                        o = MorphiumWriterImpl.this.annotationHelper.getRealObject(o);
                        if (o == null) {
                            logger.warn((Object)"Illegal Reference? - cannot store Lazy-Loaded / Partial Update Proxy without delegate!");
                            return;
                        }
                        if (sorted.get(o.getClass()) == null) {
                            sorted.put(o.getClass(), new ArrayList());
                        }
                        ((List)sorted.get(o.getClass())).add(o);
                        boolean isn = MorphiumWriterImpl.this.morphium.getId(o) == null;
                        Object reread = null;
                        if (MorphiumWriterImpl.this.annotationHelper.getAnnotationFromHierarchy(o.getClass(), CreationTime.class) != null) {
                            try {
                                isn = MorphiumWriterImpl.this.setAutoValues(o, o.getClass(), MorphiumWriterImpl.this.morphium.getId(o), isn, reread);
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                        }
                        if (isn) {
                            isNew.put(o, true);
                        } else {
                            isNew.put(o, false);
                        }
                        MorphiumWriterImpl.this.morphium.firePreStoreEvent(o, (Boolean)isNew.get(o));
                    }
                    long allStart = System.currentTimeMillis();
                    try {
                        for (Map.Entry es : sorted.entrySet()) {
                            Class c = (Class)es.getKey();
                            ArrayList<DBObject> dbLst = new ArrayList<DBObject>();
                            WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(c);
                            String coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(c);
                            DBCollection collection = null;
                            for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                                try {
                                    collection = MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll);
                                    if (MorphiumWriterImpl.this.morphium.getDatabase().collectionExists(coll)) break;
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)"Collection does not exist - ensuring indices");
                                    }
                                    MorphiumWriterImpl.this.morphium.ensureIndicesFor(c, coll, this.callback);
                                    break;
                                }
                                catch (Throwable t) {
                                    MorphiumWriterImpl.this.morphium.handleNetworkError(i, t);
                                    continue;
                                }
                            }
                            for (Object record : (List)es.getValue()) {
                                DBObject marshall = MorphiumWriterImpl.this.morphium.getMapper().marshall(record);
                                if (((Boolean)isNew.get(record)).booleanValue()) {
                                    dbLst.add(marshall);
                                    continue;
                                }
                                long start = System.currentTimeMillis();
                                WriteResult result = null;
                                for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                                    try {
                                        result = wc == null ? collection.save(marshall) : collection.save(marshall, wc);
                                        if (result.getLastError().ok()) break;
                                        logger.error((Object)("Writing failed: " + result.getLastError().getErrorMessage()));
                                        break;
                                    }
                                    catch (Exception e) {
                                        MorphiumWriterImpl.this.morphium.handleNetworkError(i, e);
                                        continue;
                                    }
                                }
                                long dur = System.currentTimeMillis() - start;
                                MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(c, marshall, dur, false, WriteAccessType.SINGLE_INSERT);
                                MorphiumWriterImpl.this.morphium.firePostStoreEvent(record, (Boolean)isNew.get(record));
                            }
                            long start = System.currentTimeMillis();
                            for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                                try {
                                    if (wc == null) {
                                        collection.insert(dbLst);
                                        break;
                                    }
                                    collection.insert(dbLst, wc);
                                    break;
                                }
                                catch (Exception e) {
                                    MorphiumWriterImpl.this.morphium.handleNetworkError(i, e);
                                    continue;
                                }
                            }
                            long dur = System.currentTimeMillis() - start;
                            MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(c, dbLst, dur, true, WriteAccessType.BULK_INSERT);
                            for (Object record : (List)es.getValue()) {
                                if (!((Boolean)isNew.get(record)).booleanValue()) continue;
                                MorphiumWriterImpl.this.morphium.firePostStoreEvent(record, (Boolean)isNew.get(record));
                            }
                        }
                        if (this.callback != null) {
                            this.callback.onOperationSucceeded(AsyncOperationType.WRITE, null, System.currentTimeMillis() - allStart, null, null, lst);
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        if (this.callback == null) {
                            throw new RuntimeException(e);
                        }
                        this.callback.onOperationError(AsyncOperationType.WRITE, null, System.currentTimeMillis() - allStart, e.getMessage(), e, null, lst);
                    }
                }
            };
            this.submitAndBlockIfNecessary(callback, r);
        }
    }

    @Override
    public <T> void set(final T toSet, final String collection, final String field, final Object v, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask<T>(){
            private AsyncOperationCallback<T> callback;

            @Override
            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                long cnt;
                Class<?> cls = toSet.getClass();
                Object value = v;
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                value = MorphiumWriterImpl.this.marshallIfNecessary(value);
                String coll = collection;
                if (coll == null) {
                    MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                }
                BasicDBObject query = new BasicDBObject();
                query.put("_id", MorphiumWriterImpl.this.morphium.getId(toSet));
                Field f = MorphiumWriterImpl.this.annotationHelper.getField(cls, field);
                if (f == null) {
                    throw new RuntimeException("Unknown field: " + field);
                }
                String fieldName = MorphiumWriterImpl.this.annotationHelper.getFieldName(cls, field);
                BasicDBObject update = new BasicDBObject("$set", (Object)new BasicDBObject(fieldName, value));
                List<String> lastChangeFields = MorphiumWriterImpl.this.annotationHelper.getFields(cls, LastChange.class);
                if (lastChangeFields != null && lastChangeFields.size() != 0) {
                    for (String fL : lastChangeFields) {
                        Field fld = MorphiumWriterImpl.this.annotationHelper.getField(cls, fL);
                        if (fld.getType().equals(Date.class)) {
                            ((BasicDBObject)update.get("$set")).put(fL, (Object)new Date());
                            continue;
                        }
                        ((BasicDBObject)update.get("$set")).put(fL, (Object)System.currentTimeMillis());
                    }
                }
                List<String> creationTimeFields = MorphiumWriterImpl.this.annotationHelper.getFields(cls, CreationTime.class);
                if (insertIfNotExist && creationTimeFields != null && creationTimeFields.size() != 0 && (cnt = MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).count((DBObject)query)) == 0L) {
                    for (String fL : creationTimeFields) {
                        Field fld = MorphiumWriterImpl.this.annotationHelper.getField(cls, fL);
                        if (fld.getType().equals(Date.class)) {
                            ((BasicDBObject)update.get("$set")).put(fL, (Object)new Date());
                            continue;
                        }
                        ((BasicDBObject)update.get("$set")).put(fL, (Object)System.currentTimeMillis());
                    }
                }
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                long start = System.currentTimeMillis();
                try {
                    for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                        try {
                            if (insertIfNotExist && !MorphiumWriterImpl.this.morphium.getDatabase().collectionExists(coll)) {
                                MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls, coll, this.callback);
                            }
                            if (wc == null) {
                                MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update, insertIfNotExist, multiple);
                                break;
                            }
                            MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update, insertIfNotExist, multiple, wc);
                            break;
                        }
                        catch (Throwable t) {
                            MorphiumWriterImpl.this.morphium.handleNetworkError(i, t);
                            continue;
                        }
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, update, dur, false, WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    try {
                        f.set(toSet, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.SET, null, System.currentTimeMillis() - start, null, toSet, field, v);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.SET, null, System.currentTimeMillis() - start, e.getMessage(), e, toSet, field, v);
                }
                MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    public <T> void submitAndBlockIfNecessary(AsyncOperationCallback<T> callback, WriterTask<T> r) {
        if (callback == null) {
            r.run();
        } else {
            r.setCallback(callback);
            int tries = 0;
            boolean retry = true;
            while (retry) {
                try {
                    ++tries;
                    this.executor.submit(r);
                    retry = false;
                }
                catch (RejectedExecutionException e) {
                    if (tries > this.maximumRetries) {
                        throw new RuntimeException("Could not write - not even after " + this.maximumRetries + " and pause of " + this.pause + "ms", e);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.warn((Object)"thread pool exceeded - waiting");
                    }
                    try {
                        Thread.sleep(this.pause);
                    }
                    catch (InterruptedException e1) {}
                }
            }
        }
    }

    @Override
    public <T> void updateUsingFields(final T ent, final String collection, AsyncOperationCallback<T> callback, final String ... fields) {
        if (ent == null) {
            return;
        }
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Object id = MorphiumWriterImpl.this.annotationHelper.getId(ent);
                if (id == null) {
                    logger.warn((Object)"trying to partially update new object - storing it in full!");
                    MorphiumWriterImpl.this.store(ent, collection, this.callback);
                    return;
                }
                MorphiumWriterImpl.this.morphium.firePreStoreEvent(ent, false);
                MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                BasicDBObject find = new BasicDBObject();
                find.put("_id", id);
                BasicDBObject update = new BasicDBObject();
                for (String f : fields) {
                    try {
                        Object value = MorphiumWriterImpl.this.annotationHelper.getValue(ent, f);
                        if (MorphiumWriterImpl.this.annotationHelper.isAnnotationPresentInHierarchy(value.getClass(), Entity.class)) {
                            value = MorphiumWriterImpl.this.morphium.getMapper().marshall(value);
                        }
                        update.put(f, value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                Class<?> type = MorphiumWriterImpl.this.annotationHelper.getRealClass(ent.getClass());
                LastChange t = MorphiumWriterImpl.this.annotationHelper.getAnnotationFromHierarchy(type, LastChange.class);
                if (t != null) {
                    List<String> lst = MorphiumWriterImpl.this.annotationHelper.getFields(ent.getClass(), LastChange.class);
                    long now = System.currentTimeMillis();
                    for (String ctf : lst) {
                        Field f = MorphiumWriterImpl.this.annotationHelper.getField(type, ctf);
                        if (f != null) {
                            try {
                                f.set(ent, now);
                            }
                            catch (IllegalAccessException e) {
                                logger.error((Object)"Could not set modification time", (Throwable)e);
                            }
                        }
                        update.put(ctf, (Object)now);
                    }
                }
                update = new BasicDBObject("$set", (Object)update);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(type);
                long start = System.currentTimeMillis();
                try {
                    String collectionName = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(ent.getClass());
                    if (collectionName == null) {
                        collectionName = collection;
                    }
                    for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                        try {
                            if (!MorphiumWriterImpl.this.morphium.getDatabase().collectionExists(collectionName)) {
                                MorphiumWriterImpl.this.morphium.ensureIndicesFor(ent.getClass(), collectionName, this.callback);
                            }
                            if (wc != null) {
                                MorphiumWriterImpl.this.morphium.getDatabase().getCollection(collectionName).update((DBObject)find, (DBObject)update, false, false, wc);
                                break;
                            }
                            MorphiumWriterImpl.this.morphium.getDatabase().getCollection(collectionName).update((DBObject)find, (DBObject)update, false, false);
                            break;
                        }
                        catch (Throwable th) {
                            MorphiumWriterImpl.this.morphium.handleNetworkError(i, th);
                            continue;
                        }
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(ent.getClass(), update, dur, false, WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(MorphiumWriterImpl.this.annotationHelper.getRealClass(ent.getClass()));
                    MorphiumWriterImpl.this.morphium.firePostStoreEvent(ent, false);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.UPDATE, null, System.currentTimeMillis() - start, null, ent, fields);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.UPDATE, null, System.currentTimeMillis() - start, e.getMessage(), e, ent, fields);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void delete(final List<T> lst, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                HashMap sortedMap = new HashMap();
                for (Object o : lst) {
                    if (sortedMap.get(o.getClass()) == null) {
                        ArrayList queries = new ArrayList();
                        sortedMap.put(o.getClass(), queries);
                    }
                    Query<?> q = MorphiumWriterImpl.this.morphium.createQueryFor(o.getClass());
                    q.f(MorphiumWriterImpl.this.annotationHelper.getIdFieldName(o)).eq(MorphiumWriterImpl.this.annotationHelper.getId(o));
                    ((List)sortedMap.get(o.getClass())).add(q);
                }
                long start = System.currentTimeMillis();
                try {
                    for (Class cls : sortedMap.keySet()) {
                        Query orQuery = MorphiumWriterImpl.this.morphium.createQueryFor(cls);
                        orQuery = orQuery.or((List)sortedMap.get(cls));
                        MorphiumWriterImpl.this.delete(orQuery, (AsyncOperationCallback)null);
                    }
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.REMOVE, null, System.currentTimeMillis() - start, null, null, lst);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.REMOVE, null, System.currentTimeMillis() - start, e.getMessage(), e, null, lst);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void delete(final Query<T> q, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                MorphiumWriterImpl.this.morphium.firePreRemoveEvent(q);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(q.getType());
                long start = System.currentTimeMillis();
                try {
                    for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                        try {
                            if (wc == null) {
                                MorphiumWriterImpl.this.morphium.getDatabase().getCollection(MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(q.getType())).remove(q.toQueryObject());
                                break;
                            }
                            MorphiumWriterImpl.this.morphium.getDatabase().getCollection(MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(q.getType())).remove(q.toQueryObject(), wc);
                            break;
                        }
                        catch (Throwable t) {
                            MorphiumWriterImpl.this.morphium.handleNetworkError(i, t);
                            continue;
                        }
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(q.getType(), q.toQueryObject(), dur, false, WriteAccessType.BULK_DELETE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(q.getType());
                    MorphiumWriterImpl.this.morphium.firePostRemoveEvent(q);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.REMOVE, q, System.currentTimeMillis() - start, null, null, new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.REMOVE, q, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void delete(final T o, final String collection, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Object id = MorphiumWriterImpl.this.annotationHelper.getId(o);
                MorphiumWriterImpl.this.morphium.firePreRemoveEvent(o);
                BasicDBObject db = new BasicDBObject();
                db.append("_id", id);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(o.getClass());
                long start = System.currentTimeMillis();
                try {
                    String collectionName = collection;
                    if (collectionName == null) {
                        MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(o.getClass());
                    }
                    for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                        try {
                            if (wc == null) {
                                MorphiumWriterImpl.this.morphium.getDatabase().getCollection(collectionName).remove((DBObject)db);
                                break;
                            }
                            MorphiumWriterImpl.this.morphium.getDatabase().getCollection(collectionName).remove((DBObject)db, wc);
                            break;
                        }
                        catch (Throwable t) {
                            MorphiumWriterImpl.this.morphium.handleNetworkError(i, t);
                            continue;
                        }
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(o.getClass(), o, dur, false, WriteAccessType.SINGLE_DELETE);
                    MorphiumWriterImpl.this.morphium.clearCachefor(o.getClass());
                    MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                    MorphiumWriterImpl.this.morphium.firePostRemoveEvent(o);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.REMOVE, null, System.currentTimeMillis() - start, null, o, new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.REMOVE, null, System.currentTimeMillis() - start, e.getMessage(), e, o, new Object[0]);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void inc(final T toInc, final String collection, final String field, final double amount, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Class<?> cls = toInc.getClass();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                String coll = collection;
                if (coll == null) {
                    coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                }
                BasicDBObject query = new BasicDBObject();
                query.put("_id", MorphiumWriterImpl.this.morphium.getId(toInc));
                Field f = MorphiumWriterImpl.this.annotationHelper.getField(cls, field);
                if (f == null) {
                    throw new RuntimeException("Unknown field: " + field);
                }
                String fieldName = MorphiumWriterImpl.this.annotationHelper.getFieldName(cls, field);
                BasicDBObject update = new BasicDBObject("$inc", (Object)new BasicDBObject(fieldName, (Object)amount));
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(toInc.getClass());
                long start = System.currentTimeMillis();
                try {
                    for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                        try {
                            if (!MorphiumWriterImpl.this.morphium.getDatabase().collectionExists(coll)) {
                                MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls, coll, this.callback);
                            }
                            if (wc == null) {
                                MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update);
                                break;
                            }
                            MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update, false, false, wc);
                            break;
                        }
                        catch (Throwable t) {
                            MorphiumWriterImpl.this.morphium.handleNetworkError(i, t);
                            continue;
                        }
                    }
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                        try {
                            f.set(toInc, (Integer)f.get(toInc) + (int)amount);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    } else if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                        try {
                            f.set(toInc, (Double)f.get(toInc) + amount);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    } else if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                        try {
                            f.set(toInc, Float.valueOf(((Float)f.get(toInc)).floatValue() + (float)amount));
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    } else if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                        try {
                            f.set(toInc, (Long)f.get(toInc) + (long)amount);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        logger.error((Object)("Could not set increased value - unsupported type " + cls.getName()));
                    }
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(toInc.getClass(), toInc, System.currentTimeMillis() - start, false, WriteAccessType.SINGLE_UPDATE);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.INC, null, System.currentTimeMillis() - start, null, toInc, field, amount);
                    }
                }
                catch (RuntimeException e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.INC, null, System.currentTimeMillis() - start, e.getMessage(), e, toInc, field, amount);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void inc(final Query<T> query, final Map<String, Double> fieldsToInc, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Class cls = query.getType();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                String coll = query.getCollectionName();
                BasicDBObject update = new BasicDBObject();
                update.put("$inc", (Object)new BasicDBObject(fieldsToInc));
                DBObject qobj = query.toQueryObject();
                if (insertIfNotExist) {
                    qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                }
                long start = System.currentTimeMillis();
                try {
                    for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                        try {
                            WriteConcern wc;
                            if (insertIfNotExist && !MorphiumWriterImpl.this.morphium.getDatabase().collectionExists(coll)) {
                                MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls, coll, this.callback);
                            }
                            if ((wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls)) == null) {
                                MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple);
                                break;
                            }
                            MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple, wc);
                            break;
                        }
                        catch (Throwable t) {
                            MorphiumWriterImpl.this.morphium.handleNetworkError(i, t);
                            continue;
                        }
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, update, dur, insertIfNotExist, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.INC, query, System.currentTimeMillis() - start, null, null, fieldsToInc);
                    }
                }
                catch (RuntimeException e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.INC, query, System.currentTimeMillis() - start, e.getMessage(), e, null, fieldsToInc);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void inc(final Query<T> query, final String field, final double amount, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Class cls = query.getType();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                String coll = query.getCollectionName();
                String fieldName = MorphiumWriterImpl.this.annotationHelper.getFieldName(cls, field);
                BasicDBObject update = new BasicDBObject("$inc", (Object)new BasicDBObject(fieldName, (Object)amount));
                DBObject qobj = query.toQueryObject();
                if (insertIfNotExist) {
                    qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                }
                long start = System.currentTimeMillis();
                try {
                    for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                        try {
                            WriteConcern wc;
                            if (insertIfNotExist && !MorphiumWriterImpl.this.morphium.getDatabase().collectionExists(coll)) {
                                MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls, coll, this.callback);
                            }
                            if ((wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls)) == null) {
                                MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple);
                                break;
                            }
                            MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple, wc);
                            break;
                        }
                        catch (Throwable t) {
                            MorphiumWriterImpl.this.morphium.handleNetworkError(i, t);
                            continue;
                        }
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, update, dur, insertIfNotExist, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.INC, query, System.currentTimeMillis() - start, null, null, field, amount);
                    }
                }
                catch (RuntimeException e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.INC, query, System.currentTimeMillis() - start, e.getMessage(), e, null, field, amount);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void set(final Query<T> query, final Map<String, Object> values, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask $set;
        WriterTask r = $set = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                List<String> latChangeFlds;
                Field fld;
                Class cls = query.getType();
                String coll = query.getCollectionName();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                BasicDBObject toSet = new BasicDBObject();
                for (Map.Entry ef : values.entrySet()) {
                    String fieldName = MorphiumWriterImpl.this.annotationHelper.getFieldName(cls, (String)ef.getKey());
                    toSet.put(fieldName, MorphiumWriterImpl.this.marshallIfNecessary(ef.getValue()));
                }
                BasicDBObject update = new BasicDBObject("$set", (Object)toSet);
                DBObject qobj = query.toQueryObject();
                if (insertIfNotExist) {
                    qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                    List<String> creationTimeFlds = MorphiumWriterImpl.this.annotationHelper.getFields(cls, CreationTime.class);
                    if (creationTimeFlds != null && creationTimeFlds.size() != 0 && MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).find(qobj).count() == 0 && creationTimeFlds != null && creationTimeFlds.size() != 0) {
                        for (String fL : creationTimeFlds) {
                            fld = MorphiumWriterImpl.this.annotationHelper.getField(cls, fL);
                            if (fld.getType().equals(Date.class)) {
                                ((BasicDBObject)update.get("$set")).put(fL, (Object)new Date());
                                continue;
                            }
                            ((BasicDBObject)update.get("$set")).put(fL, (Object)System.currentTimeMillis());
                        }
                    }
                }
                if ((latChangeFlds = MorphiumWriterImpl.this.annotationHelper.getFields(cls, LastChange.class)) != null && latChangeFlds.size() != 0) {
                    for (String fL : latChangeFlds) {
                        fld = MorphiumWriterImpl.this.annotationHelper.getField(cls, fL);
                        if (fld.getType().equals(Date.class)) {
                            ((BasicDBObject)update.get("$set")).put(fL, (Object)new Date());
                            continue;
                        }
                        ((BasicDBObject)update.get("$set")).put(fL, (Object)System.currentTimeMillis());
                    }
                }
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                long start = System.currentTimeMillis();
                try {
                    for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                        try {
                            if (insertIfNotExist && !MorphiumWriterImpl.this.morphium.getDatabase().collectionExists(coll)) {
                                MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls, coll, this.callback);
                            }
                            if (wc == null) {
                                MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple);
                                break;
                            }
                            MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple, wc);
                            break;
                        }
                        catch (Throwable t) {
                            MorphiumWriterImpl.this.morphium.handleNetworkError(i, t);
                            continue;
                        }
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, update, dur, insertIfNotExist, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.SET, query, System.currentTimeMillis() - start, null, null, values, insertIfNotExist, multiple);
                    }
                }
                catch (RuntimeException e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.SET, query, System.currentTimeMillis() - start, e.getMessage(), e, null, values, insertIfNotExist, multiple);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void unset(Query<T> query, AsyncOperationCallback<T> callback, boolean multiple, Enum ... fields) {
        ArrayList<String> flds = new ArrayList<String>();
        for (Enum e : fields) {
            flds.add(e.name());
        }
        this.unset(query, callback, multiple, flds.toArray(new String[fields.length]));
    }

    @Override
    public <T> void unset(final Query<T> query, AsyncOperationCallback<T> callback, final boolean multiple, final String ... fields) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Class cls = query.getType();
                String coll = query.getCollectionName();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                DBObject qobj = query.toQueryObject();
                HashMap<String, String> toSet = new HashMap<String, String>();
                for (String f : fields) {
                    toSet.put(f, "");
                }
                BasicDBObject update = new BasicDBObject("$unset", toSet);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                long start = System.currentTimeMillis();
                try {
                    for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                        try {
                            if (wc == null) {
                                MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, false, multiple);
                                break;
                            }
                            MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, false, multiple, wc);
                            break;
                        }
                        catch (Throwable t) {
                            MorphiumWriterImpl.this.morphium.handleNetworkError(i, t);
                            continue;
                        }
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, update, dur, false, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.SET, query, System.currentTimeMillis() - start, null, null, fields, false, multiple);
                    }
                }
                catch (RuntimeException e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.SET, query, System.currentTimeMillis() - start, e.getMessage(), e, null, fields, false, multiple);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void unset(final T toSet, final String collection, final String field, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.annotationHelper.getId(toSet) == null) {
            logger.info((Object)"just storing object as it is new...");
            this.store(toSet, collection, callback);
        }
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Class<?> cls = toSet.getClass();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.UNSET);
                String coll = collection;
                if (coll == null) {
                    coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                }
                BasicDBObject query = new BasicDBObject();
                query.put("_id", MorphiumWriterImpl.this.morphium.getId(toSet));
                Field f = MorphiumWriterImpl.this.annotationHelper.getField(cls, field);
                if (f == null) {
                    throw new RuntimeException("Unknown field: " + field);
                }
                String fieldName = MorphiumWriterImpl.this.annotationHelper.getFieldName(cls, field);
                BasicDBObject update = new BasicDBObject("$unset", (Object)new BasicDBObject(fieldName, (Object)1));
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(toSet.getClass());
                long start = System.currentTimeMillis();
                try {
                    for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                        try {
                            if (!MorphiumWriterImpl.this.morphium.getDatabase().collectionExists(coll)) {
                                MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls, coll, this.callback);
                            }
                            if (wc == null) {
                                MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update);
                                break;
                            }
                            MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update, false, false, wc);
                            break;
                        }
                        catch (Throwable t) {
                            MorphiumWriterImpl.this.morphium.handleNetworkError(i, t);
                            List<String> lastChangeFields = MorphiumWriterImpl.this.annotationHelper.getFields(cls, LastChange.class);
                            if (lastChangeFields == null || lastChangeFields.size() == 0) continue;
                            update = new BasicDBObject("$set", (Object)new BasicDBObject());
                            for (String fL : lastChangeFields) {
                                Field fld = MorphiumWriterImpl.this.annotationHelper.getField(cls, fL);
                                if (fld.getType().equals(Date.class)) {
                                    ((BasicDBObject)update.get("$set")).put(fL, (Object)new Date());
                                    continue;
                                }
                                ((BasicDBObject)update.get("$set")).put(fL, (Object)System.currentTimeMillis());
                            }
                            if (wc == null) {
                                MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update);
                                continue;
                            }
                            MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update, false, false, wc);
                            continue;
                        }
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(toSet.getClass(), update, dur, false, WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    try {
                        f.set(toSet, null);
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.UNSET);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.UNSET, null, System.currentTimeMillis() - start, null, toSet, field);
                    }
                }
                catch (RuntimeException e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.UNSET, null, System.currentTimeMillis() - start, e.getMessage(), e, toSet, field);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void unset(Query<T> query, String field, boolean multiple, AsyncOperationCallback<T> callback) {
        this.unset(query, callback, multiple, field);
    }

    @Override
    public <T> void pushPull(final boolean push, final Query<T> query, final String field, final Object value, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Class cls = query.getType();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL);
                String coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                DBObject qobj = query.toQueryObject();
                if (insertIfNotExist) {
                    qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                }
                Object v = MorphiumWriterImpl.this.marshallIfNecessary(value);
                String fieldName = MorphiumWriterImpl.this.annotationHelper.getFieldName(cls, field);
                BasicDBObject set = new BasicDBObject(fieldName, v);
                BasicDBObject update = new BasicDBObject(push ? "$push" : "$pull", (Object)set);
                long start = System.currentTimeMillis();
                try {
                    MorphiumWriterImpl.this.pushIt(push, insertIfNotExist, multiple, cls, coll, qobj, update);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.PUSH, query, System.currentTimeMillis() - start, null, null, field, value, insertIfNotExist, multiple);
                    }
                }
                catch (RuntimeException e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.PUSH, query, System.currentTimeMillis() - start, e.getMessage(), e, null, field, value, insertIfNotExist, multiple);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    private Object marshallIfNecessary(Object value) {
        if (value != null) {
            if (this.annotationHelper.isAnnotationPresentInHierarchy(value.getClass(), Entity.class) || this.annotationHelper.isAnnotationPresentInHierarchy(value.getClass(), Embedded.class)) {
                DBObject marshall = this.morphium.getMapper().marshall(value);
                marshall.put("class_name", (Object)this.annotationHelper.getRealClass(value.getClass()).getName());
                value = marshall;
            } else if (List.class.isAssignableFrom(value.getClass())) {
                ArrayList<Object> lst = new ArrayList<Object>();
                for (Object o : (List)value) {
                    if (this.annotationHelper.isAnnotationPresentInHierarchy(o.getClass(), Embedded.class) || this.annotationHelper.isAnnotationPresentInHierarchy(o.getClass(), Entity.class)) {
                        DBObject marshall = this.morphium.getMapper().marshall(o);
                        marshall.put("class_name", (Object)this.annotationHelper.getRealClass(o.getClass()).getName());
                        lst.add(marshall);
                        continue;
                    }
                    lst.add(o);
                }
                value = lst;
            } else if (Map.class.isAssignableFrom(value.getClass())) {
                Iterator i$ = ((Map)((Object)value)).entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry e;
                    Map.Entry en = e = i$.next();
                    if (!String.class.isAssignableFrom(e.getKey().getClass())) {
                        throw new IllegalArgumentException("Can't push maps with Key not of type String!");
                    }
                    if (!this.annotationHelper.isAnnotationPresentInHierarchy(en.getValue().getClass(), Entity.class) && !this.annotationHelper.isAnnotationPresentInHierarchy(en.getValue().getClass(), Embedded.class)) continue;
                    DBObject marshall = this.morphium.getMapper().marshall(en.getValue());
                    marshall.put("class_name", (Object)this.annotationHelper.getRealClass(en.getValue().getClass()).getName());
                    ((Map)((Object)value)).put(en.getKey(), marshall);
                }
            }
        }
        return value;
    }

    private void pushIt(boolean push, boolean insertIfNotExist, boolean multiple, Class<?> cls, String coll, DBObject qobj, BasicDBObject update) {
        List<String> lastChangeFields = this.annotationHelper.getFields(cls, LastChange.class);
        if (lastChangeFields != null && lastChangeFields.size() != 0) {
            update.put("$set", (Object)new BasicDBObject());
            for (String fL : lastChangeFields) {
                Field fld = this.annotationHelper.getField(cls, fL);
                if (fld.getType().equals(Date.class)) {
                    ((BasicDBObject)update.get("$set")).put(fL, (Object)new Date());
                    continue;
                }
                ((BasicDBObject)update.get("$set")).put(fL, (Object)System.currentTimeMillis());
            }
        }
        if (insertIfNotExist) {
            long cnt;
            List<String> creationTimeFields = this.annotationHelper.getFields(cls, CreationTime.class);
            if (insertIfNotExist && creationTimeFields != null && creationTimeFields.size() != 0 && (cnt = this.morphium.getDatabase().getCollection(coll).count(qobj)) == 0L) {
                if (update.get("$set") == null) {
                    update.put("$set", (Object)new BasicDBObject());
                }
                for (String fL : creationTimeFields) {
                    Field fld = this.annotationHelper.getField(cls, fL);
                    if (fld.getType().equals(Date.class)) {
                        ((BasicDBObject)update.get("$set")).put(fL, (Object)new Date());
                        continue;
                    }
                    ((BasicDBObject)update.get("$set")).put(fL, (Object)System.currentTimeMillis());
                }
            }
        }
        WriteConcern wc = this.morphium.getWriteConcernForClass(cls);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
            try {
                if (!this.morphium.getDatabase().collectionExists(coll) && insertIfNotExist) {
                    this.morphium.ensureIndicesFor(cls, coll);
                }
                if (wc == null) {
                    this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple);
                    break;
                }
                this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple, wc);
                break;
            }
            catch (Exception e) {
                this.morphium.handleNetworkError(i, e);
                continue;
            }
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingWriteEvent(cls, update, dur, insertIfNotExist, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
        this.morphium.getCache().clearCacheIfNecessary(cls);
        this.morphium.firePostUpdateEvent(this.annotationHelper.getRealClass(cls), push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL);
    }

    @Override
    public <T> void pushPullAll(final boolean push, final Query<T> query, final String f, final List<?> v, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                ArrayList<Object> value = v;
                String field = f;
                Class cls = query.getType();
                String coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL);
                long start = System.currentTimeMillis();
                ArrayList<Object> lst = new ArrayList<Object>();
                for (Object e : value) {
                    lst.add(MorphiumWriterImpl.this.marshallIfNecessary(e));
                }
                value = lst;
                try {
                    DBObject qobj = query.toQueryObject();
                    if (insertIfNotExist) {
                        qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                    }
                    field = MorphiumWriterImpl.this.annotationHelper.getFieldName(cls, field);
                    BasicDBObject basicDBObject = new BasicDBObject(field, value);
                    BasicDBObject update = new BasicDBObject(push ? "$pushAll" : "$pullAll", (Object)basicDBObject);
                    List<String> lastChangeFields = MorphiumWriterImpl.this.annotationHelper.getFields(cls, LastChange.class);
                    if (lastChangeFields != null && lastChangeFields.size() != 0) {
                        update.put("$set", (Object)new BasicDBObject());
                        for (String fL : lastChangeFields) {
                            Field fld = MorphiumWriterImpl.this.annotationHelper.getField(cls, fL);
                            if (fld.getType().equals(Date.class)) {
                                ((BasicDBObject)update.get("$set")).put(fL, (Object)new Date());
                                continue;
                            }
                            ((BasicDBObject)update.get("$set")).put(fL, (Object)System.currentTimeMillis());
                        }
                    }
                    if (insertIfNotExist) {
                        long cnt;
                        List<String> creationTimeFields = MorphiumWriterImpl.this.annotationHelper.getFields(cls, CreationTime.class);
                        if (insertIfNotExist && creationTimeFields != null && creationTimeFields.size() != 0 && (cnt = MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).count(qobj)) == 0L) {
                            if (update.get("$set") == null) {
                                update.put("$set", (Object)new BasicDBObject());
                            }
                            for (String fL : creationTimeFields) {
                                Field fld = MorphiumWriterImpl.this.annotationHelper.getField(cls, fL);
                                if (fld.getType().equals(Date.class)) {
                                    ((BasicDBObject)update.get("$set")).put(fL, (Object)new Date());
                                    continue;
                                }
                                ((BasicDBObject)update.get("$set")).put(fL, (Object)System.currentTimeMillis());
                            }
                        }
                    }
                    WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                    for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                        try {
                            if (insertIfNotExist && !MorphiumWriterImpl.this.morphium.getDatabase().collectionExists(coll)) {
                                MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls, coll, this.callback);
                            }
                            if (wc == null) {
                                MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple);
                                break;
                            }
                            MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple, wc);
                            break;
                        }
                        catch (Throwable t) {
                            MorphiumWriterImpl.this.morphium.handleNetworkError(i, t);
                            continue;
                        }
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, update, dur, insertIfNotExist, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(push ? AsyncOperationType.PUSH : AsyncOperationType.PULL, query, System.currentTimeMillis() - start, null, null, field, value, insertIfNotExist, multiple);
                    }
                }
                catch (RuntimeException e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(push ? AsyncOperationType.PUSH : AsyncOperationType.PULL, query, System.currentTimeMillis() - start, e.getMessage(), e, null, field, value, insertIfNotExist, multiple);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void dropCollection(final Class<T> cls, final String collection, AsyncOperationCallback<T> callback) {
        if (!this.annotationHelper.isAnnotationPresentInHierarchy(cls, Entity.class)) {
            throw new RuntimeException("No entity class: " + cls.getName());
        }
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                MorphiumWriterImpl.this.morphium.firePreDropEvent(cls);
                long start = System.currentTimeMillis();
                String co = collection;
                if (co == null) {
                    co = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                }
                DBCollection coll = MorphiumWriterImpl.this.morphium.getDatabase().getCollection(co);
                for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                    try {
                        coll.drop();
                        break;
                    }
                    catch (Throwable t) {
                        MorphiumWriterImpl.this.morphium.handleNetworkError(i, t);
                        continue;
                    }
                }
                long dur = System.currentTimeMillis() - start;
                MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, null, dur, false, WriteAccessType.DROP);
                MorphiumWriterImpl.this.morphium.firePostDropEvent(cls);
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void ensureIndex(final Class<T> cls, final String collection, final Map<String, Object> index, final Map<String, Object> options, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                List<String> fields = MorphiumWriterImpl.this.annotationHelper.getFields(cls, new Class[0]);
                LinkedHashMap idx = new LinkedHashMap();
                for (Map.Entry es : index.entrySet()) {
                    String k = (String)es.getKey();
                    if (!fields.contains(k) && !fields.contains(MorphiumWriterImpl.this.annotationHelper.convertCamelCase(k))) {
                        throw new IllegalArgumentException("Field unknown for type " + cls.getSimpleName() + ": " + k);
                    }
                    String fn = MorphiumWriterImpl.this.annotationHelper.getFieldName(cls, k);
                    idx.put(fn, es.getValue());
                }
                long start = System.currentTimeMillis();
                BasicDBObject keys = new BasicDBObject(idx);
                String coll = collection;
                if (coll == null) {
                    coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                }
                for (int i = 0; i < MorphiumWriterImpl.this.morphium.getConfig().getRetriesOnNetworkError(); ++i) {
                    try {
                        if (options == null) {
                            MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).ensureIndex((DBObject)keys);
                            continue;
                        }
                        BasicDBObject opts = new BasicDBObject(options);
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).ensureIndex((DBObject)keys, (DBObject)opts);
                        continue;
                    }
                    catch (Exception e) {
                        MorphiumWriterImpl.this.morphium.handleNetworkError(i, e);
                    }
                }
                long dur = System.currentTimeMillis() - start;
                MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, keys, dur, false, WriteAccessType.ENSURE_INDEX);
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public int writeBufferCount() {
        return this.executor.getActiveCount();
    }
}

