/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.NameProvider;
import de.caluga.morphium.ObjectMapper;
import de.caluga.morphium.PartiallyUpdateable;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.PartialUpdate;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.annotations.UseIfnull;
import de.caluga.morphium.query.Query;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bson.types.ObjectId;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ObjectMapperImpl
implements ObjectMapper {
    private static Logger log = Logger.getLogger(ObjectMapperImpl.class);
    private volatile Hashtable<Class<?>, NameProvider> nameProviders;
    private volatile AnnotationAndReflectionHelper annotationHelper = new AnnotationAndReflectionHelper();
    private Morphium morphium;
    private JSONParser jsonParser = new JSONParser();

    public ObjectMapperImpl() {
        this.nameProviders = new Hashtable();
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        this.annotationHelper = m != null ? m.getARHelper() : new AnnotationAndReflectionHelper();
    }

    @Override
    public void setNameProviderForClass(Class<?> cls, NameProvider np) {
        this.nameProviders.put(cls, np);
    }

    @Override
    public NameProvider getNameProviderForClass(Class<?> cls) {
        Entity e = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
        if (e == null) {
            throw new IllegalArgumentException("no entity annotation found");
        }
        try {
            return this.getNameProviderForClass(cls, e);
        }
        catch (Exception ex) {
            log.error((Object)"Error getting nameProvider", (Throwable)ex);
            throw new IllegalArgumentException("could not get name provicer", ex);
        }
    }

    private NameProvider getNameProviderForClass(Class<?> cls, Entity p) throws IllegalAccessException, InstantiationException {
        if (p == null) {
            throw new IllegalArgumentException("No Entity " + cls.getSimpleName());
        }
        if (this.nameProviders.get(cls) == null) {
            NameProvider np = p.nameProvider().newInstance();
            this.nameProviders.put(cls, np);
        }
        return this.nameProviders.get(cls);
    }

    @Override
    public String getCollectionName(Class cls) {
        Entity p = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
        if (p == null) {
            throw new IllegalArgumentException("No Entity " + cls.getSimpleName());
        }
        try {
            cls = this.annotationHelper.getRealClass(cls);
            NameProvider np = this.getNameProviderForClass(cls, p);
            return np.getCollectionName(cls, this, p.translateCamelCase(), p.useFQN(), p.collectionName().equals(".") ? null : p.collectionName(), this.morphium);
        }
        catch (InstantiationException e) {
            log.error((Object)("Could not instanciate NameProvider: " + p.nameProvider().getName()), (Throwable)e);
            throw new RuntimeException("Could not Instaciate NameProvider", e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Illegal Access during instanciation of NameProvider: " + p.nameProvider().getName()), (Throwable)e);
            throw new RuntimeException("Illegal Access during instanciation", e);
        }
    }

    @Override
    public DBObject marshall(Object o) {
        if (!this.annotationHelper.isEntity(o)) {
            throw new IllegalArgumentException("Object is no entity: " + o.getClass().getSimpleName());
        }
        BasicDBObject dbo = new BasicDBObject();
        if (o == null) {
            return dbo;
        }
        Class<?> cls = this.annotationHelper.getRealClass(o.getClass());
        if (cls == null) {
            throw new IllegalArgumentException("No real class?");
        }
        o = this.annotationHelper.getRealObject(o);
        List<String> flds = this.annotationHelper.getFields(cls, new Class[0]);
        if (flds == null) {
            throw new IllegalArgumentException("Fields not found? " + cls.getName());
        }
        Entity e = this.annotationHelper.getAnnotationFromHierarchy(o.getClass(), Entity.class);
        Embedded emb = this.annotationHelper.getAnnotationFromHierarchy(o.getClass(), Embedded.class);
        if (e != null && e.polymorph()) {
            dbo.put("class_name", (Object)cls.getName());
        }
        if (emb != null && emb.polymorph()) {
            dbo.put("class_name", (Object)cls.getName());
        }
        Iterator<String> i$ = flds.iterator();
        while (i$.hasNext()) {
            String f;
            String fName = f = i$.next();
            try {
                Field fld = this.annotationHelper.getField(cls, f);
                if (fld == null) {
                    log.error((Object)"Field not found");
                    continue;
                }
                if (Modifier.isStatic(fld.getModifiers())) continue;
                AdditionalData ad = fld.getAnnotation(AdditionalData.class);
                if (ad != null) {
                    if (ad.readOnly() || fld.get(o) == null) continue;
                    dbo.putAll((Map)fld.get(o));
                    continue;
                }
                if (fld.isAnnotationPresent(Id.class)) {
                    fName = "_id";
                }
                Object v = null;
                Object value = fld.get(o);
                if (fld.isAnnotationPresent(Reference.class)) {
                    Reference r = fld.getAnnotation(Reference.class);
                    if (value == null) {
                        v = null;
                    } else if (Collection.class.isAssignableFrom(fld.getType())) {
                        BasicDBList lst = new BasicDBList();
                        for (Object rec : (Collection)value) {
                            if (rec != null) {
                                Object id = this.annotationHelper.getId(rec);
                                if (id == null) {
                                    if (r.automaticStore()) {
                                        if (this.morphium == null) {
                                            throw new RuntimeException("Could not automagically store references as morphium is not set!");
                                        }
                                        this.morphium.storeNoCache(rec);
                                        id = this.annotationHelper.getId(rec);
                                    } else {
                                        throw new IllegalArgumentException("Cannot store reference to unstored entity if automaticStore in @Reference is set to false!");
                                    }
                                }
                                if (this.morphium == null) {
                                    throw new RuntimeException("cannot set dbRef - morphium is not set");
                                }
                                DBRef ref = new DBRef(this.morphium.getDatabase(), this.annotationHelper.getRealClass(rec.getClass()).getName(), id);
                                lst.add((Object)ref);
                                continue;
                            }
                            lst.add(null);
                        }
                        v = lst;
                    } else {
                        if (Map.class.isAssignableFrom(fld.getType())) {
                            throw new RuntimeException("Cannot store references in Maps!");
                        }
                        if (this.annotationHelper.getId(value) == null) {
                            if (r.automaticStore()) {
                                if (this.morphium == null) {
                                    log.fatal((Object)"Could not store - no Morphium set!");
                                } else {
                                    this.morphium.storeNoCache(value);
                                }
                            } else {
                                throw new IllegalArgumentException("Reference to be stored, that is null!");
                            }
                        }
                        v = this.annotationHelper.getId(value);
                    }
                } else if (this.annotationHelper.isAnnotationPresentInHierarchy(fld.getType(), Entity.class)) {
                    if (value != null) {
                        DBObject obj = this.marshall(value);
                        obj.removeField("_id");
                        v = obj;
                    }
                } else if (this.annotationHelper.isAnnotationPresentInHierarchy(fld.getType(), Embedded.class)) {
                    if (value != null) {
                        v = this.marshall(value);
                    }
                } else {
                    v = value;
                    if (v != null) {
                        if (v instanceof Map) {
                            v = this.createDBMap((Map)v);
                        } else if (v instanceof List) {
                            v = this.createDBList((List)v);
                        } else if (v instanceof Iterable) {
                            ArrayList lst = new ArrayList();
                            for (Object i : (Iterable)v) {
                                lst.add(i);
                            }
                            v = this.createDBList(lst);
                        } else if (v.getClass().equals(GregorianCalendar.class)) {
                            v = ((GregorianCalendar)v).getTime();
                        } else if (v.getClass().isEnum()) {
                            v = ((Enum)v).name();
                        }
                    }
                }
                if (v == null && !fld.isAnnotationPresent(UseIfnull.class)) continue;
                dbo.put(fName, v);
            }
            catch (IllegalAccessException exc) {
                log.fatal((Object)("Illegal Access to field " + f));
            }
        }
        return dbo;
    }

    private BasicDBList createDBList(List v) {
        BasicDBList lst = new BasicDBList();
        for (Object lo : v) {
            if (lo != null) {
                if (this.annotationHelper.isAnnotationPresentInHierarchy(lo.getClass(), Entity.class) || this.annotationHelper.isAnnotationPresentInHierarchy(lo.getClass(), Embedded.class)) {
                    DBObject marshall = this.marshall(lo);
                    marshall.put("class_name", (Object)lo.getClass().getName());
                    lst.add((Object)marshall);
                    continue;
                }
                if (lo instanceof List) {
                    lst.add((Object)this.createDBList((List)lo));
                    continue;
                }
                if (lo instanceof Map) {
                    lst.add((Object)this.createDBMap((Map)lo));
                    continue;
                }
                if (lo.getClass().isEnum()) {
                    BasicDBObject obj = new BasicDBObject();
                    obj.put("class_name", (Object)lo.getClass().getName());
                    obj.put("name", (Object)((Enum)lo).name());
                    lst.add((Object)obj);
                    continue;
                }
                lst.add(lo);
                continue;
            }
            lst.add(null);
        }
        return lst;
    }

    private BasicDBObject createDBMap(Map v) {
        BasicDBObject dbMap = new BasicDBObject();
        for (Map.Entry es : v.entrySet()) {
            Object mval;
            Object k = es.getKey();
            if (!(k instanceof String)) {
                log.warn((Object)"Map in Mongodb needs to have String as keys - using toString");
                k = k.toString();
                if (((String)k).contains(".")) {
                    log.warn((Object)". not allowed as Key in Maps - converting to _");
                    k = ((String)k).replaceAll("\\.", "_");
                }
            }
            if ((mval = es.getValue()) != null) {
                DBObject obj;
                if (this.annotationHelper.isAnnotationPresentInHierarchy(mval.getClass(), Entity.class) || this.annotationHelper.isAnnotationPresentInHierarchy(mval.getClass(), Embedded.class)) {
                    obj = this.marshall(mval);
                    obj.put("class_name", (Object)mval.getClass().getName());
                    mval = obj;
                } else if (mval instanceof Map) {
                    mval = this.createDBMap((Map)mval);
                } else if (mval instanceof List) {
                    mval = this.createDBList((List)mval);
                } else if (mval.getClass().isEnum()) {
                    obj = new BasicDBObject();
                    obj.put("class_name", (Object)mval.getClass().getName());
                    obj.put("name", (Object)((Enum)mval).name());
                }
            }
            dbMap.put((String)k, mval);
        }
        return dbMap;
    }

    @Override
    public <T> T unmarshall(Class<? extends T> cls, String jsonString) throws ParseException {
        ContainerFactory fact = new ContainerFactory(){

            public Map createObjectContainer() {
                return new BasicDBObject();
            }

            public List creatArrayContainer() {
                return new BasicDBList();
            }
        };
        DBObject obj = (DBObject)this.jsonParser.parse(jsonString, fact);
        return this.unmarshall(cls, obj);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T unmarshall(Class<? extends T> cls, DBObject o) {
        try {
            if (o.get("class_name") != null || o.get("className") != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"overriding cls - it's defined in dbObject");
                }
                try {
                    String cN = (String)o.get("class_name");
                    if (cN == null) {
                        cN = (String)o.get("className");
                    }
                    cls = Class.forName(cN);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (cls.isEnum()) {
                Object[] en = cls.getEnumConstants();
                for (Enum e : (Enum[])en) {
                    if (!e.name().equals(o.get("name"))) continue;
                    return (T)e;
                }
            }
            Object ret = cls.newInstance();
            List<String> flds = this.annotationHelper.getFields(cls, new Class[0]);
            Iterator<String> i$ = flds.iterator();
            while (true) {
                Object value;
                String f;
                block57: {
                    Object object;
                    ArrayList<Object> lst;
                    Field fld;
                    block80: {
                        Iterator iterator;
                        HashMap<String, Object> data;
                        block60: {
                            block58: {
                                Object valueFromDb;
                                block67: {
                                    block79: {
                                        block78: {
                                            block69: {
                                                block72: {
                                                    int i$2;
                                                    block70: {
                                                        block77: {
                                                            block76: {
                                                                block75: {
                                                                    block74: {
                                                                        block73: {
                                                                            block71: {
                                                                                block68: {
                                                                                    block66: {
                                                                                        block65: {
                                                                                            block63: {
                                                                                                block64: {
                                                                                                    block61: {
                                                                                                        void var11_22;
                                                                                                        Reference reference;
                                                                                                        block62: {
                                                                                                            block59: {
                                                                                                                if (!i$.hasNext()) break block58;
                                                                                                                f = i$.next();
                                                                                                                valueFromDb = o.get(f);
                                                                                                                fld = this.annotationHelper.getField(cls, f);
                                                                                                                if (Modifier.isStatic(fld.getModifiers())) continue;
                                                                                                                if (!fld.isAnnotationPresent(AdditionalData.class)) break block59;
                                                                                                                if (!Map.class.isAssignableFrom(fld.getType())) {
                                                                                                                    log.error((Object)("Could not unmarshall additional data into fld of type " + fld.getType().toString()));
                                                                                                                    continue;
                                                                                                                }
                                                                                                                Set keys = o.keySet();
                                                                                                                data = new HashMap<String, Object>();
                                                                                                                iterator = keys.iterator();
                                                                                                                break block60;
                                                                                                            }
                                                                                                            if (valueFromDb == null) continue;
                                                                                                            value = null;
                                                                                                            if (Map.class.isAssignableFrom(fld.getType()) || Collection.class.isAssignableFrom(fld.getType()) || !fld.isAnnotationPresent(Reference.class)) break block61;
                                                                                                            reference = fld.getAnnotation(Reference.class);
                                                                                                            if (this.morphium != null) break block62;
                                                                                                            log.fatal((Object)"Morphium not set - could not de-reference!");
                                                                                                            break block57;
                                                                                                        }
                                                                                                        Object var11_19 = null;
                                                                                                        if (valueFromDb instanceof Object) {
                                                                                                            Object object2 = valueFromDb;
                                                                                                        } else {
                                                                                                            DBRef ref = (DBRef)valueFromDb;
                                                                                                            if (ref != null) {
                                                                                                                Object object3 = ref.getId();
                                                                                                                if (!ref.getRef().equals(fld.getType().getName())) {
                                                                                                                    log.warn((Object)"Reference to different object?! - continuing anyway");
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                        if (var11_22 != null) {
                                                                                                            if (reference.lazyLoading()) {
                                                                                                                List<String> lst2 = this.annotationHelper.getFields(fld.getType(), Id.class);
                                                                                                                if (lst2.size() == 0) {
                                                                                                                    throw new IllegalArgumentException("Referenced object does not have an ID? Is it an Entity?");
                                                                                                                }
                                                                                                                value = this.morphium.createLazyLoadedEntity(fld.getType(), var11_22);
                                                                                                                break block57;
                                                                                                            } else {
                                                                                                                value = this.morphium.findById(fld.getType(), var11_22);
                                                                                                            }
                                                                                                            break block57;
                                                                                                        } else {
                                                                                                            value = null;
                                                                                                        }
                                                                                                        break block57;
                                                                                                    }
                                                                                                    if (!fld.isAnnotationPresent(Id.class)) break block63;
                                                                                                    value = o.get("_id");
                                                                                                    if (value.getClass().equals(fld.getType())) break block57;
                                                                                                    log.warn((Object)"read value and field type differ...");
                                                                                                    if (!fld.getType().equals(ObjectId.class)) break block64;
                                                                                                    log.warn((Object)"trying objectID conversion");
                                                                                                    if (value.getClass().equals(String.class)) {
                                                                                                        try {
                                                                                                            value = new ObjectId((String)value);
                                                                                                        }
                                                                                                        catch (Exception e) {
                                                                                                            log.error((Object)"Id conversion failed - setting returning null", (Throwable)e);
                                                                                                            return null;
                                                                                                        }
                                                                                                    }
                                                                                                    break block57;
                                                                                                }
                                                                                                if (value.getClass().equals(ObjectId.class)) {
                                                                                                    if (fld.getType().equals(String.class)) {
                                                                                                        value = value.toString();
                                                                                                        break block57;
                                                                                                    } else {
                                                                                                        if (!fld.getType().equals(Long.class) && !fld.getType().equals(Long.TYPE)) {
                                                                                                            log.error((Object)("cannot convert - ID IS SET TO NULL. Type read from db is " + value.getClass().getName() + " - expected value is " + fld.getType().getName()));
                                                                                                            return null;
                                                                                                        }
                                                                                                        value = ((ObjectId)value).getTime();
                                                                                                    }
                                                                                                }
                                                                                                break block57;
                                                                                            }
                                                                                            if (!this.annotationHelper.isAnnotationPresentInHierarchy(fld.getType(), Entity.class) && !this.annotationHelper.isAnnotationPresentInHierarchy(fld.getType(), Embedded.class)) break block65;
                                                                                            value = this.unmarshall(fld.getType(), (DBObject)valueFromDb);
                                                                                            break block57;
                                                                                        }
                                                                                        if (!Map.class.isAssignableFrom(fld.getType())) break block66;
                                                                                        BasicDBObject map = (BasicDBObject)valueFromDb;
                                                                                        value = this.createMap(map);
                                                                                        break block57;
                                                                                    }
                                                                                    if (!Collection.class.isAssignableFrom(fld.getType()) && !fld.getType().isArray()) break block67;
                                                                                    if (!fld.getType().equals(byte[].class)) break block68;
                                                                                    if (log.isDebugEnabled()) {
                                                                                        log.debug((Object)"Reading in binary data object");
                                                                                    }
                                                                                    value = valueFromDb;
                                                                                    break block57;
                                                                                }
                                                                                lst = new ArrayList<Object>();
                                                                                if (!valueFromDb.getClass().isArray()) break block69;
                                                                                if (!valueFromDb.getClass().getComponentType().isPrimitive()) break block70;
                                                                                if (!valueFromDb.getClass().getComponentType().equals(Integer.TYPE)) break block71;
                                                                                int[] nArray = (int[])valueFromDb;
                                                                                int len$ = nArray.length;
                                                                                for (i$2 = 0; i$2 < len$; ++i$2) {
                                                                                    int i = nArray[i$2];
                                                                                    lst.add(i);
                                                                                }
                                                                                break block72;
                                                                            }
                                                                            if (!valueFromDb.getClass().getComponentType().equals(Double.TYPE)) break block73;
                                                                            double[] dArray = (double[])valueFromDb;
                                                                            int len$ = dArray.length;
                                                                            for (i$2 = 0; i$2 < len$; ++i$2) {
                                                                                double i = dArray[i$2];
                                                                                lst.add(i);
                                                                            }
                                                                            break block72;
                                                                        }
                                                                        if (!valueFromDb.getClass().getComponentType().equals(Float.TYPE)) break block74;
                                                                        float[] fArray = (float[])valueFromDb;
                                                                        int len$ = fArray.length;
                                                                        for (i$2 = 0; i$2 < len$; ++i$2) {
                                                                            float i = fArray[i$2];
                                                                            lst.add(Float.valueOf(i));
                                                                        }
                                                                        break block72;
                                                                    }
                                                                    if (!valueFromDb.getClass().getComponentType().equals(Boolean.TYPE)) break block75;
                                                                    boolean[] blArray = (boolean[])valueFromDb;
                                                                    int len$ = blArray.length;
                                                                    for (i$2 = 0; i$2 < len$; ++i$2) {
                                                                        boolean i = blArray[i$2];
                                                                        lst.add(i);
                                                                    }
                                                                    break block72;
                                                                }
                                                                if (!valueFromDb.getClass().getComponentType().equals(Byte.TYPE)) break block76;
                                                                byte[] byArray = (byte[])valueFromDb;
                                                                int len$ = byArray.length;
                                                                for (i$2 = 0; i$2 < len$; ++i$2) {
                                                                    byte i = byArray[i$2];
                                                                    lst.add(i);
                                                                }
                                                                break block72;
                                                            }
                                                            if (!valueFromDb.getClass().getComponentType().equals(Character.TYPE)) break block77;
                                                            char[] cArray = (char[])valueFromDb;
                                                            int len$ = cArray.length;
                                                            for (i$2 = 0; i$2 < len$; ++i$2) {
                                                                char i = cArray[i$2];
                                                                lst.add(Character.valueOf(i));
                                                            }
                                                            break block72;
                                                        }
                                                        if (valueFromDb.getClass().getComponentType().equals(Long.TYPE)) {
                                                            long[] lArray = (long[])valueFromDb;
                                                            int len$ = lArray.length;
                                                            for (i$2 = 0; i$2 < len$; ++i$2) {
                                                                long i = lArray[i$2];
                                                                lst.add(i);
                                                            }
                                                        }
                                                        break block72;
                                                    }
                                                    Object[] objectArray = (Object[])valueFromDb;
                                                    int len$ = objectArray.length;
                                                    for (i$2 = 0; i$2 < len$; ++i$2) {
                                                        Object vdb = objectArray[i$2];
                                                        lst.add(vdb);
                                                    }
                                                }
                                                value = lst;
                                                break block78;
                                            }
                                            BasicDBList basicDBList = (BasicDBList)valueFromDb;
                                            if (basicDBList != null) {
                                                this.fillList(fld, basicDBList, lst);
                                            } else {
                                                value = basicDBList;
                                            }
                                        }
                                        if (!fld.getType().isArray()) break block79;
                                        object = Array.newInstance(fld.getType().getComponentType(), lst.size());
                                        break block80;
                                    }
                                    value = lst;
                                    break block57;
                                }
                                value = fld.getType().isEnum() ? Enum.valueOf(fld.getType(), (String)valueFromDb) : valueFromDb;
                                break block57;
                            }
                            if (this.annotationHelper.isAnnotationPresentInHierarchy(cls, Entity.class)) {
                                flds = this.annotationHelper.getFields(cls, Id.class);
                                if (flds.isEmpty()) {
                                    throw new RuntimeException("Error - class does not have an ID field!");
                                }
                                Field field = this.annotationHelper.getField(cls, flds.get(0));
                                if (o.get("_id") != null) {
                                    if (o.get("_id").getClass().equals(field.getType())) {
                                        field.set(ret, o.get("_id"));
                                    } else if (field.getType().equals(String.class) && o.get("_id").getClass().equals(ObjectId.class)) {
                                        log.warn((Object)"ID type missmatch - field is string but got objectId from mongo - converting");
                                        field.set(ret, o.get("_id").toString());
                                    } else if (field.getType().equals(ObjectId.class) && o.get("_id").getClass().equals(String.class)) {
                                        log.warn((Object)"ID type missmatch - field is objectId but got string from db - trying conversion");
                                        field.set(ret, new ObjectId((String)o.get("_id")));
                                    } else {
                                        log.error((Object)"ID type missmatch");
                                        throw new IllegalArgumentException("ID type missmatch. Field in '" + ret.getClass().toString() + "' is '" + field.getType().toString() + "' but we got '" + o.get("_id").getClass().toString() + "' from Mongo!");
                                    }
                                }
                            }
                            if (!this.annotationHelper.isAnnotationPresentInHierarchy(cls, PartialUpdate.class) && !cls.isInstance(PartiallyUpdateable.class)) {
                                return (T)ret;
                            }
                            return (T)this.morphium.createPartiallyUpdateableEntity(ret);
                        }
                        while (iterator.hasNext()) {
                            String k = (String)iterator.next();
                            if (flds.contains(k) || k.equals("_id")) continue;
                            data.put(k, o.get(k));
                        }
                        fld.set(ret, data);
                        continue;
                    }
                    for (int i = 0; i < lst.size(); ++i) {
                        if (fld.getType().getComponentType().isPrimitive()) {
                            if (fld.getType().getComponentType().equals(Integer.TYPE)) {
                                Array.set(object, i, (int)((Integer)lst.get(i)));
                                continue;
                            }
                            if (fld.getType().getComponentType().equals(Long.TYPE)) {
                                Array.set(object, i, (long)((Long)lst.get(i)));
                                continue;
                            }
                            if (fld.getType().getComponentType().equals(Float.TYPE)) {
                                Array.set(object, i, Float.valueOf(((Double)lst.get(i)).floatValue()));
                                continue;
                            }
                            if (fld.getType().getComponentType().equals(Double.TYPE)) {
                                Array.set(object, i, (double)((Double)lst.get(i)));
                                continue;
                            }
                            if (!fld.getType().getComponentType().equals(Boolean.TYPE)) continue;
                            Array.set(object, i, (boolean)((Boolean)lst.get(i)));
                            continue;
                        }
                        Array.set(object, i, lst.get(i));
                    }
                    value = object;
                }
                this.annotationHelper.setValue(ret, value, f);
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Object createMap(BasicDBObject map) {
        BasicDBObject value;
        if (map != null) {
            for (String n : map.keySet()) {
                if (map.get(n) instanceof BasicDBObject) {
                    Object val = map.get(n);
                    if (((BasicDBObject)val).containsField("class_name") || ((BasicDBObject)val).containsField("className")) {
                        String cn = (String)((BasicDBObject)val).get("class_name");
                        if (cn == null) {
                            cn = (String)((BasicDBObject)val).get("className");
                        }
                        try {
                            Class<?> ecls = Class.forName(cn);
                            Object obj = this.unmarshall(ecls, (DBObject)map.get(n));
                            if (obj == null) continue;
                            map.put(n, obj);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    map.put(n, this.createMap((BasicDBObject)val));
                    continue;
                }
                if (!(map.get(n) instanceof BasicDBList)) continue;
                BasicDBList lst = (BasicDBList)map.get(n);
                List mapValue = this.createList(lst);
                map.put(n, (Object)mapValue);
            }
            value = map;
        } else {
            value = null;
        }
        return value;
    }

    private List createList(BasicDBList lst) {
        ArrayList<Object> mapValue = new ArrayList<Object>();
        for (Object li : lst) {
            if (li instanceof BasicDBObject) {
                if (((BasicDBObject)li).containsField("class_name") || ((BasicDBObject)li).containsField("className")) {
                    String cn = (String)((BasicDBObject)li).get("class_name");
                    if (cn == null) {
                        cn = (String)((BasicDBObject)li).get("className");
                    }
                    try {
                        Class<?> ecls = Class.forName(cn);
                        Object obj = this.unmarshall(ecls, (DBObject)li);
                        if (obj == null) continue;
                        mapValue.add(obj);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                mapValue.add(this.createMap((BasicDBObject)li));
                continue;
            }
            if (li instanceof BasicDBList) {
                mapValue.add(this.createList((BasicDBList)li));
                continue;
            }
            mapValue.add(li);
        }
        return mapValue;
    }

    private void fillList(Field forField, BasicDBList fromDB, List toFillIn) {
        for (Object val : fromDB) {
            if (val instanceof BasicDBObject) {
                if (((BasicDBObject)val).containsField("class_name") || ((BasicDBObject)val).containsField("className")) {
                    String cn = (String)((BasicDBObject)val).get("class_name");
                    if (cn == null) {
                        cn = (String)((BasicDBObject)val).get("className");
                    }
                    try {
                        Class<?> ecls = Class.forName(cn);
                        Object um = this.unmarshall(ecls, (DBObject)val);
                        if (um == null) continue;
                        toFillIn.add(um);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                toFillIn.add(val);
                continue;
            }
            if (val instanceof ObjectId) {
                log.warn((Object)"Cannot de-reference to unknown collection - trying to add Object only");
                toFillIn.add(val);
                continue;
            }
            if (val instanceof BasicDBList) {
                ArrayList lt = new ArrayList();
                this.fillList(null, (BasicDBList)val, lt);
                toFillIn.add(lt);
                continue;
            }
            if (val instanceof DBRef) {
                try {
                    Reference reference;
                    DBRef ref = (DBRef)val;
                    Object id = ref.getId();
                    Class<?> clz = Class.forName(ref.getRef());
                    List<String> idFlds = this.annotationHelper.getFields(clz, Id.class);
                    Reference reference2 = reference = forField != null ? forField.getAnnotation(Reference.class) : null;
                    if (reference != null && reference.lazyLoading()) {
                        if (idFlds.size() == 0) {
                            throw new IllegalArgumentException("Referenced object does not have an ID? Is it an Entity?");
                        }
                        toFillIn.add(this.morphium.createLazyLoadedEntity(clz, id));
                        continue;
                    }
                    Query<?> q = this.morphium.createQueryFor(clz);
                    q = q.f(idFlds.get(0)).eq(id);
                    toFillIn.add(q.get());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            toFillIn.add(val);
        }
    }
}

