/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.Group;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.query.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AggregatorImpl<T, R>
implements Aggregator<T, R> {
    private Class<? extends T> type;
    private List<DBObject> params = new ArrayList<DBObject>();
    private Morphium morphium;
    private Class<? extends R> rType;
    private AnnotationAndReflectionHelper ah = new AnnotationAndReflectionHelper();
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        if (m != null) {
            this.ah = m.getARHelper();
            this.executor.setMaximumPoolSize((int)((double)m.getConfig().getMaxConnections() * 0.75));
        } else {
            this.ah = new AnnotationAndReflectionHelper();
        }
    }

    @Override
    public Morphium getMorphium() {
        return this.morphium;
    }

    @Override
    public void setSearchType(Class<? extends T> type) {
        this.type = type;
    }

    @Override
    public Class<? extends T> getSearchType() {
        return this.type;
    }

    @Override
    public void setResultType(Class<? extends R> type) {
        this.rType = type;
    }

    @Override
    public Class<? extends R> getResultType() {
        return this.rType;
    }

    @Override
    public Aggregator<T, R> project(Map<String, Object> m) {
        BasicDBObject o = new BasicDBObject("$project", (Object)new BasicDBObject(m));
        this.params.add((DBObject)o);
        return this;
    }

    @Override
    public Aggregator<T, R> project(String ... m) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String sm : m) {
            map.put(sm, 1);
        }
        return this.project(map);
    }

    @Override
    public Aggregator<T, R> project(BasicDBObject m) {
        BasicDBObject o = new BasicDBObject("$project", (Object)new BasicDBObject((Map)m));
        this.params.add((DBObject)o);
        return this;
    }

    @Override
    public Aggregator<T, R> match(Query<T> q) {
        BasicDBObject o = new BasicDBObject("$match", (Object)q.toQueryObject());
        this.params.add((DBObject)o);
        return this;
    }

    @Override
    public Aggregator<T, R> limit(int num) {
        BasicDBObject o = new BasicDBObject("$limit", (Object)num);
        this.params.add((DBObject)o);
        return this;
    }

    @Override
    public Aggregator<T, R> skip(int num) {
        BasicDBObject o = new BasicDBObject("$skip", (Object)num);
        this.params.add((DBObject)o);
        return this;
    }

    @Override
    public Aggregator<T, R> unwind(String listField) {
        BasicDBObject o = new BasicDBObject("$unwind", (Object)listField);
        this.params.add((DBObject)o);
        return this;
    }

    @Override
    public Aggregator<T, R> sort(String ... prefixed) {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        String[] arr$ = prefixed;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String i;
            String fld = i = arr$[i$];
            int val = 1;
            if (i.startsWith("-")) {
                fld = i.substring(1);
                val = -1;
            } else if (i.startsWith("+")) {
                fld = i.substring(1);
                val = 1;
            }
            if (i.startsWith("$") && !(fld = fld.substring(1)).contains(".")) {
                fld = this.ah.getFieldName(this.type, fld);
            }
            m.put(fld, val);
        }
        this.sort(m);
        return this;
    }

    @Override
    public Aggregator<T, R> sort(Map<String, Integer> sort) {
        BasicDBObject o = new BasicDBObject("$sort", (Object)new BasicDBObject(sort));
        this.params.add((DBObject)o);
        return this;
    }

    @Override
    public Group<T, R> group(BasicDBObject id) {
        return new Group(this, id);
    }

    @Override
    public Group<T, R> group(Map<String, String> idSubObject) {
        return new Group(this, idSubObject);
    }

    @Override
    public Group<T, R> group(String id) {
        return new Group(this, id);
    }

    @Override
    public void addOperator(DBObject o) {
        this.params.add(o);
    }

    @Override
    public List<R> aggregate() {
        return this.morphium.aggregate(this);
    }

    @Override
    public void aggregate(final AsyncOperationCallback<R> callback) {
        if (callback == null) {
            this.morphium.aggregate(this);
        }
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                List ret = AggregatorImpl.this.morphium.aggregate(AggregatorImpl.this);
                callback.onOperationSucceeded(AsyncOperationType.READ, null, System.currentTimeMillis() - start, ret, null, AggregatorImpl.this);
            }
        });
    }

    @Override
    public List<DBObject> toAggregationList() {
        return this.params;
    }
}

