/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.ConfigElement;
import de.caluga.morphium.ConfigManager;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.query.Query;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ConfigManagerImpl
implements ConfigManager {
    private static ConfigManager instance;
    private final Hashtable<String, ConfigElement> configCache = new Hashtable();
    private final Hashtable<String, Long> addedAt = new Hashtable();
    private int timeout = 3600000;
    private boolean running = true;
    private static Logger log;
    private Morphium morphium;

    @Override
    public void setTimeout(int t) {
        this.timeout = t;
    }

    @Override
    public void end() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitSettings() {
        Hashtable<String, Long> hashtable = this.addedAt;
        synchronized (hashtable) {
            this.configCache.clear();
            this.addedAt.clear();
        }
    }

    @Override
    public Morphium getMorphium() {
        return this.morphium;
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        this.morphium.addShutdownListener(this);
    }

    @Override
    public void startCleanupThread() {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (ConfigManagerImpl.this.running) {
                    try {
                        Vector<String> toRefresh = new Vector<String>();
                        Hashtable hashtable = ConfigManagerImpl.this.addedAt;
                        synchronized (hashtable) {
                            for (String k : ConfigManagerImpl.this.addedAt.keySet()) {
                                if (System.currentTimeMillis() - (Long)ConfigManagerImpl.this.addedAt.get(k) <= (long)ConfigManagerImpl.this.timeout) continue;
                                toRefresh.add(k);
                            }
                            for (String t : toRefresh) {
                                ConfigManagerImpl.this.addedAt.remove(t);
                                ConfigManagerImpl.this.configCache.remove(t);
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Exception while accessing config cache!", (Throwable)e);
                    }
                    try {
                        1.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    @Override
    public List<String> getSettings() {
        return this.getSettings(null);
    }

    @Override
    public List<String> getSettings(String regex) {
        Query<ConfigElement> q = this.morphium.createQueryFor(ConfigElement.class);
        if (regex != null) {
            q.f("name").matches(regex);
        }
        ArrayList<String> ret = new ArrayList<String>();
        List<ConfigElement> el = q.asList();
        for (ConfigElement e : el) {
            ret.add(e.getName());
            if (this.configCache.containsKey(e.getName())) continue;
            this.configCache.put(e.getName(), e);
            this.addedAt.put(e.getName(), System.currentTimeMillis());
        }
        return ret;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSetting(String k, List<String> v) {
        ConfigElement c = this.getConfigElement(k);
        c.setListValue(v);
        Hashtable<String, Long> hashtable = this.addedAt;
        synchronized (hashtable) {
            this.addedAt.put(k, System.currentTimeMillis());
        }
        this.store(k, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSetting(String k, Map<String, String> v) {
        ConfigElement c = this.getConfigElement(k);
        c.setMapValue(v);
        Hashtable<String, Long> hashtable = this.addedAt;
        synchronized (hashtable) {
            this.addedAt.put(k, System.currentTimeMillis());
        }
        this.store(k, c);
    }

    @Override
    public void addSetting(String k, String v) {
        ConfigElement c = this.getConfigElement(k);
        c.setValue(v);
        this.store(k, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(String k, ConfigElement c) {
        Query<ConfigElement> q = this.morphium.createQueryFor(ConfigElement.class);
        q.f("name").eq(k);
        List<ConfigElement> lst = this.morphium.find(q);
        if (lst.size() > 0) {
            c.setId(lst.get(0).getId());
        }
        Hashtable<String, Long> hashtable = this.addedAt;
        synchronized (hashtable) {
            this.configCache.put(k, c);
            this.storeSetting(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigElement getConfigElement(String k) {
        ConfigElement c = this.loadConfigElement(k);
        if (c == null) {
            c = new ConfigElement();
            c.setName(k);
            Hashtable<String, Long> hashtable = this.addedAt;
            synchronized (hashtable) {
                this.configCache.put(k, c);
                this.storeSetting(c);
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigElement loadConfigElement(String k) {
        Hashtable<String, Long> hashtable = this.addedAt;
        synchronized (hashtable) {
            if (this.configCache.get(k) != null) {
                return this.configCache.get(k);
            }
        }
        Query<ConfigElement> q = this.morphium.createQueryFor(ConfigElement.class);
        q = q.f("name").eq(k);
        List<ConfigElement> lst = this.morphium.find(q);
        if (lst.size() > 1) {
            log.warn((Object)("WARNING: too many entries with name " + k + " taking 1st!"));
        }
        if (lst.size() == 0) {
            return null;
        }
        ConfigElement e = lst.get(0);
        this.updateLocal(e);
        Hashtable<String, Long> hashtable2 = this.addedAt;
        synchronized (hashtable2) {
            this.configCache.put(k, e);
            this.addedAt.put(k, System.currentTimeMillis());
        }
        return e;
    }

    private void updateLocal(ConfigElement e) {
        if (e.getMapValue() != null) {
            Hashtable<String, String> v = new Hashtable<String, String>();
            for (String key : e.getMapValue().keySet()) {
                String rkey = key.replaceAll("%", ".");
                v.put(rkey, e.getMapValue().get(key));
            }
            e.setMapValue(v);
        }
    }

    @Override
    public List<String> getListSetting(String k) {
        ConfigElement ce = this.loadConfigElement(k);
        if (ce == null) {
            return null;
        }
        return ce.getListValue();
    }

    @Override
    public Map<String, String> getMapSetting(String k) {
        ConfigElement ce = this.loadConfigElement(k);
        if (ce == null) {
            return null;
        }
        return ce.getMapValue();
    }

    @Override
    public void storeSetting(ConfigElement e) {
        this.updateLocal(e);
        this.morphium.store(e);
    }

    @Override
    public String getSetting(String k) {
        ConfigElement ce = this.loadConfigElement(k);
        if (ce == null) {
            return null;
        }
        return ce.getValue();
    }

    @Override
    public void onShutdown(Morphium m) {
        this.end();
    }

    static {
        log = Logger.getLogger(ConfigManagerImpl.class);
    }
}

