/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire;

import de.bwaldvogel.mongo.backend.MongoBackend;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.exception.MongoSilentServerException;
import de.bwaldvogel.mongo.exception.NoSuchCommandException;
import de.bwaldvogel.mongo.wire.MongoWireProtocolHandler;
import de.bwaldvogel.mongo.wire.message.ClientRequest;
import de.bwaldvogel.mongo.wire.message.MessageHeader;
import de.bwaldvogel.mongo.wire.message.MongoDelete;
import de.bwaldvogel.mongo.wire.message.MongoInsert;
import de.bwaldvogel.mongo.wire.message.MongoQuery;
import de.bwaldvogel.mongo.wire.message.MongoReply;
import de.bwaldvogel.mongo.wire.message.MongoUpdate;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDatabaseHandler
extends SimpleChannelInboundHandler<ClientRequest> {
    private static final Logger log = LoggerFactory.getLogger(MongoWireProtocolHandler.class);
    private final AtomicInteger idSequence = new AtomicInteger();
    private final MongoBackend mongoBackend;
    private final ChannelGroup channelGroup;
    private final long started;
    private final Date startDate;

    public MongoDatabaseHandler(MongoBackend mongoBackend, ChannelGroup channelGroup) {
        this.channelGroup = channelGroup;
        this.mongoBackend = mongoBackend;
        this.started = System.nanoTime();
        this.startDate = new Date();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channelGroup.add((Object)ctx.channel());
        log.info("client {} connected", (Object)ctx.channel());
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        log.info("channel {} closed", (Object)ctx.channel());
        this.channelGroup.remove((Object)ctx.channel());
        this.mongoBackend.handleClose(ctx.channel());
        super.channelInactive(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ClientRequest object) throws Exception {
        if (object instanceof MongoQuery) {
            ctx.channel().writeAndFlush((Object)this.handleQuery(ctx.channel(), (MongoQuery)object));
        } else if (object instanceof MongoInsert) {
            MongoInsert insert = (MongoInsert)object;
            this.mongoBackend.handleInsert(insert);
        } else if (object instanceof MongoDelete) {
            MongoDelete delete = (MongoDelete)object;
            this.mongoBackend.handleDelete(delete);
        } else if (object instanceof MongoUpdate) {
            MongoUpdate update = (MongoUpdate)object;
            this.mongoBackend.handleUpdate(update);
        } else {
            throw new MongoServerException("unknown message: " + object);
        }
    }

    public Date getStartDate() {
        return this.startDate;
    }

    protected MongoReply handleQuery(Channel channel, MongoQuery query) {
        ArrayList<BSONObject> documents = new ArrayList<BSONObject>();
        MessageHeader header = new MessageHeader(this.idSequence.incrementAndGet(), query.getHeader().getRequestID());
        try {
            if (query.getCollectionName().startsWith("$cmd")) {
                documents.add(this.handleCommand(channel, query, documents));
            } else {
                for (BSONObject obj : this.mongoBackend.handleQuery(query)) {
                    documents.add(obj);
                }
            }
        }
        catch (NoSuchCommandException e) {
            log.error("unknown command: {}", (Object)query, (Object)e);
            BasicBSONObject obj = new BasicBSONObject();
            obj.put("errmsg", (Object)("no such cmd: " + e.getCommand()));
            obj.put("bad cmd", (Object)query.getQuery());
            obj.put("ok", (Object)0);
            documents.add((BSONObject)obj);
        }
        catch (MongoServerError e) {
            log.error("failed to handle query {}", (Object)query, (Object)e);
            BasicBSONObject obj = new BasicBSONObject();
            obj.put("errmsg", (Object)e.getMessage());
            obj.put("code", (Object)e.getCode());
            obj.put("ok", (Object)0);
            documents.add((BSONObject)obj);
        }
        catch (MongoSilentServerException e) {
            BasicBSONObject obj = new BasicBSONObject();
            obj.put("errmsg", (Object)e.getMessage());
            obj.put("ok", (Object)0);
            documents.add((BSONObject)obj);
        }
        catch (MongoServerException e) {
            log.error("failed to handle query {}", (Object)query, (Object)e);
            BasicBSONObject obj = new BasicBSONObject();
            obj.put("errmsg", (Object)e.getMessage());
            obj.put("ok", (Object)0);
            documents.add((BSONObject)obj);
        }
        return new MongoReply(header, documents);
    }

    protected BSONObject handleCommand(Channel channel, MongoQuery query, List<BSONObject> documents) throws MongoServerException {
        String collectionName = query.getCollectionName();
        if (collectionName.equals("$cmd.sys.inprog")) {
            Collection<BSONObject> currentOperations = this.mongoBackend.getCurrentOperations(query);
            return new BasicBSONObject("inprog", currentOperations);
        }
        if (collectionName.equals("$cmd")) {
            String command = (String)query.getQuery().keySet().iterator().next();
            if (command.equals("serverStatus")) {
                return this.getServerStatus();
            }
            return this.mongoBackend.handleCommand(channel, query.getDatabaseName(), command, query.getQuery());
        }
        throw new MongoServerException("unknown collection: " + collectionName);
    }

    private BSONObject getServerStatus() throws MongoServerException {
        BasicBSONObject serverStatus = new BasicBSONObject();
        try {
            serverStatus.put("host", (Object)InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            throw new MongoServerException("failed to get hostname", e);
        }
        serverStatus.put("version", (Object)"0.1");
        serverStatus.put("process", (Object)"java");
        serverStatus.put("pid", (Object)this.getProcessId());
        serverStatus.put("uptime", (Object)((int)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.started)));
        serverStatus.put("uptimeMillis", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.started));
        serverStatus.put("localTime", (Object)new Date());
        BasicBSONObject connections = new BasicBSONObject();
        connections.put("current", (Object)this.channelGroup.size());
        serverStatus.put("connections", (Object)connections);
        BasicBSONObject cursors = new BasicBSONObject();
        cursors.put("totalOpen", (Object)0);
        serverStatus.put("cursors", (Object)cursors);
        Utils.markOkay((BSONObject)serverStatus);
        return serverStatus;
    }

    private Integer getProcessId() {
        String runtimeName = ManagementFactory.getRuntimeMXBean().getName();
        if (runtimeName.contains("@")) {
            return Integer.valueOf(runtimeName.substring(0, runtimeName.indexOf(64)));
        }
        return 0;
    }
}

