/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.memory.index;

import de.bwaldvogel.mongo.backend.Constants;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.memory.index.Index;
import de.bwaldvogel.mongo.exception.DuplicateKeyError;
import de.bwaldvogel.mongo.exception.KeyConstraintError;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.BSONObject;

public class UniqueIndex
extends Index {
    private Map<Object, Integer> index = new HashMap<Object, Integer>();
    private final boolean ascending;
    private final String key;

    public UniqueIndex(String key, boolean ascending) {
        this.key = key;
        this.ascending = ascending;
    }

    @Override
    public String getName() {
        if (this.key.equals("_id")) {
            return Constants.ID_INDEX_NAME;
        }
        return this.key + "_" + (this.ascending ? "1" : "-1");
    }

    @Override
    protected Object getKeyValue(BSONObject document) {
        return Utils.normalizeValue(document.get(this.key));
    }

    @Override
    public synchronized Integer remove(BSONObject document) {
        Object value = this.getKeyValue(document);
        return this.index.remove(value);
    }

    @Override
    public synchronized void checkAdd(BSONObject document) throws KeyConstraintError {
        Object value = this.getKeyValue(document);
        if (value == null) {
            return;
        }
        if (this.index.containsKey(value)) {
            throw new DuplicateKeyError(this, value);
        }
    }

    @Override
    public synchronized void add(BSONObject document, Integer position) throws KeyConstraintError {
        this.checkAdd(document);
        Object value = this.getKeyValue(document);
        if (value != null) {
            this.index.put(value, position);
        }
    }

    @Override
    public void checkUpdate(BSONObject oldDocument, BSONObject newDocument) throws MongoServerError {
        if (this.nullAwareEqualsKeys(oldDocument, newDocument)) {
            return;
        }
        this.checkAdd(newDocument);
    }

    private boolean nullAwareEqualsKeys(BSONObject oldDocument, BSONObject newDocument) {
        Object oldKey = this.getKeyValue(oldDocument);
        Object newKey = this.getKeyValue(newDocument);
        return Utils.nullAwareEquals(oldKey, newKey);
    }

    @Override
    public void updateInPlace(BSONObject oldDocument, BSONObject newDocument) throws KeyConstraintError {
        if (this.nullAwareEqualsKeys(oldDocument, newDocument)) {
            return;
        }
    }

    @Override
    public synchronized boolean canHandle(BSONObject query) {
        if (!query.keySet().equals(Collections.singleton(this.key))) {
            return false;
        }
        Object queryValue = query.get(this.key);
        if (queryValue instanceof BSONObject) {
            for (String key : ((BSONObject)queryValue).keySet()) {
                if (key.equals("$in") || !key.startsWith("$")) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized Iterable<Integer> getPositions(BSONObject query) {
        Integer object;
        Object keyValue = this.getKeyValue(query);
        if (keyValue instanceof BSONObject) {
            BSONObject keyObj = (BSONObject)keyValue;
            if (Utils.containsQueryExpression(keyObj)) {
                if (keyObj.keySet().size() != 1) {
                    throw new UnsupportedOperationException("illegal query key: " + keyValue);
                }
                String expression = (String)keyObj.keySet().iterator().next();
                if (expression.startsWith("$")) {
                    return this.getPositionsForExpression(keyObj, expression);
                }
            }
        } else if (keyValue instanceof Pattern) {
            ArrayList<Integer> positions = new ArrayList<Integer>();
            for (Map.Entry<Object, Integer> entry : this.index.entrySet()) {
                Object obj = entry.getKey();
                Matcher matcher = ((Pattern)keyValue).matcher(obj.toString());
                if (!matcher.find()) continue;
                positions.add(entry.getValue());
            }
            return positions;
        }
        if ((object = this.index.get(keyValue)) == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(object);
    }

    private Iterable<Integer> getPositionsForExpression(BSONObject keyObj, String operator) {
        if (operator.equals("$in")) {
            TreeSet queriedObjects = new TreeSet((Collection)keyObj.get(operator));
            ArrayList<Integer> allPositions = new ArrayList<Integer>();
            for (Object object : queriedObjects) {
                Object value = Utils.normalizeValue(object);
                Integer pos = this.index.get(value);
                if (pos == null) continue;
                allPositions.add(pos);
            }
            return allPositions;
        }
        throw new UnsupportedOperationException("unsupported query expression: " + operator);
    }

    @Override
    public long getCount() {
        return this.index.size();
    }

    @Override
    public long getDataSize() {
        return this.getCount();
    }
}

