/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.memory;

import de.bwaldvogel.mongo.backend.MongoBackend;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.memory.MemoryDatabase;
import de.bwaldvogel.mongo.backend.memory.MongoDatabase;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.exception.MongoSilentServerException;
import de.bwaldvogel.mongo.exception.NoSuchCommandException;
import de.bwaldvogel.mongo.wire.message.Message;
import de.bwaldvogel.mongo.wire.message.MongoDelete;
import de.bwaldvogel.mongo.wire.message.MongoInsert;
import de.bwaldvogel.mongo.wire.message.MongoQuery;
import de.bwaldvogel.mongo.wire.message.MongoUpdate;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.TreeMap;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.jboss.netty.channel.Channel;

public class MemoryBackend
implements MongoBackend {
    private final TreeMap<String, MongoDatabase> databases = new TreeMap();

    protected BSONObject handleAdminCommand(Channel channel, String command, BSONObject query) throws MongoServerException {
        if (command.equalsIgnoreCase("listdatabases")) {
            BasicBSONObject response = new BasicBSONObject();
            ArrayList<BasicBSONObject> dbs = new ArrayList<BasicBSONObject>();
            for (MongoDatabase db : this.databases.values()) {
                BasicBSONObject dbObj = new BasicBSONObject("name", (Object)db.getDatabaseName());
                dbObj.put("empty", (Object)db.isEmpty());
                dbs.add(dbObj);
            }
            response.put("databases", dbs);
            Utils.markOkay((BSONObject)response);
            return response;
        }
        if (command.equalsIgnoreCase("replSetGetStatus")) {
            throw new MongoSilentServerException("not running with --replSet");
        }
        throw new NoSuchCommandException(command);
    }

    private synchronized MongoDatabase resolveDatabase(Message message) throws MongoServerException {
        return this.resolveDatabase(message.getDatabaseName());
    }

    private synchronized MongoDatabase resolveDatabase(String database) throws MongoServerException {
        MongoDatabase db = this.databases.get(database);
        if (db == null) {
            db = new MemoryDatabase(this, database);
            this.databases.put(database, db);
        }
        return db;
    }

    @Override
    public void handleClose(Channel channel) {
        for (MongoDatabase db : this.databases.values()) {
            db.handleClose(channel);
        }
    }

    @Override
    public BSONObject handleCommand(Channel channel, String databaseName, String command, BSONObject query) throws MongoServerException {
        if (command.equalsIgnoreCase("whatsmyuri")) {
            BasicBSONObject response = new BasicBSONObject();
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.getRemoteAddress();
            response.put("you", (Object)(remoteAddress.getAddress().getHostAddress() + ":" + remoteAddress.getPort()));
            Utils.markOkay((BSONObject)response);
            return response;
        }
        if (command.equalsIgnoreCase("ismaster")) {
            BasicBSONObject response = new BasicBSONObject("ismaster", (Object)Boolean.TRUE);
            response.put("maxBsonObjectSize", (Object)0x1000000);
            response.put("maxMessageSizeBytes", (Object)48000000);
            response.put("localTime", (Object)new Date());
            Utils.markOkay((BSONObject)response);
            return response;
        }
        if (databaseName.equals("admin")) {
            return this.handleAdminCommand(channel, command, query);
        }
        MongoDatabase db = this.resolveDatabase(databaseName);
        return db.handleCommand(channel, command, query);
    }

    @Override
    public Collection<BSONObject> getCurrentOperations(MongoQuery query) {
        return Collections.emptyList();
    }

    @Override
    public Iterable<BSONObject> handleQuery(MongoQuery query) throws MongoServerException {
        MongoDatabase db = this.resolveDatabase(query);
        return db.handleQuery(query);
    }

    @Override
    public void handleInsert(MongoInsert insert) throws MongoServerException {
        MongoDatabase db = this.resolveDatabase(insert);
        db.handleInsert(insert);
    }

    @Override
    public void handleDelete(MongoDelete delete) throws MongoServerException {
        MongoDatabase db = this.resolveDatabase(delete);
        db.handleDelete(delete);
    }

    @Override
    public void handleUpdate(MongoUpdate update) throws MongoServerException {
        MongoDatabase db = this.resolveDatabase(update);
        db.handleUpdate(update);
    }

    public void dropDatabase(MemoryDatabase memoryDatabase) {
        this.databases.remove(memoryDatabase.getDatabaseName());
    }
}

