/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.backend.aggregation.Expression;
import de.bwaldvogel.mongo.backend.aggregation.stage.AggregationStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.util.Map;
import java.util.stream.Stream;

public class AddFieldsStage
implements AggregationStage {
    private final Document addFields;

    public AddFieldsStage(Document addFields) {
        if (addFields.isEmpty()) {
            throw new MongoServerError(40177, "Invalid $addFields :: caused by :: specification must have at least one field");
        }
        this.addFields = addFields;
    }

    @Override
    public Stream<Document> apply(Stream<Document> stream) {
        return stream.map(this::projectDocument);
    }

    Document projectDocument(Document document) {
        Document result = new Document();
        for (Map.Entry<String, Object> entry : document.entrySet()) {
            String field = entry.getKey();
            if (this.addFields.containsKey(field)) {
                Object projectedValue = Expression.evaluate(this.addFields.get(field), document);
                result.put(field, projectedValue);
                continue;
            }
            result.put(field, entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.addFields.entrySet()) {
            if (result.containsKey(entry.getKey())) continue;
            Object projectedValue = Expression.evaluate(entry.getValue(), document);
            result.put(entry.getKey(), projectedValue);
        }
        return result;
    }
}

