/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import java.util.HashMap;
import java.util.Map;

enum QueryFilter {
    AND("$and"),
    OR("$or"),
    NOR("$nor");

    private final String value;
    private static final Map<String, QueryFilter> MAP;

    private QueryFilter(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    static boolean isQueryFilter(String value) {
        return MAP.containsKey(value);
    }

    static QueryFilter fromValue(String value) throws IllegalArgumentException {
        QueryFilter filter = MAP.get(value);
        if (filter == null) {
            throw new IllegalArgumentException("Illegal filter: " + value);
        }
        return filter;
    }

    public String toString() {
        return this.value;
    }

    static {
        MAP = new HashMap<String, QueryFilter>();
        for (QueryFilter filter : QueryFilter.values()) {
            QueryFilter old = MAP.put(filter.getValue(), filter);
            if (old == null) continue;
            throw new IllegalStateException("Duplicate value: " + filter.getValue());
        }
    }
}

