/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Constants;
import de.bwaldvogel.mongo.backend.QueryFilter;
import de.bwaldvogel.mongo.backend.QueryMatcher;
import de.bwaldvogel.mongo.backend.QueryOperator;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.bson.BsonRegularExpression;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.BadValueException;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultQueryMatcher
implements QueryMatcher {
    private static final Logger log = LoggerFactory.getLogger(DefaultQueryMatcher.class);
    private ValueComparator comparator = new ValueComparator();
    private Integer lastPosition;

    @Override
    public boolean matches(Document document, Document query) {
        for (String key : query.keySet()) {
            if (this.checkMatch(query.get(key), key, (Object)document)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized Integer matchPosition(Document document, Document query) {
        this.lastPosition = null;
        for (String key : query.keySet()) {
            if (this.checkMatch(query.get(key), key, (Object)document)) continue;
            return null;
        }
        return this.lastPosition;
    }

    private List<String> splitKey(String key) {
        List<String> keys = Arrays.asList(key.split("\\."));
        for (String subKey : keys) {
            if (!subKey.isEmpty()) continue;
            throw new MongoServerException("illegal key: " + key);
        }
        return keys;
    }

    private boolean checkMatch(Object queryValue, String key, Object document) {
        return this.checkMatch(queryValue, this.splitKey(key), document);
    }

    private boolean checkMatch(Object queryValue, List<String> keys, Object document) {
        if (keys.isEmpty()) {
            throw new MongoServerException("illegal keys: " + keys);
        }
        if (document == null) {
            return false;
        }
        String firstKey = keys.get(0);
        if (firstKey.equals("$comment")) {
            log.debug("query comment: '{}'", queryValue);
            return true;
        }
        List<Object> subKeys = Collections.emptyList();
        if (keys.size() > 1) {
            subKeys = keys.subList(1, keys.size());
        }
        if (QueryFilter.isQueryFilter(firstKey)) {
            QueryFilter filter = QueryFilter.fromValue(firstKey);
            return this.checkMatch(queryValue, filter, document);
        }
        if (document instanceof List) {
            Object allQuery;
            if (firstKey.matches("\\d+")) {
                Object listValue = Utils.getFieldValueListSafe(document, firstKey);
                if (subKeys.isEmpty()) {
                    return this.checkMatchesValue(queryValue, listValue, listValue != null);
                }
                return this.checkMatch(queryValue, subKeys, listValue);
            }
            if (queryValue instanceof Document && ((Document)queryValue).keySet().contains(QueryOperator.ALL.getValue()) && !this.checkMatchesAllDocuments(allQuery = ((Document)(queryValue = DefaultQueryMatcher.cloneDocument((Document)queryValue))).remove(QueryOperator.ALL.getValue()), keys, document)) {
                return false;
            }
            return this.checkMatchesAnyDocument(queryValue, keys, document);
        }
        if (!subKeys.isEmpty()) {
            Object subObject = Utils.getFieldValueListSafe(document, firstKey);
            return this.checkMatch(queryValue, subKeys, subObject);
        }
        if (!(document instanceof Document)) {
            return false;
        }
        Object value = ((Document)document).get(firstKey);
        boolean valueExists = ((Document)document).containsKey(firstKey);
        if (value instanceof Collection) {
            if (queryValue instanceof Document) {
                Set<String> keySet = ((Document)queryValue).keySet();
                Document queryValueClone = DefaultQueryMatcher.cloneDocument((Document)queryValue);
                for (String queryOperator : keySet) {
                    Document inQuery;
                    Object subQuery = queryValueClone.remove(queryOperator);
                    if (!(queryOperator.equals(QueryOperator.ALL.getValue()) ? !this.checkMatchesAllValues(subQuery, value) : (queryOperator.equals(QueryOperator.ELEM_MATCH.getValue()) ? !this.checkMatchesElemValues(subQuery, value) : (queryOperator.equals(QueryOperator.IN.getValue()) ? !this.checkMatchesAnyValue(inQuery = new Document(queryOperator, subQuery), value) : (queryOperator.equals(QueryOperator.NOT_IN.getValue()) ? this.checkMatchesAllValues(subQuery, value) : (queryOperator.equals(QueryOperator.NOT.getValue()) ? this.checkMatchesAnyValue(subQuery, value) : !this.checkMatchesAnyValue(queryValue, value) && !this.checkMatchesValue(queryValue, value, valueExists))))))) continue;
                    return false;
                }
                return true;
            }
            if (this.checkMatchesAnyValue(queryValue, value)) {
                return true;
            }
        }
        return this.checkMatchesValue(queryValue, value, valueExists);
    }

    private static Document cloneDocument(Document document) {
        return new Document(document);
    }

    private boolean checkMatch(Object queryValue, QueryFilter filter, Object document) {
        if (!(queryValue instanceof List)) {
            throw new MongoServerError(14816, (Object)((Object)filter) + " expression must be a nonempty array");
        }
        List list = (List)queryValue;
        if (list.isEmpty()) {
            throw new MongoServerError(14816, (Object)((Object)filter) + " expression must be a nonempty array");
        }
        for (Object subqueryValue : list) {
            if (subqueryValue instanceof Document) continue;
            throw new MongoServerError(14817, (Object)((Object)filter) + " elements must be objects");
        }
        switch (filter) {
            case AND: {
                for (Object subqueryValue : list) {
                    if (this.matches((Document)document, (Document)subqueryValue)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (Object subqueryValue : list) {
                    if (!this.matches((Document)document, (Document)subqueryValue)) continue;
                    return true;
                }
                return false;
            }
            case NOR: {
                return !this.checkMatch(queryValue, QueryFilter.OR, document);
            }
        }
        throw new MongoServerException("illegal query filter: " + (Object)((Object)filter) + ". must not happen");
    }

    private boolean checkMatchesAllDocuments(Object queryValue, List<String> keys, Object document) {
        for (Object query : (Collection)queryValue) {
            if (this.checkMatchesAnyDocument(query, keys, document)) continue;
            return false;
        }
        return true;
    }

    private boolean checkMatchesAnyDocument(Object queryValue, List<String> keys, Object document) {
        int i = 0;
        for (Object object : (Collection)document) {
            if (this.checkMatch(queryValue, keys, object)) {
                if (this.lastPosition == null) {
                    this.lastPosition = i;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean matchesValue(Object queryValue, Object value) {
        return this.checkMatchesValue(queryValue, value, true);
    }

    private boolean checkMatchesValue(Object queryValue, Object value, boolean valueExists) {
        if (BsonRegularExpression.isRegularExpression(queryValue)) {
            if (value == null) {
                return false;
            }
            BsonRegularExpression pattern = BsonRegularExpression.convertToRegularExpression(queryValue);
            Matcher matcher = pattern.matcher(value.toString());
            return matcher.find();
        }
        if (queryValue instanceof Document) {
            Document queryObject = (Document)queryValue;
            if (queryObject.keySet().equals(Constants.REFERENCE_KEYS)) {
                for (String key : queryObject.keySet()) {
                    Object querySubvalue = queryObject.get(key);
                    if (this.checkMatch(querySubvalue, key, value)) continue;
                    return false;
                }
                return true;
            }
            for (String key : queryObject.keySet()) {
                Object querySubvalue = queryObject.get(key);
                if (!(key.startsWith("$") ? !this.checkExpressionMatch(value, valueExists, querySubvalue, key) : !this.checkMatch(querySubvalue, key, value))) continue;
                return false;
            }
            return true;
        }
        return Utils.nullAwareEquals(value, queryValue);
    }

    private boolean checkMatchesAllValues(Object queryValue, Object values) {
        if (!(queryValue instanceof Collection)) {
            return false;
        }
        Collection list = (Collection)values;
        for (Object query : (Collection)queryValue) {
            if (this.checkMatchesAnyValue(query, list)) continue;
            return false;
        }
        return true;
    }

    private boolean checkMatchesElemValues(Object queryValue, Object values) {
        if (!(queryValue instanceof Document)) {
            throw new BadValueException(QueryOperator.ELEM_MATCH.getValue() + " needs an Object");
        }
        Collection list = (Collection)values;
        for (Object value : list) {
            if (!this.checkMatchesValue(queryValue, value, true)) continue;
            return true;
        }
        return false;
    }

    private boolean checkMatchesAnyValue(Object queryValue, Object values) {
        int i = 0;
        for (Object value : (Collection)values) {
            if (this.checkMatchesValue(queryValue, value, true)) {
                if (this.lastPosition == null) {
                    this.lastPosition = i;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkExpressionMatch(Object value, boolean valueExists, Object expressionValue, String operator) {
        QueryOperator queryOperator;
        try {
            queryOperator = QueryOperator.fromValue(operator);
        }
        catch (IllegalArgumentException e) {
            throw new MongoServerError(10068, "invalid operator: " + operator);
        }
        switch (queryOperator) {
            case IN: {
                Collection queriedObjects = (Collection)expressionValue;
                for (Object o : queriedObjects) {
                    BsonRegularExpression pattern;
                    if (!(o instanceof BsonRegularExpression && value instanceof String ? (pattern = (BsonRegularExpression)o).matcher((String)value).find() : Utils.nullAwareEquals(o, value))) continue;
                    return true;
                }
                return false;
            }
            case NOT: {
                return !this.checkMatchesValue(expressionValue, value, valueExists);
            }
            case EQUAL: {
                return Utils.nullAwareEquals(value, expressionValue);
            }
            case NOT_EQUALS: {
                return !Utils.nullAwareEquals(value, expressionValue);
            }
            case NOT_IN: {
                return !this.checkExpressionMatch(value, valueExists, expressionValue, "$in");
            }
            case EXISTS: {
                return valueExists == Utils.isTrue(expressionValue);
            }
            case GREATER_THAN: {
                if (!this.comparableTypes(value, expressionValue)) {
                    return false;
                }
                return this.comparator.compare(value, expressionValue) > 0;
            }
            case GREATER_THAN_OR_EQUAL: {
                if (!this.comparableTypes(value, expressionValue)) {
                    return false;
                }
                return this.comparator.compare(value, expressionValue) >= 0;
            }
            case LESS_THAN: {
                if (!this.comparableTypes(value, expressionValue)) {
                    return false;
                }
                return this.comparator.compare(value, expressionValue) < 0;
            }
            case LESS_THAN_OR_EQUAL: {
                if (!this.comparableTypes(value, expressionValue)) {
                    return false;
                }
                return this.comparator.compare(value, expressionValue) <= 0;
            }
            case MOD: {
                if (!(value instanceof Number)) {
                    return false;
                }
                List modValue = (List)expressionValue;
                return ((Number)value).intValue() % ((Number)modValue.get(0)).intValue() == ((Number)modValue.get(1)).intValue();
            }
            case SIZE: {
                double matchingSize;
                if (!(value instanceof Collection) || !(expressionValue instanceof Number)) {
                    return false;
                }
                int listSize = ((Collection)value).size();
                return (double)listSize == (matchingSize = ((Number)expressionValue).doubleValue());
            }
            case ALL: {
                return false;
            }
        }
        throw new IllegalArgumentException("unhandled query operator: " + (Object)((Object)queryOperator));
    }

    private boolean comparableTypes(Object value1, Object value2) {
        value1 = Utils.normalizeValue(value1);
        value2 = Utils.normalizeValue(value2);
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.getClass().equals(value2.getClass());
    }
}

