/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.aggregation.Expression;
import de.bwaldvogel.mongo.backend.aggregation.stage.AggregationStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.util.Map;
import java.util.stream.Stream;

public class ProjectStage
implements AggregationStage {
    private final Document projection;
    private final boolean hasInclusions;

    public ProjectStage(Document projection) {
        if (projection.isEmpty()) {
            throw new MongoServerError(40177, "Invalid $project :: caused by :: specification must have at least one field");
        }
        this.projection = projection;
        this.hasInclusions = ProjectStage.hasInclusions(projection);
        this.validateProjection();
    }

    private static boolean hasInclusions(Document projection) {
        return projection.values().stream().anyMatch(Utils::isTrue);
    }

    @Override
    public Stream<Document> apply(Stream<Document> stream) {
        return stream.map(this::projectDocument);
    }

    Document projectDocument(Document document) {
        Document result;
        if (this.hasInclusions) {
            result = new Document();
            if (!this.projection.containsKey("_id")) {
                Utils.copySubdocumentValue(document, result, "_id");
            }
        } else {
            result = document.cloneDeeply();
        }
        for (Map.Entry<String, Object> entry : this.projection.entrySet()) {
            String field = entry.getKey();
            Object projectionValue = entry.getValue();
            if (ProjectStage.isNumberOrBoolean(projectionValue)) {
                if (Utils.isTrue(projectionValue)) {
                    Utils.copySubdocumentValue(document, result, field);
                    continue;
                }
                Utils.removeSubdocumentValue(result, field);
                continue;
            }
            if (projectionValue == null) {
                result.put(field, (Object)null);
                continue;
            }
            Object value = Expression.evaluateDocument(projectionValue, document);
            if (value instanceof Missing) continue;
            result.put(field, value);
        }
        return result;
    }

    private void validateProjection() {
        boolean nonIdExclusion;
        if (this.hasInclusions && (nonIdExclusion = this.projection.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("_id")).map(Map.Entry::getValue).filter(ProjectStage::isNumberOrBoolean).anyMatch(entry -> !Utils.isTrue(entry)))) {
            throw new MongoServerError(40178, "Bad projection specification, cannot exclude fields other than '_id' in an inclusion projection: " + this.projection.toString(true, "{ ", " }"));
        }
    }

    private static boolean isNumberOrBoolean(Object projectionValue) {
        return projectionValue instanceof Number || projectionValue instanceof Boolean;
    }
}

