/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.aggregation.Aggregation;
import de.bwaldvogel.mongo.backend.aggregation.stage.AggregationStage;
import de.bwaldvogel.mongo.bson.Document;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FacetStage
implements AggregationStage {
    private final Map<String, Aggregation> facets = new LinkedHashMap<String, Aggregation>();

    public FacetStage(Document facetsConfiguration, MongoDatabase database, MongoCollection<?> collection) {
        for (Map.Entry<String, Object> entry : facetsConfiguration.entrySet()) {
            Aggregation aggregation = Aggregation.fromPipeline(entry.getValue(), database, collection);
            this.facets.put(entry.getKey(), aggregation);
        }
    }

    @Override
    public Stream<Document> apply(Stream<Document> stream) {
        List allDocuments = stream.collect(Collectors.toList());
        Document result = new Document();
        for (Map.Entry<String, Aggregation> entry : this.facets.entrySet()) {
            Aggregation aggregation = entry.getValue();
            List<Document> documents = aggregation.runStages(allDocuments.stream());
            result.put(entry.getKey(), (Object)documents);
        }
        return Stream.of(result);
    }
}

